/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.devices.sentience.history;

import com.tridium.json.JSONWriter;
import com.tridium.nc.devices.CloudPointData;
import com.tridium.nc.point.BCloudProxyExt;
import java.time.OffsetDateTime;
import javax.baja.history.BTrendRecord;

public class HistorySample
extends CloudPointData {
    private static final String ITEMNAME = "ItemName";
    private static final String QUALITY = "Quality";
    private static final String TIME = "Time";
    private static final String VALUE = "Value";
    protected String itemName = "";
    protected String quality = "";
    protected String time = "";
    protected Object value;
    private BCloudProxyExt proxyExt;

    public HistorySample() {
    }

    public HistorySample(String itemName, String quality, String time, Object value, BCloudProxyExt proxyExt) {
        this.itemName = itemName;
        this.quality = quality;
        this.time = this.forceMillisecondsPresent(time);
        this.value = value;
        this.proxyExt = proxyExt;
    }

    public HistorySample(String itemName, String quality, String time, Object value) {
        this.itemName = itemName;
        this.quality = quality;
        this.time = this.forceMillisecondsPresent(time);
        this.value = value;
    }

    @Override
    public void encode(JSONWriter writer) {
        writer.object();
        writer.key(ITEMNAME).value((Object)this.itemName);
        writer.key(QUALITY).value((Object)this.quality);
        writer.key(TIME).value((Object)this.time);
        writer.key(VALUE).value(this.value);
        writer.endObject();
    }

    @Override
    public void decode(Object record) {
        BTrendRecord trendRecord = (BTrendRecord)record;
        this.itemName = trendRecord.getName();
        this.quality = trendRecord.getStatus().toString();
        this.time = this.forceMillisecondsPresent(trendRecord.getTimestamp().encodeToString());
        this.value = trendRecord.asValue();
    }

    @Override
    public BCloudProxyExt getProxyExt() {
        return this.proxyExt;
    }

    private String forceMillisecondsPresent(String time) {
        OffsetDateTime parsedTime = OffsetDateTime.parse(time);
        if (parsedTime.getNano() == 0) {
            return parsedTime.withNano(1000000).toString();
        }
        return time;
    }
}

