/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.ICloudSystemCommand;
import com.tridium.nc.point.BCloudPointDeviceExt;
import com.tridium.nc.point.BSubscribePointParameter;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.sys.Context;
import javax.baja.util.Lexicon;

public class SubscribePointsCommand
implements ICloudSystemCommand {
    private String commandName;
    private final BCloudDevice device;
    private static final String CMD_NAME = "SubscribePointsCommand";
    private static final Logger log = Logger.getLogger("ncloud.point");
    private static final Lexicon LEX = Lexicon.make((String)"nCloudDriver");

    public SubscribePointsCommand(BCloudCommandsDeviceExt bCloudCommandsDeviceExt) {
        this.setCommandName(CMD_NAME);
        this.register(bCloudCommandsDeviceExt);
        this.device = (BCloudDevice)bCloudCommandsDeviceExt.getDevice();
    }

    @Override
    public void setCommandName(String cmdName) {
        this.commandName = cmdName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void runCommand(JSONObject commandProperties, Map<String, Object> responseProperties, Context cx) {
        String messageId = (String)responseProperties.get(this.device.getConstant("CORRELATIONID"));
        log.fine(() -> String.format("%s executing %s", this.commandName, messageId));
        BCloudPointDeviceExt pointDeviceExt = this.device.getPoints();
        String cmdIdKey = this.device.getConstant("COMMANDID");
        String commandID = JSONUtil.getString((JSONObject)commandProperties, (String)cmdIdKey);
        responseProperties.put(cmdIdKey, commandID);
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMAND_PAYLOAD")));
        JSONArray points = payload.getJSONArray(this.device.getConstant("POINTIDS"));
        JSONObject subscribeResults = new JSONObject();
        String pointIdKey = this.device.getConstant("POINTID");
        for (int lcv = 0; lcv < points.length(); ++lcv) {
            String pointId = JSONUtil.getString((JSONObject)points.getJSONObject(lcv), (String)pointIdKey);
            int duration = points.getJSONObject(lcv).optInt(this.device.getConstant("DURATION"), 5);
            boolean result = pointDeviceExt.doSubscribePoint(BSubscribePointParameter.make(pointId, duration, messageId), cx).getBoolean();
            subscribeResults.put(pointId, result);
        }
        responseProperties.put("PointSubscribeResults", subscribeResults);
        responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
        responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
        log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
    }
}

