/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.ICloudSystemCommand;
import com.tridium.nc.point.BCloudProxyExt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.security.BPermissions;
import javax.baja.sys.BComplex;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;

public final class RetrieveCloudPointsCommand
implements ICloudSystemCommand {
    private String commandName;
    private BCloudDevice device;
    private static final int BATCH_SIZE = 1024;
    private static final Logger log = Logger.getLogger("ncloud.command");

    public RetrieveCloudPointsCommand(BCloudCommandsDeviceExt bCloudCommandsDeviceExt) {
        this.setCommandName("RetrieveCloudPointsCommand");
        this.register(bCloudCommandsDeviceExt);
        this.device = (BCloudDevice)bCloudCommandsDeviceExt.getDevice();
    }

    @Override
    public void setCommandName(String cmdName) {
        this.commandName = cmdName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void runCommand(JSONObject commandProperties, Map<String, Object> responseProperties, Context cx) {
        String messageId = (String)responseProperties.get(this.device.getConstant("CORRELATIONID"));
        log.fine(() -> String.format("%s executing %s", this.commandName, messageId));
        String commandID = JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMANDID"));
        responseProperties.put(this.device.getConstant("COMMANDID"), commandID);
        try {
            int msgTotal;
            Map<String, Object> respProperties;
            JSONArray pointArray = new JSONArray();
            int pointCount = 0;
            ArrayList<BControlPoint> points = new ArrayList<BControlPoint>(Arrays.asList(this.device.getPoints().getPoints()));
            for (int lcv = points.size() - 1; lcv >= 0; --lcv) {
                BControlPoint controlPoint = points.get(lcv);
                BPermissions requiredPermission = BPermissions.adminRead;
                if (Flags.isOperator((BComplex)controlPoint.getParent(), (Slot)controlPoint.getPropertyInParent())) {
                    requiredPermission = BPermissions.operatorRead;
                }
                if (controlPoint.getPermissions(cx).has(requiredPermission)) continue;
                points.remove(lcv);
            }
            if (points.size() <= 1024) {
                respProperties = responseProperties;
                msgTotal = 1;
            } else {
                msgTotal = points.size() / 1024 + (points.size() % 1024 == 0 ? 0 : 1);
                respProperties = new HashMap<String, Object>();
                respProperties.put(this.device.getConstant("CORRELATIONID"), messageId);
            }
            respProperties.put(this.device.getConstant("COMMANDID"), commandID);
            for (BControlPoint point : points) {
                pointArray.put((Object)((BCloudProxyExt)point.getProxyExt()).getPointId());
                if (++pointCount % 1024 != 0 || pointCount >= points.size()) continue;
                respProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
                respProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
                respProperties.put("sequenceNum", pointCount / 1024 - 1);
                respProperties.put("segmentTotal", msgTotal);
                respProperties.put("points", pointArray);
                this.device.getCommands().sendResponse(respProperties, commandID, this.commandName);
                pointArray = new JSONArray();
            }
            if (pointArray.length() == 0) {
                responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_ERR_CODE_FORBIDDEN"));
                responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_ACCESS_NOT_ALLOWED"));
                respProperties.put("sequenceNum", 0);
                respProperties.put("segmentTotal", 1);
                respProperties.put("points", pointArray);
                this.setStatus(responseProperties, CloudUtilities.CommandStatus.Success);
                log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
                return;
            }
            responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
            responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
            responseProperties.put("SequenceNum", msgTotal - 1);
            responseProperties.put("segmentTotal", msgTotal);
            responseProperties.put("points", pointArray);
            this.setStatus(responseProperties, CloudUtilities.CommandStatus.Success);
        }
        catch (Exception e) {
            this.setStatus(responseProperties, CloudUtilities.CommandStatus.Error);
            this.setErrorMessage(responseProperties, e.toString());
            this.setErrorCode(responseProperties, 500);
        }
        log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
    }
}

