/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.ICloudSystemCommand;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.security.BPermissions;
import javax.baja.sys.Context;

public class RetrieveCloudCommandsCommand
implements ICloudSystemCommand {
    private String commandName;
    private BCloudDevice device;
    private static final Logger log = Logger.getLogger("ncloud.command");

    public RetrieveCloudCommandsCommand(BCloudCommandsDeviceExt bCloudCommandsDeviceExt) {
        this.setCommandName("RetrieveCloudCommandsCommand");
        this.register(bCloudCommandsDeviceExt);
        this.device = (BCloudDevice)bCloudCommandsDeviceExt.getDevice();
    }

    @Override
    public void setCommandName(String cmdName) {
        this.commandName = cmdName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void runCommand(JSONObject commandProperties, Map<String, Object> responseProperties, Context cx) {
        String messageId = (String)responseProperties.get(this.device.getConstant("CORRELATIONID"));
        log.fine(() -> String.format("%s executing %s", this.commandName, messageId));
        String commandID = JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMANDID"));
        responseProperties.put(this.device.getConstant("COMMANDID"), commandID);
        if (!this.device.getCommands().getPermissions(cx).has(BPermissions.adminRead)) {
            log.info(() -> String.format("%s called with insufficient permissions %s", this.commandName, messageId));
            responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_ERR_CODE_FORBIDDEN"));
            responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_ACCESS_NOT_ALLOWED"));
            log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
            return;
        }
        JSONArray commandArray = new JSONArray();
        for (String command : this.device.getCommands().getCommandSet()) {
            commandArray.put((Object)command);
        }
        responseProperties.put("commands", commandArray);
        responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
        responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
        log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
    }
}

