/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.nc.CloudMessageCallback;
import com.tridium.nc.cmds.BCloudCommandStatus;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.devices.CloudMessage;
import com.tridium.nc.devices.sentience.SentienceDecodeMsg;
import java.util.logging.Logger;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.user.BUser;

public class MessageCallbackHandler {
    private String messageId;
    private CloudMessage message;
    private CloudMessageCallback callback;
    private BUser user;
    private BCloudCommandStatus status;
    private static final Logger log = Logger.getLogger("ncloud.command");

    public MessageCallbackHandler(String messageId, CloudMessage message, CloudMessageCallback callback, BUser user) {
        this.messageId = messageId;
        this.message = message;
        this.callback = callback;
        this.user = user;
        this.status = BCloudCommandStatus.Enqueued;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public CloudMessage getMessage() {
        return this.message;
    }

    public CloudMessageCallback getCallback() {
        return this.callback;
    }

    public BUser getUser() {
        return this.user;
    }

    BCloudCommandStatus getStatus() {
        return this.status;
    }

    void setStatus(BCloudCommandStatus newStatus) {
        this.status = newStatus;
    }

    public void execute() {
        log.finer(() -> String.format("Invoking callback handler %s :: %s", this.messageId, this.message != null ? ":: " + this.message.toString() : ":: null"));
        if (!(this.callback instanceof BCloudCommandsDeviceExt.CloudCommandCallback)) {
            String command = "unknown";
            String callingIdentity = "unknown";
            if (this.message instanceof SentienceDecodeMsg) {
                SentienceDecodeMsg sdMessage = (SentienceDecodeMsg)this.message;
                command = sdMessage.getCommand();
                callingIdentity = sdMessage.getCaller();
            }
            String finalCommand = command;
            String finalCaller = callingIdentity;
            log.info(() -> String.format("Sentience Command received message id=%s, user=%s, calling identity=%s, command=%s", this.messageId, this.user.getName(), finalCaller, finalCommand));
        }
        this.callback.onMessage(this.messageId, this.message, (Context)new BasicContext(this.user));
        log.finer("Callback handler finished " + this.messageId);
    }
}

