/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc;

import com.tridium.cloud.client.BICloudConnector;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONStringer;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.BNiagaraCloudNetwork;
import com.tridium.nc.devices.sentience.BCloudSentienceDevice;
import com.tridium.nc.devices.sentience.events.EventData;
import com.tridium.nc.point.BCloudProxyExt;
import com.tridium.nc.point.BCloudWriteController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDriverContainer;
import javax.baja.history.BIHistory;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.query.BQueryResult;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;

public final class CloudUtilities {
    public static final String CLOUD_TAG_ID = "hon:CloudId";
    public static final Id CLOUD_ID_TAG = Id.newId((String)"hon:CloudId");
    public static final String CLOUD_POINT_READ_REQUEST = "CloudPointReadRequest";
    public static final String CLOUD_MULTI_POINT_READ_REQUEST = "CloudMultiPointReadRequest";
    public static final String CLOUD_POINT_WRITE_REQUEST = "CloudPointWriteRequest";
    public static final String CLOUD_MULTI_POINT_WRITE_REQUEST = "CloudMultiPointWriteRequest";
    public static final String CLOUD_ALARM_ACK_REQUEST = "CloudAlarmAckRequest";
    public static final String CLOUD_LAST_HISTORY_REPSONSE = "CloudLastHistoryResponse";
    public static final String CLOUD_COMMANDS_REPSONSE = "CloudCommandsResponse";
    public static final Context fallbackContext = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return "nchsd:fallbackContext";
        }
    };
    public static final char STATION_DELIMITER = '!';
    private static final char OLD_STATION_DELIMITER = '|';
    public static final char ESCAPE_CHARACTER = '$';
    public static final String HISTORY_PREFIX = "history:/";
    public static final String POINT_ID_PROPERTY_NAME = "id";
    public static final String WRITE_LINK_PREFIX = "writeLink_";
    public static final String WRITE_INFO_PREFIX = "cloudWrite";
    public static final int WRITE_INFO_PREFIX_LEN = "cloudWrite".length();
    public static final String ESCAPED_QUOTE = "\"";
    private static final Logger log = Logger.getLogger("ncloud");
    private static final Logger ptLog = Logger.getLogger("ncloud.point");

    private CloudUtilities() {
    }

    public static BComponent getParent(BComponent child, Type parentType) {
        BComplex p;
        for (p = child.getParent(); p != null && !p.getType().is(parentType); p = p.getParent()) {
        }
        return (BComponent)p;
    }

    public static String makePointId(BCloudProxyExt pExt) {
        String ptId;
        BControlPoint origPoint;
        Optional optTag;
        if (BNiagaraCloudNetwork.getNiagaraCloudNetwork().getUseDriverIdForPointId() && (optTag = (origPoint = (BControlPoint)pExt.getOrdPath().get((BObject)pExt)).tags().get(CLOUD_ID_TAG)).isPresent()) {
            ptLog.finest(() -> String.format("CloudId tag found.  Using the existing value (%s) as the point id", optTag.get()));
            return ((BIDataValue)optTag.get()).toString();
        }
        if (pExt.getCloudPointDeviceExt().getUseHandleForPointId()) {
            BControlPoint pt = pExt.getParentPoint();
            ptId = Sys.getStation().getStationName() + '!' + pt.getHandle();
            ptLog.finest(() -> String.format("makePointId(); handle=%s, ptId=%s", pt.getHandle(), ptId));
            return ptId;
        }
        SlotPath fullPath = pExt.getParentPoint().getSlotPath();
        ptId = Sys.getStation().getStationName() + '!' + String.join((CharSequence)"/", Arrays.copyOfRange(fullPath.getNames(), 4, fullPath.depth()));
        ptLog.finest(() -> String.format("makePointId(); fullPath=%s, ptId=%s", fullPath, ptId));
        return ptId;
    }

    public static String makePointId(BIHistory localHistory) {
        if (BNiagaraCloudNetwork.getNiagaraCloudNetwork().getUseDriverIdForPointId()) {
            BOrdList list = localHistory.getConfig().getSource();
            for (int i = list.size() - 1; i >= 0; --i) {
                BOrd source = list.get(i).getOrd();
                try {
                    BComponent histSrc = source.get().asComponent();
                    Optional optTag = histSrc.tags().get(CLOUD_ID_TAG);
                    if (optTag.isPresent()) {
                        ptLog.finest(() -> String.format("CloudId tag found on history source.  Using the existing value (%s) as the point id", ((BIDataValue)optTag.get()).toString()));
                        return ((BIDataValue)optTag.get()).toString();
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return SlotPath.escape((String)(HISTORY_PREFIX + localHistory.getId().toString()));
    }

    public static BControlPoint getPoint(String pointId) {
        BControlPoint point = null;
        log.finest("Looking for a point with the id of " + pointId);
        if (!BNiagaraCloudNetwork.getNiagaraCloudNetwork().isRunning()) {
            return null;
        }
        try {
            BValue value;
            BOrd ptOrd = null;
            String stationName = Sys.getStation().getStationName();
            int stationNameLen = stationName.length();
            if (BNiagaraCloudNetwork.getNiagaraCloudNetwork().getUseDriverIdForPointId()) {
                try {
                    BQueryResult possiblePointsWithTag = CloudUtilities.getNeqlResults(pointId);
                    Iterator resultIterator = possiblePointsWithTag.cursor().iterator();
                    int numResults = 0;
                    while (resultIterator.hasNext()) {
                        BIObject src = (BIObject)resultIterator.next();
                        if (src instanceof BControlPoint) {
                            if (++numResults > 1) {
                                log.warning("Multiple tags have a hon:CloudId value of " + pointId);
                                return null;
                            }
                            BControlPoint srcPt = (BControlPoint)src;
                            BCloudProxyExt proxyExt = ((BCloudDevice)BNiagaraCloudNetwork.getNiagaraCloudNetwork().getDevices()[0].as(BCloudDevice.class)).getPoints().getProxyExtBySource(srcPt);
                            if (proxyExt == null) continue;
                            ptOrd = proxyExt.getParentPoint().getAbsoluteOrd();
                            continue;
                        }
                        log.finest(() -> String.format("pointId %s references non-proxy point object %s", pointId, src));
                    }
                    log.finest(String.format("Number of points found %s", numResults));
                }
                catch (Exception e) {
                    log.log(Level.CONFIG, "Error getting point by CloudId", e);
                }
            }
            if (ptOrd == null) {
                log.finest("Point Id does not exist as a tag of hon:CloudId.  Checking if this is a CloudPoint.");
                if (stationName.equalsIgnoreCase(pointId.substring(0, stationNameLen))) {
                    char delim = pointId.charAt(stationNameLen);
                    String abbrevPointId = "";
                    if (delim == '$') {
                        abbrevPointId = SlotPath.unescape((String)pointId.substring(stationNameLen)).substring(1);
                        ptOrd = CloudUtilities.getPointOrd(abbrevPointId);
                    } else if (delim == '!') {
                        abbrevPointId = pointId.substring(stationNameLen + 1);
                        ptOrd = CloudUtilities.getPointOrd(abbrevPointId);
                    } else if (delim == '|') {
                        abbrevPointId = pointId.substring(pointId.indexOf(124) + 1);
                        ptOrd = BOrd.make((String)("local:|station:|" + abbrevPointId));
                    }
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(String.format("getPoint(%s): abbrevPointId:%s, ptOrd:%s", pointId, abbrevPointId, ptOrd));
                    }
                }
            }
            if (ptOrd == null) {
                ptLog.warning(String.format("Received ord %s not for this system", pointId));
            }
            BValue bValue = value = ptOrd != null ? (BValue)ptOrd.get() : null;
            if (value instanceof BControlPoint) {
                if (((BControlPoint)value.as(BControlPoint.class)).getProxyExt().getType().is(BCloudProxyExt.TYPE)) {
                    point = (BControlPoint)value;
                } else {
                    ptLog.warning(String.format("Received ord %s is a Control Point on the System but does not have a BCloud Proxy Ext.", pointId));
                }
            } else {
                ptLog.warning(String.format("Received ord %s is not a Control Point on the System", pointId));
            }
        }
        catch (Exception e) {
            ptLog.warning(String.format("Could not resolve point ord: %s", pointId));
        }
        if (ptLog.isLoggable(Level.FINER)) {
            ptLog.finer(String.format("Resolved pointId %s to point %s", pointId, point != null ? String.valueOf(point.getSlotPath()) : "null"));
        }
        return point;
    }

    private static BOrd getPointOrd(String abbrevPointId) {
        BNiagaraCloudNetwork net = BNiagaraCloudNetwork.getNiagaraCloudNetwork();
        BCloudDevice dev = (BCloudDevice)net.getDevices()[0].as(BCloudDevice.class);
        BOrd ptOrd = dev.getPoints().getUseHandleForPointId() ? BOrd.make((String)("local:|station:|h:" + abbrevPointId)) : BOrd.make((String)("local:|station:|" + net.getSlotPathOrd() + '/' + dev.getName() + "/points/" + abbrevPointId));
        return ptOrd;
    }

    public static BCloudProxyExt cloudProxy(BControlPoint pt) {
        return (BCloudProxyExt)pt.getProxyExt().as(BCloudProxyExt.class);
    }

    public static BCloudWriteController cloudWriteController(BControlPoint pt) {
        return (BCloudWriteController)pt.get("cloudWriteController").as(BCloudWriteController.class);
    }

    public static boolean isPointReadAllowed(BNiagaraCloudNetwork network, BControlPoint point, Context cx) {
        if (!network.getPointReadAllowed()) {
            return false;
        }
        BOrd absoluteOrd = point.getAbsoluteOrd();
        if (absoluteOrd != null && CloudUtilities.isOrdAllowed(absoluteOrd)) {
            if (Flags.isOperator((BComplex)point.getParent(), (Slot)point.getPropertyInParent())) {
                return point.getPermissions(cx).hasOperatorRead();
            }
            return point.getPermissions(cx).hasAdminRead();
        }
        return false;
    }

    public static boolean isPointWriteAllowed(BNiagaraCloudNetwork network, BControlPoint point, Context cx) {
        if (!network.getPointWriteAllowed()) {
            return false;
        }
        BOrd absoluteOrd = point.getAbsoluteOrd();
        if (absoluteOrd != null && CloudUtilities.isOrdAllowed(absoluteOrd)) {
            if (Flags.isOperator((BComplex)point.getParent(), (Slot)point.getPropertyInParent())) {
                return point.getPermissions(cx).hasOperatorWrite();
            }
            return point.getPermissions(cx).hasAdminWrite();
        }
        return false;
    }

    private static boolean isOrdAllowed(BOrd parentOrd) {
        OrdQuery[] queryList;
        boolean allowed = true;
        for (OrdQuery ord : queryList = parentOrd.parse()) {
            String scheme = ord.getScheme();
            if ("local".equals(scheme) || "station".equals(scheme) || "h".equals(scheme) || "slot".equals(scheme)) continue;
            allowed = false;
            break;
        }
        return allowed;
    }

    private static BQueryResult getNeqlResults(String pointId) {
        BOrd ord = BOrd.make((String)String.format("station:|slot:/|neql:hon:CloudId=\"%s\"", pointId));
        BQueryResult result = (BQueryResult)ord.get();
        return result;
    }

    public static boolean canSendMessage(BCloudDevice cloudDevice) {
        return cloudDevice != null && !cloudDevice.isDisabled() && cloudDevice.getNiagaraCloudNetwork() != null && !cloudDevice.getNiagaraCloudNetwork().isDisabled() && cloudDevice.resolveConnector() != null && cloudDevice.resolveConnector().isConnected();
    }

    public static String emptyJsonObject() {
        JSONStringer writer = new JSONStringer();
        writer.object();
        writer.endObject();
        return writer.toString();
    }

    public static List<EventData> buildEvent(BCloudDevice cloudDevice, String messageId, int responseCode, String responseText) {
        BICloudConnector connector = cloudDevice.resolveConnector();
        ArrayList<EventData> events = new ArrayList<EventData>();
        JSONObject body = new JSONObject();
        body.put(cloudDevice.getConstant("CORRELATIONID"), (Object)messageId);
        body.put(cloudDevice.getConstant("RESPONSE_CODE"), responseCode);
        body.put(cloudDevice.getConstant("ERROR_MESSAGE"), (Object)responseText);
        EventData event = new EventData(UUID.randomUUID().toString(), BAbsTime.now().encodeToString(), connector.getId(), messageId, "command", body, null, "system command update");
        events.add(event);
        return events;
    }

    public static String toStatusString(BStatus s) {
        return ESCAPED_QUOTE + s.toString() + ESCAPED_QUOTE;
    }

    public static void removeAll(BComponent comp, Class<?> cls) {
        Property[] props;
        for (Property p : props = comp.getPropertiesArray()) {
            if (cls.isInstance(comp.get(p))) {
                comp.remove(p);
                continue;
            }
            if (!comp.get(p).isComponent()) continue;
            CloudUtilities.removeAll(comp.get(p).asComponent(), cls);
        }
    }

    public static BCloudSentienceDevice getCloudSentienceDevice() {
        BNiagaraCloudNetwork network;
        BCloudSentienceDevice[] devices;
        BDriverContainer driverContainer = (BDriverContainer)Sys.getService((Type)BDriverContainer.TYPE);
        BNiagaraCloudNetwork[] cloudNetworks = (BNiagaraCloudNetwork[])driverContainer.getChildren(BNiagaraCloudNetwork.class);
        if (cloudNetworks.length > 0 && (devices = (BCloudSentienceDevice[])(network = cloudNetworks[0]).getChildren(BCloudSentienceDevice.class)).length > 0) {
            return devices[0];
        }
        return null;
    }

    public static enum CommandStatus {
        Unknown(0),
        Success(1),
        Error(2);

        private final int value;

        private CommandStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

