/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.export.impl.destination;

import java.io.IOException;
import java.io.InputStream;
import javax.baja.export.BIExportDestinationType;
import javax.baja.export.BITransformOperation;
import javax.baja.export.ExportException;
import javax.baja.file.BajaFileUtil;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType
@NiagaraSingleton
public final class BFileDestinationType
extends BSingleton
implements BIExportDestinationType<Context> {
    @Generated
    public static final BFileDestinationType INSTANCE = new BFileDestinationType();
    @Generated
    public static final Type TYPE = Sys.loadType(BFileDestinationType.class);
    private static final LexiconModule LEX = LexiconModule.make((String)"export");
    private final BajaFileUtil.BajaFileWriter fileWriter = BajaFileUtil.getDefaultFileWriter();

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BFileDestinationType() {
    }

    @Override
    public String getDisplayName(Context cx) {
        return LEX.get("exporter.action.save.label", cx);
    }

    @Override
    public <T, X extends Context> void transform(BITransformOperation<T, ? super X> transformOperation, X cx) throws IOException, ExportException {
        String fileOrd = BFileDestinationType.getFileOrd(cx);
        try (InputStream data = transformOperation.doTransform(cx);){
            this.fileWriter.replaceFile(BOrd.make((String)fileOrd), data, cx);
        }
    }

    private static String getFileOrd(Context cx) throws ExportException {
        BObject fileOrd = cx.getFacet("fileOrd");
        if (fileOrd == null) {
            throw new ExportException("fileOrd facet required");
        }
        return fileOrd.toString();
    }
}

