/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.util;

import com.tridium.kitControl.enums.BResetLimitsExceededMode;
import com.tridium.kitControl.math.BMath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="inA", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)"), @NiagaraProperty(name="inputLowLimit", type="BStatusNumeric", defaultValue="new BStatusNumeric()"), @NiagaraProperty(name="inputHighLimit", type="BStatusNumeric", defaultValue="new BStatusNumeric()"), @NiagaraProperty(name="outputLowLimit", type="BStatusNumeric", defaultValue="new BStatusNumeric()"), @NiagaraProperty(name="outputHighLimit", type="BStatusNumeric", defaultValue="new BStatusNumeric()"), @NiagaraProperty(name="inputLimitsExceededMode", type="BResetLimitsExceededMode", defaultValue="BResetLimitsExceededMode.useExceededLimit")})
public class BReset
extends BMath {
    @Generated
    public static final Property inA = BReset.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    @Generated
    public static final Property inputLowLimit = BReset.newProperty((int)0, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property inputHighLimit = BReset.newProperty((int)0, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property outputLowLimit = BReset.newProperty((int)0, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property outputHighLimit = BReset.newProperty((int)0, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property inputLimitsExceededMode = BReset.newProperty((int)0, (BValue)BResetLimitsExceededMode.useExceededLimit, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BReset.class);
    private static final BIcon icon = BIcon.std((String)"control/math/reset.png");

    @Generated
    public BStatusNumeric getInA() {
        return (BStatusNumeric)this.get(inA);
    }

    @Generated
    public void setInA(BStatusNumeric v) {
        this.set(inA, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getInputLowLimit() {
        return (BStatusNumeric)this.get(inputLowLimit);
    }

    @Generated
    public void setInputLowLimit(BStatusNumeric v) {
        this.set(inputLowLimit, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getInputHighLimit() {
        return (BStatusNumeric)this.get(inputHighLimit);
    }

    @Generated
    public void setInputHighLimit(BStatusNumeric v) {
        this.set(inputHighLimit, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getOutputLowLimit() {
        return (BStatusNumeric)this.get(outputLowLimit);
    }

    @Generated
    public void setOutputLowLimit(BStatusNumeric v) {
        this.set(outputLowLimit, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getOutputHighLimit() {
        return (BStatusNumeric)this.get(outputHighLimit);
    }

    @Generated
    public void setOutputHighLimit(BStatusNumeric v) {
        this.set(outputHighLimit, (BValue)v, null);
    }

    @Generated
    public BResetLimitsExceededMode getInputLimitsExceededMode() {
        return (BResetLimitsExceededMode)this.get(inputLimitsExceededMode);
    }

    @Generated
    public void setInputLimitsExceededMode(BResetLimitsExceededMode v) {
        this.set(inputLimitsExceededMode, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void onExecute(BStatusValue o, Context cx) {
        BStatusNumeric inA = this.getInA();
        BStatus sa = inA.getStatus();
        BStatusNumeric out = (BStatusNumeric)o;
        BStatusNumeric inputLowLimit = this.getInputLowLimit();
        BStatusNumeric inputHighLimit = this.getInputHighLimit();
        BStatusNumeric outputLowLimit = this.getOutputLowLimit();
        BStatusNumeric outputHighLimit = this.getOutputHighLimit();
        BStatus ilStatus = inputLowLimit.getStatus();
        BStatus ihStatus = inputHighLimit.getStatus();
        BStatus olStatus = outputLowLimit.getStatus();
        BStatus ohStatus = outputHighLimit.getStatus();
        if (ilStatus.isNull() || ihStatus.isNull() || olStatus.isNull() || ohStatus.isNull() || sa.isNull()) {
            out.setValue(Double.NaN);
            out.setStatus(BStatus.nullStatus);
        } else if (this.getInputLimitsExceededMode().equals((Object)BResetLimitsExceededMode.setStatusToNull) && (Double.isNaN(inA.getValue()) || Double.isNaN(inputLowLimit.getValue()) || Double.isNaN(inputHighLimit.getValue()))) {
            out.setValue(Double.NaN);
            out.setStatus(BStatus.nullStatus);
        } else {
            this.reset(inA, out, inputLowLimit.getValue(), inputHighLimit.getValue(), outputLowLimit.getValue(), outputHighLimit.getValue());
        }
    }

    private void reset(BStatusNumeric inA, BStatusNumeric out, double inputLowLimit, double inputHighLimit, double outputLowLimit, double outputHighLimit) {
        boolean limitExceeded = false;
        double in = inA.getValue();
        if (in < inputLowLimit) {
            out.setValue(outputLowLimit);
            limitExceeded = true;
        } else if (in > inputHighLimit) {
            out.setValue(outputHighLimit);
            limitExceeded = true;
        } else {
            double result = (outputHighLimit - outputLowLimit) / (inputHighLimit - inputLowLimit) * (in - inputLowLimit) + outputLowLimit;
            out.setValue(result);
        }
        if (limitExceeded && this.getInputLimitsExceededMode().equals((Object)BResetLimitsExceededMode.setStatusToNull)) {
            out.setStatus(BStatus.nullStatus);
        } else {
            out.setStatus(this.propagate(inA.getStatus()));
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

