/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.hvac;

import com.tridium.kitControl.enums.BLoopAction;
import com.tridium.kitControl.logic.BLogic;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="cv", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)"), @NiagaraProperty(name="sp", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)"), @NiagaraProperty(name="diff", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)"), @NiagaraProperty(name="action", type="BLoopAction", defaultValue="BLoopAction.direct"), @NiagaraProperty(name="nullOnInControl", type="boolean", defaultValue="true")})
public class BTstat
extends BLogic {
    @Generated
    public static final Property cv = BTstat.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    @Generated
    public static final Property sp = BTstat.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    @Generated
    public static final Property diff = BTstat.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    @Generated
    public static final Property action = BTstat.newProperty((int)0, (BValue)BLoopAction.direct, null);
    @Generated
    public static final Property nullOnInControl = BTstat.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTstat.class);
    boolean inControl = false;

    @Generated
    public BStatusNumeric getCv() {
        return (BStatusNumeric)this.get(cv);
    }

    @Generated
    public void setCv(BStatusNumeric v) {
        this.set(cv, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getSp() {
        return (BStatusNumeric)this.get(sp);
    }

    @Generated
    public void setSp(BStatusNumeric v) {
        this.set(sp, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getDiff() {
        return (BStatusNumeric)this.get(diff);
    }

    @Generated
    public void setDiff(BStatusNumeric v) {
        this.set(diff, (BValue)v, null);
    }

    @Generated
    public BLoopAction getAction() {
        return (BLoopAction)this.get(action);
    }

    @Generated
    public void setAction(BLoopAction v) {
        this.set(action, (BValue)v, null);
    }

    @Generated
    public boolean getNullOnInControl() {
        return this.getBoolean(nullOnInControl);
    }

    @Generated
    public void setNullOnInControl(boolean v) {
        this.setBoolean(nullOnInControl, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void onExecute(BStatusValue o, Context cx) {
        BStatusNumeric controlVariable = this.getCv();
        BStatusNumeric setpoint = this.getSp();
        BStatusBoolean out = (BStatusBoolean)o;
        BStatus sa = controlVariable.getStatus();
        BStatus sb = setpoint.getStatus();
        if (sa.isNull() || sb.isNull()) {
            out.setValue(false);
            out.setStatus(BStatus.nullStatus);
        } else {
            out.setStatus(this.propagate(BStatus.make((int)(sa.getBits() | sb.getBits()))));
            if (!sa.isValid() || !sb.isValid()) {
                out.setValue(false);
            } else {
                out.setValue(this.calculate());
            }
            if (this.getNullOnInactive() && !out.getValue()) {
                out.setStatusNull(true);
            } else if (this.getNullOnInControl() && this.inControl) {
                out.setStatusNull(true);
            }
        }
    }

    protected boolean calculate() {
        double currentValue;
        double halfDiff = this.getDiff().getValue() / 2.0;
        double highValue = this.getSp().getValue() + halfDiff;
        double lowValue = this.getSp().getValue() - halfDiff;
        boolean returnValue = this.getOut().getValue();
        if (this.getAction() != BLoopAction.direct) {
            boolean bl = returnValue = !returnValue;
        }
        if ((currentValue = this.getCv().getValue()) >= highValue) {
            returnValue = true;
        } else if (currentValue <= lowValue) {
            returnValue = false;
        }
        if (this.getAction() != BLoopAction.direct) {
            returnValue = !returnValue;
        }
        this.inControl = currentValue > lowValue && currentValue < highValue;
        return returnValue;
    }
}

