/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.energy;

import com.tridium.kitControl.enums.BOutsideAirOptimizationMode;
import com.tridium.kitControl.hvac.Psychrometric;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="temperatureFacets", type="BFacets", defaultValue="BFacets.makeNumeric(UnitDatabase.getUnit(\"fahrenheit\"), 1)"), @NiagaraProperty(name="humidityFacets", type="BFacets", defaultValue="BFacets.makeNumeric(UnitDatabase.getUnit(\"percent relative humidity\"), 1)"), @NiagaraProperty(name="outsideTemp", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=8), @NiagaraProperty(name="outsideHumidity", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=8), @NiagaraProperty(name="insideTemp", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=8), @NiagaraProperty(name="insideHumidity", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=8), @NiagaraProperty(name="lowTemperatureLimit", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=8), @NiagaraProperty(name="outsideEnthalpy", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=10), @NiagaraProperty(name="outsideEnthalpyString", type="BStatusString", defaultValue="new BStatusString(\"\")", flags=10), @NiagaraProperty(name="insideEnthalpy", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=10), @NiagaraProperty(name="insideEnthalpyString", type="BStatusString", defaultValue="new BStatusString(\"\")", flags=10), @NiagaraProperty(name="freeCooling", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=10), @NiagaraProperty(name="currentMode", type="BStatusEnum", defaultValue="new BStatusEnum(BOutsideAirOptimizationMode.noFreeCooling)", flags=11), @NiagaraProperty(name="thresholdSpan", type="float", defaultValue="1.0f"), @NiagaraProperty(name="useEnthalpy", type="boolean", defaultValue="true"), @NiagaraProperty(name="freeCoolingCommand", type="boolean", defaultValue="true"), @NiagaraProperty(name="useNullOutput", type="boolean", defaultValue="true")})
@NiagaraAction(name="calculate")
public class BOutsideAirOptimization
extends BComponent {
    @Generated
    public static final Property temperatureFacets = BOutsideAirOptimization.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)1), null);
    @Generated
    public static final Property humidityFacets = BOutsideAirOptimization.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"percent relative humidity"), (int)1), null);
    @Generated
    public static final Property outsideTemp = BOutsideAirOptimization.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property outsideHumidity = BOutsideAirOptimization.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property insideTemp = BOutsideAirOptimization.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property insideHumidity = BOutsideAirOptimization.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property lowTemperatureLimit = BOutsideAirOptimization.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property outsideEnthalpy = BOutsideAirOptimization.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property outsideEnthalpyString = BOutsideAirOptimization.newProperty((int)10, (BValue)new BStatusString(""), null);
    @Generated
    public static final Property insideEnthalpy = BOutsideAirOptimization.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property insideEnthalpyString = BOutsideAirOptimization.newProperty((int)10, (BValue)new BStatusString(""), null);
    @Generated
    public static final Property freeCooling = BOutsideAirOptimization.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property currentMode = BOutsideAirOptimization.newProperty((int)11, (BValue)new BStatusEnum((BEnum)BOutsideAirOptimizationMode.noFreeCooling), null);
    @Generated
    public static final Property thresholdSpan = BOutsideAirOptimization.newProperty((int)0, (float)1.0f, null);
    @Generated
    public static final Property useEnthalpy = BOutsideAirOptimization.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property freeCoolingCommand = BOutsideAirOptimization.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property useNullOutput = BOutsideAirOptimization.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action calculate = BOutsideAirOptimization.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOutsideAirOptimization.class);
    static String engUnits = " BTU/lb";
    static String OUT_OF_RANGE = "Input out of range";
    static String UNUSED = "Unused";
    boolean lowTemp = false;

    @Generated
    public BFacets getTemperatureFacets() {
        return (BFacets)this.get(temperatureFacets);
    }

    @Generated
    public void setTemperatureFacets(BFacets v) {
        this.set(temperatureFacets, (BValue)v, null);
    }

    @Generated
    public BFacets getHumidityFacets() {
        return (BFacets)this.get(humidityFacets);
    }

    @Generated
    public void setHumidityFacets(BFacets v) {
        this.set(humidityFacets, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getOutsideTemp() {
        return (BStatusNumeric)this.get(outsideTemp);
    }

    @Generated
    public void setOutsideTemp(BStatusNumeric v) {
        this.set(outsideTemp, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getOutsideHumidity() {
        return (BStatusNumeric)this.get(outsideHumidity);
    }

    @Generated
    public void setOutsideHumidity(BStatusNumeric v) {
        this.set(outsideHumidity, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getInsideTemp() {
        return (BStatusNumeric)this.get(insideTemp);
    }

    @Generated
    public void setInsideTemp(BStatusNumeric v) {
        this.set(insideTemp, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getInsideHumidity() {
        return (BStatusNumeric)this.get(insideHumidity);
    }

    @Generated
    public void setInsideHumidity(BStatusNumeric v) {
        this.set(insideHumidity, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getLowTemperatureLimit() {
        return (BStatusNumeric)this.get(lowTemperatureLimit);
    }

    @Generated
    public void setLowTemperatureLimit(BStatusNumeric v) {
        this.set(lowTemperatureLimit, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getOutsideEnthalpy() {
        return (BStatusNumeric)this.get(outsideEnthalpy);
    }

    @Generated
    public void setOutsideEnthalpy(BStatusNumeric v) {
        this.set(outsideEnthalpy, (BValue)v, null);
    }

    @Generated
    public BStatusString getOutsideEnthalpyString() {
        return (BStatusString)this.get(outsideEnthalpyString);
    }

    @Generated
    public void setOutsideEnthalpyString(BStatusString v) {
        this.set(outsideEnthalpyString, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getInsideEnthalpy() {
        return (BStatusNumeric)this.get(insideEnthalpy);
    }

    @Generated
    public void setInsideEnthalpy(BStatusNumeric v) {
        this.set(insideEnthalpy, (BValue)v, null);
    }

    @Generated
    public BStatusString getInsideEnthalpyString() {
        return (BStatusString)this.get(insideEnthalpyString);
    }

    @Generated
    public void setInsideEnthalpyString(BStatusString v) {
        this.set(insideEnthalpyString, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getFreeCooling() {
        return (BStatusBoolean)this.get(freeCooling);
    }

    @Generated
    public void setFreeCooling(BStatusBoolean v) {
        this.set(freeCooling, (BValue)v, null);
    }

    @Generated
    public BStatusEnum getCurrentMode() {
        return (BStatusEnum)this.get(currentMode);
    }

    @Generated
    public void setCurrentMode(BStatusEnum v) {
        this.set(currentMode, (BValue)v, null);
    }

    @Generated
    public float getThresholdSpan() {
        return this.getFloat(thresholdSpan);
    }

    @Generated
    public void setThresholdSpan(float v) {
        this.setFloat(thresholdSpan, v, null);
    }

    @Generated
    public boolean getUseEnthalpy() {
        return this.getBoolean(useEnthalpy);
    }

    @Generated
    public void setUseEnthalpy(boolean v) {
        this.setBoolean(useEnthalpy, v, null);
    }

    @Generated
    public boolean getFreeCoolingCommand() {
        return this.getBoolean(freeCoolingCommand);
    }

    @Generated
    public void setFreeCoolingCommand(boolean v) {
        this.setBoolean(freeCoolingCommand, v, null);
    }

    @Generated
    public boolean getUseNullOutput() {
        return this.getBoolean(useNullOutput);
    }

    @Generated
    public void setUseNullOutput(boolean v) {
        this.setBoolean(useNullOutput, v, null);
    }

    @Generated
    public void calculate() {
        this.invoke(calculate, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals(outsideTemp) || property.equals(outsideHumidity) || property.equals(insideTemp) || property.equals(insideHumidity) || property.equals(thresholdSpan) || property.equals(freeCoolingCommand) || property.equals(useEnthalpy)) {
            this.doCalculate();
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)insideTemp) || slot.equals((Object)outsideTemp) || slot.equals((Object)lowTemperatureLimit)) {
            return this.getTemperatureFacets();
        }
        if (slot.equals((Object)insideHumidity) || slot.equals((Object)outsideHumidity)) {
            return this.getHumidityFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void atSteadyState() {
        this.doCalculate();
    }

    public void doCalculate() {
        if (!(this.getOutsideTemp().getStatus().isValid() && this.getOutsideHumidity().getStatus().isValid() && this.getInsideTemp().getStatus().isValid() && this.getInsideHumidity().getStatus().isValid())) {
            this.getCurrentMode().setValue((BEnum)BOutsideAirOptimizationMode.inputError);
            return;
        }
        if (this.getOutsideTemp().getValue() < this.getLowTemperatureLimit().getValue()) {
            this.setOutput(false);
            this.getCurrentMode().setValue((BEnum)BOutsideAirOptimizationMode.lowTemperature);
            this.lowTemp = true;
            return;
        }
        if (this.getUseEnthalpy()) {
            this.getOutsideEnthalpy().setValue((double)Psychrometric.enthalpy((float)this.getOutsideTemp().getValue(), (float)this.getOutsideHumidity().getValue()));
            this.getInsideEnthalpy().setValue((double)Psychrometric.enthalpy((float)this.getInsideTemp().getValue(), (float)this.getInsideHumidity().getValue()));
            if (this.getOutsideEnthalpy().getValue() > 0.0) {
                this.getOutsideEnthalpyString().setValue((int)this.getOutsideEnthalpy().getValue() + engUnits);
            } else {
                this.getOutsideEnthalpyString().setValue(OUT_OF_RANGE);
            }
            if (this.getInsideEnthalpy().getValue() > 0.0) {
                this.getInsideEnthalpyString().setValue((int)this.getInsideEnthalpy().getValue() + engUnits);
            } else {
                this.getInsideEnthalpyString().setValue(OUT_OF_RANGE);
            }
            if (this.getOutsideEnthalpy().getValue() >= this.getInsideEnthalpy().getValue()) {
                this.setOutput(false);
                this.getCurrentMode().setValue((BEnum)BOutsideAirOptimizationMode.noFreeCooling);
            } else if (this.getOutsideEnthalpy().getValue() <= this.getInsideEnthalpy().getValue() - Math.abs((double)this.getThresholdSpan())) {
                this.setOutput(true);
                this.getCurrentMode().setValue((BEnum)BOutsideAirOptimizationMode.freeCooling);
            }
        } else {
            this.getOutsideEnthalpy().setValue(0.0);
            this.getInsideEnthalpy().setValue(0.0);
            this.getOutsideEnthalpyString().setValue(UNUSED);
            this.getInsideEnthalpyString().setValue(UNUSED);
            if (this.getOutsideTemp().getValue() >= this.getInsideTemp().getValue()) {
                this.setOutput(false);
                this.getCurrentMode().setValue((BEnum)BOutsideAirOptimizationMode.noFreeCooling);
            } else if (this.getOutsideTemp().getValue() <= this.getInsideTemp().getValue() - Math.abs((double)this.getThresholdSpan())) {
                this.setOutput(true);
                this.getCurrentMode().setValue((BEnum)BOutsideAirOptimizationMode.freeCooling);
            }
        }
    }

    private void setOutput(boolean value) {
        if (value) {
            this.setFreeCooling(new BStatusBoolean(this.getFreeCoolingCommand(), BStatus.ok));
        } else if (this.getUseNullOutput()) {
            this.setFreeCooling(new BStatusBoolean(!this.getFreeCoolingCommand(), BStatus.nullStatus));
        } else {
            this.setFreeCooling(new BStatusBoolean(!this.getFreeCoolingCommand(), BStatus.ok));
        }
    }

    private BStatus getNoFreeCoolingStatus() {
        if (this.getUseNullOutput()) {
            return BStatus.nullStatus;
        }
        return BStatus.ok;
    }
}

