/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.energy;

import java.text.DecimalFormat;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="heatCoolMode", type="BStatusBoolean", defaultValue="new BStatusBoolean(false)", flags=10, facets={@Facet(value="BFacets.makeBoolean(\"coolMode\", \"heatMode\")")}), @NiagaraProperty(name="parameterResetTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=10), @NiagaraProperty(name="startEnable", type="BStatusBoolean", defaultValue="new BStatusBoolean(false)", flags=8), @NiagaraProperty(name="stopEnable", type="BStatusBoolean", defaultValue="new BStatusBoolean(false)", flags=8), @NiagaraProperty(name="scheduleStatus", type="BStatusBoolean", defaultValue="new BStatusBoolean(false)", flags=10), @NiagaraProperty(name="nextEventTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=10), @NiagaraProperty(name="nextEventValue", type="BStatusBoolean", defaultValue="new BStatusBoolean(false)", flags=10), @NiagaraProperty(name="outsideTemp", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=10), @NiagaraProperty(name="spaceTemp", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=10), @NiagaraProperty(name="startTimeCommand", type="BStatusBoolean", defaultValue="new BStatusBoolean(false, BStatus.nullStatus)", flags=74), @NiagaraProperty(name="stopTimeCommand", type="BStatusBoolean", defaultValue="new BStatusBoolean(false, BStatus.nullStatus)", flags=74), @NiagaraProperty(name="message", type="BStatusString", defaultValue="new BStatusString(\"\")", flags=10), @NiagaraProperty(name="upperComfortLimit", type="float", defaultValue="77.0f"), @NiagaraProperty(name="lowerComfortLimit", type="float", defaultValue="68.0f"), @NiagaraProperty(name="dynamicParameterAdjust", type="boolean", defaultValue="true"), @NiagaraProperty(name="oldParameterMultiplier", type="int", defaultValue="2"), @NiagaraProperty(name="earliestStartTime", type="BTime", defaultValue="BTime.make(0, 0, 10)"), @NiagaraProperty(name="earliestStopTime", type="BTime", defaultValue="BTime.make(16, 0, 0)"), @NiagaraProperty(name="drifttimePerDegreeCoolingUserDefined", type="float", defaultValue="0.0f"), @NiagaraProperty(name="drifttimePerDegreeHeatingUserDefined", type="float", defaultValue="0.0f"), @NiagaraProperty(name="runtimePerDegreeCoolingUserDefined", type="float", defaultValue="0.0f"), @NiagaraProperty(name="runtimePerDegreeHeatingUserDefined", type="float", defaultValue="0.0f"), @NiagaraProperty(name="drifttimePerDegreeCooling", type="float", defaultValue="10.0f"), @NiagaraProperty(name="drifttimePerDegreeHeating", type="float", defaultValue="10.0f"), @NiagaraProperty(name="runtimePerDegreeCooling", type="float", defaultValue="10.0f"), @NiagaraProperty(name="runtimePerDegreeHeating", type="float", defaultValue="10.0f"), @NiagaraProperty(name="lastStartTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=2), @NiagaraProperty(name="lastStopTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=2), @NiagaraProperty(name="outsideTempAtBeginning", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=2), @NiagaraProperty(name="spaceTempAtBeginning", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=2), @NiagaraProperty(name="calculatedCommandTime", type="BTime", defaultValue="BTime.DEFAULT", flags=66), @NiagaraProperty(name="programMode", type="int", defaultValue="0", flags=66)})
@NiagaraActions(value={@NiagaraAction(name="startTimeTrigger", flags=4), @NiagaraAction(name="stopTimeTrigger", flags=4), @NiagaraAction(name="calculate", flags=4)})
public class BOptimizedStartStop
extends BComponent {
    @Generated
    public static final Property heatCoolMode = BOptimizedStartStop.newProperty((int)10, (BValue)new BStatusBoolean(false), (BFacets)BFacets.makeBoolean((String)"coolMode", (String)"heatMode"));
    @Generated
    public static final Property parameterResetTime = BOptimizedStartStop.newProperty((int)10, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property startEnable = BOptimizedStartStop.newProperty((int)8, (BValue)new BStatusBoolean(false), null);
    @Generated
    public static final Property stopEnable = BOptimizedStartStop.newProperty((int)8, (BValue)new BStatusBoolean(false), null);
    @Generated
    public static final Property scheduleStatus = BOptimizedStartStop.newProperty((int)10, (BValue)new BStatusBoolean(false), null);
    @Generated
    public static final Property nextEventTime = BOptimizedStartStop.newProperty((int)10, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property nextEventValue = BOptimizedStartStop.newProperty((int)10, (BValue)new BStatusBoolean(false), null);
    @Generated
    public static final Property outsideTemp = BOptimizedStartStop.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property spaceTemp = BOptimizedStartStop.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property startTimeCommand = BOptimizedStartStop.newProperty((int)74, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    @Generated
    public static final Property stopTimeCommand = BOptimizedStartStop.newProperty((int)74, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    @Generated
    public static final Property message = BOptimizedStartStop.newProperty((int)10, (BValue)new BStatusString(""), null);
    @Generated
    public static final Property upperComfortLimit = BOptimizedStartStop.newProperty((int)0, (float)77.0f, null);
    @Generated
    public static final Property lowerComfortLimit = BOptimizedStartStop.newProperty((int)0, (float)68.0f, null);
    @Generated
    public static final Property dynamicParameterAdjust = BOptimizedStartStop.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property oldParameterMultiplier = BOptimizedStartStop.newProperty((int)0, (int)2, null);
    @Generated
    public static final Property earliestStartTime = BOptimizedStartStop.newProperty((int)0, (BValue)BTime.make((int)0, (int)0, (int)10), null);
    @Generated
    public static final Property earliestStopTime = BOptimizedStartStop.newProperty((int)0, (BValue)BTime.make((int)16, (int)0, (int)0), null);
    @Generated
    public static final Property drifttimePerDegreeCoolingUserDefined = BOptimizedStartStop.newProperty((int)0, (float)0.0f, null);
    @Generated
    public static final Property drifttimePerDegreeHeatingUserDefined = BOptimizedStartStop.newProperty((int)0, (float)0.0f, null);
    @Generated
    public static final Property runtimePerDegreeCoolingUserDefined = BOptimizedStartStop.newProperty((int)0, (float)0.0f, null);
    @Generated
    public static final Property runtimePerDegreeHeatingUserDefined = BOptimizedStartStop.newProperty((int)0, (float)0.0f, null);
    @Generated
    public static final Property drifttimePerDegreeCooling = BOptimizedStartStop.newProperty((int)0, (float)10.0f, null);
    @Generated
    public static final Property drifttimePerDegreeHeating = BOptimizedStartStop.newProperty((int)0, (float)10.0f, null);
    @Generated
    public static final Property runtimePerDegreeCooling = BOptimizedStartStop.newProperty((int)0, (float)10.0f, null);
    @Generated
    public static final Property runtimePerDegreeHeating = BOptimizedStartStop.newProperty((int)0, (float)10.0f, null);
    @Generated
    public static final Property lastStartTime = BOptimizedStartStop.newProperty((int)2, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastStopTime = BOptimizedStartStop.newProperty((int)2, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property outsideTempAtBeginning = BOptimizedStartStop.newProperty((int)2, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property spaceTempAtBeginning = BOptimizedStartStop.newProperty((int)2, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property calculatedCommandTime = BOptimizedStartStop.newProperty((int)66, (BValue)BTime.DEFAULT, null);
    @Generated
    public static final Property programMode = BOptimizedStartStop.newProperty((int)66, (int)0, null);
    @Generated
    public static final Action startTimeTrigger = BOptimizedStartStop.newAction((int)4, null);
    @Generated
    public static final Action stopTimeTrigger = BOptimizedStartStop.newAction((int)4, null);
    @Generated
    public static final Action calculate = BOptimizedStartStop.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOptimizedStartStop.class);
    boolean controlModeAtBeginning;
    boolean startDone;
    boolean analysisComplete = false;
    float observedMinutesPerDegree = 0.0f;
    float spaceTempChange = 0.0f;
    int leadTime = 0;
    int optimizedRuntimeMinutes = 0;
    int lastProgramMode = 0;
    BAbsTime now = BAbsTime.NULL;
    BAbsTime lastResetTime = BAbsTime.NULL;
    int lastMinute = 0;
    private static boolean ACTIVE = true;
    private static boolean INACTIVE = false;
    private static boolean START = true;
    private static boolean STOP = false;
    private static boolean DISABLED = false;
    private static boolean ENABLED = true;
    private static boolean COOLING = true;
    private static boolean HEATING = false;
    private static long TIME_00_01 = 60000L;
    private static int NO_CALCULATION = 0;
    private static int START_CALCULATION = 1;
    private static int START_IN_PROCESS = 2;
    private static int STOP_CALCULATION = 3;
    private static int STOP_IN_PROCESS = 4;
    Clock.Ticket ticket = null;
    public static final Log ossLog = Log.getLog((String)"kitControl.oss");

    @Generated
    public BStatusBoolean getHeatCoolMode() {
        return (BStatusBoolean)this.get(heatCoolMode);
    }

    @Generated
    public void setHeatCoolMode(BStatusBoolean v) {
        this.set(heatCoolMode, (BValue)v, null);
    }

    @Generated
    public BAbsTime getParameterResetTime() {
        return (BAbsTime)this.get(parameterResetTime);
    }

    @Generated
    public void setParameterResetTime(BAbsTime v) {
        this.set(parameterResetTime, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getStartEnable() {
        return (BStatusBoolean)this.get(startEnable);
    }

    @Generated
    public void setStartEnable(BStatusBoolean v) {
        this.set(startEnable, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getStopEnable() {
        return (BStatusBoolean)this.get(stopEnable);
    }

    @Generated
    public void setStopEnable(BStatusBoolean v) {
        this.set(stopEnable, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getScheduleStatus() {
        return (BStatusBoolean)this.get(scheduleStatus);
    }

    @Generated
    public void setScheduleStatus(BStatusBoolean v) {
        this.set(scheduleStatus, (BValue)v, null);
    }

    @Generated
    public BAbsTime getNextEventTime() {
        return (BAbsTime)this.get(nextEventTime);
    }

    @Generated
    public void setNextEventTime(BAbsTime v) {
        this.set(nextEventTime, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getNextEventValue() {
        return (BStatusBoolean)this.get(nextEventValue);
    }

    @Generated
    public void setNextEventValue(BStatusBoolean v) {
        this.set(nextEventValue, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getOutsideTemp() {
        return (BStatusNumeric)this.get(outsideTemp);
    }

    @Generated
    public void setOutsideTemp(BStatusNumeric v) {
        this.set(outsideTemp, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getSpaceTemp() {
        return (BStatusNumeric)this.get(spaceTemp);
    }

    @Generated
    public void setSpaceTemp(BStatusNumeric v) {
        this.set(spaceTemp, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getStartTimeCommand() {
        return (BStatusBoolean)this.get(startTimeCommand);
    }

    @Generated
    public void setStartTimeCommand(BStatusBoolean v) {
        this.set(startTimeCommand, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getStopTimeCommand() {
        return (BStatusBoolean)this.get(stopTimeCommand);
    }

    @Generated
    public void setStopTimeCommand(BStatusBoolean v) {
        this.set(stopTimeCommand, (BValue)v, null);
    }

    @Generated
    public BStatusString getMessage() {
        return (BStatusString)this.get(message);
    }

    @Generated
    public void setMessage(BStatusString v) {
        this.set(message, (BValue)v, null);
    }

    @Generated
    public float getUpperComfortLimit() {
        return this.getFloat(upperComfortLimit);
    }

    @Generated
    public void setUpperComfortLimit(float v) {
        this.setFloat(upperComfortLimit, v, null);
    }

    @Generated
    public float getLowerComfortLimit() {
        return this.getFloat(lowerComfortLimit);
    }

    @Generated
    public void setLowerComfortLimit(float v) {
        this.setFloat(lowerComfortLimit, v, null);
    }

    @Generated
    public boolean getDynamicParameterAdjust() {
        return this.getBoolean(dynamicParameterAdjust);
    }

    @Generated
    public void setDynamicParameterAdjust(boolean v) {
        this.setBoolean(dynamicParameterAdjust, v, null);
    }

    @Generated
    public int getOldParameterMultiplier() {
        return this.getInt(oldParameterMultiplier);
    }

    @Generated
    public void setOldParameterMultiplier(int v) {
        this.setInt(oldParameterMultiplier, v, null);
    }

    @Generated
    public BTime getEarliestStartTime() {
        return (BTime)this.get(earliestStartTime);
    }

    @Generated
    public void setEarliestStartTime(BTime v) {
        this.set(earliestStartTime, (BValue)v, null);
    }

    @Generated
    public BTime getEarliestStopTime() {
        return (BTime)this.get(earliestStopTime);
    }

    @Generated
    public void setEarliestStopTime(BTime v) {
        this.set(earliestStopTime, (BValue)v, null);
    }

    @Generated
    public float getDrifttimePerDegreeCoolingUserDefined() {
        return this.getFloat(drifttimePerDegreeCoolingUserDefined);
    }

    @Generated
    public void setDrifttimePerDegreeCoolingUserDefined(float v) {
        this.setFloat(drifttimePerDegreeCoolingUserDefined, v, null);
    }

    @Generated
    public float getDrifttimePerDegreeHeatingUserDefined() {
        return this.getFloat(drifttimePerDegreeHeatingUserDefined);
    }

    @Generated
    public void setDrifttimePerDegreeHeatingUserDefined(float v) {
        this.setFloat(drifttimePerDegreeHeatingUserDefined, v, null);
    }

    @Generated
    public float getRuntimePerDegreeCoolingUserDefined() {
        return this.getFloat(runtimePerDegreeCoolingUserDefined);
    }

    @Generated
    public void setRuntimePerDegreeCoolingUserDefined(float v) {
        this.setFloat(runtimePerDegreeCoolingUserDefined, v, null);
    }

    @Generated
    public float getRuntimePerDegreeHeatingUserDefined() {
        return this.getFloat(runtimePerDegreeHeatingUserDefined);
    }

    @Generated
    public void setRuntimePerDegreeHeatingUserDefined(float v) {
        this.setFloat(runtimePerDegreeHeatingUserDefined, v, null);
    }

    @Generated
    public float getDrifttimePerDegreeCooling() {
        return this.getFloat(drifttimePerDegreeCooling);
    }

    @Generated
    public void setDrifttimePerDegreeCooling(float v) {
        this.setFloat(drifttimePerDegreeCooling, v, null);
    }

    @Generated
    public float getDrifttimePerDegreeHeating() {
        return this.getFloat(drifttimePerDegreeHeating);
    }

    @Generated
    public void setDrifttimePerDegreeHeating(float v) {
        this.setFloat(drifttimePerDegreeHeating, v, null);
    }

    @Generated
    public float getRuntimePerDegreeCooling() {
        return this.getFloat(runtimePerDegreeCooling);
    }

    @Generated
    public void setRuntimePerDegreeCooling(float v) {
        this.setFloat(runtimePerDegreeCooling, v, null);
    }

    @Generated
    public float getRuntimePerDegreeHeating() {
        return this.getFloat(runtimePerDegreeHeating);
    }

    @Generated
    public void setRuntimePerDegreeHeating(float v) {
        this.setFloat(runtimePerDegreeHeating, v, null);
    }

    @Generated
    public BAbsTime getLastStartTime() {
        return (BAbsTime)this.get(lastStartTime);
    }

    @Generated
    public void setLastStartTime(BAbsTime v) {
        this.set(lastStartTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastStopTime() {
        return (BAbsTime)this.get(lastStopTime);
    }

    @Generated
    public void setLastStopTime(BAbsTime v) {
        this.set(lastStopTime, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getOutsideTempAtBeginning() {
        return (BStatusNumeric)this.get(outsideTempAtBeginning);
    }

    @Generated
    public void setOutsideTempAtBeginning(BStatusNumeric v) {
        this.set(outsideTempAtBeginning, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getSpaceTempAtBeginning() {
        return (BStatusNumeric)this.get(spaceTempAtBeginning);
    }

    @Generated
    public void setSpaceTempAtBeginning(BStatusNumeric v) {
        this.set(spaceTempAtBeginning, (BValue)v, null);
    }

    @Generated
    public BTime getCalculatedCommandTime() {
        return (BTime)this.get(calculatedCommandTime);
    }

    @Generated
    public void setCalculatedCommandTime(BTime v) {
        this.set(calculatedCommandTime, (BValue)v, null);
    }

    @Generated
    public int getProgramMode() {
        return this.getInt(programMode);
    }

    @Generated
    public void setProgramMode(int v) {
        this.setInt(programMode, v, null);
    }

    @Generated
    public void startTimeTrigger() {
        this.invoke(startTimeTrigger, null, null);
    }

    @Generated
    public void stopTimeTrigger() {
        this.invoke(stopTimeTrigger, null, null);
    }

    @Generated
    public void calculate() {
        this.invoke(calculate, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.initClockTicket();
        super.started();
        if (!Sys.atSteadyState()) {
            return;
        }
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    public void clockChanged(BRelTime value) {
        this.initClockTicket();
    }

    private void initClockTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        BAbsTime tom = Clock.nextTopOfMinute().add(BRelTime.makeSeconds((int)15));
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)tom, (BRelTime)BRelTime.makeMinutes((int)1), (Action)calculate, null);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        boolean parameterReset = false;
        if (property.equals(drifttimePerDegreeCoolingUserDefined)) {
            this.setDrifttimePerDegreeCooling(this.getDrifttimePerDegreeCoolingUserDefined());
            parameterReset = true;
        } else if (property.equals(drifttimePerDegreeHeatingUserDefined)) {
            this.setDrifttimePerDegreeHeating(this.getDrifttimePerDegreeHeatingUserDefined());
            parameterReset = true;
        } else if (property.equals(runtimePerDegreeCoolingUserDefined)) {
            this.setRuntimePerDegreeCooling(this.getRuntimePerDegreeCoolingUserDefined());
            parameterReset = true;
        } else if (property.equals(runtimePerDegreeHeatingUserDefined)) {
            this.setRuntimePerDegreeHeating(this.getRuntimePerDegreeHeatingUserDefined());
            parameterReset = true;
        }
        if (parameterReset) {
            this.setParameterResetTime(Clock.time());
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        return super.getSlotFacets(slot);
    }

    public void doStopTimeTrigger() {
    }

    public void doStartTimeTrigger() {
    }

    private String formatNumeric(double value, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern);
        return format.format(value);
    }

    public void doCalculate() {
        this.now = Clock.time();
        if (this.getStartEnable().getValue() == DISABLED || this.now.getTimeOfDayMillis() < TIME_00_01) {
            this.startDone = false;
        }
        this.performStartStopAnalysis();
        this.performStartStopCalculation();
        this.performStartStopControl();
        this.updateControlOutput();
        this.lastProgramMode = this.getProgramMode();
    }

    private void performStartStopCalculation() {
        if (this.getNextEventTime().getDayOfYear() != this.now.getDayOfYear()) {
            this.setProgramMode(NO_CALCULATION);
            return;
        }
        if (this.getNextEventValue().getValue() == ACTIVE) {
            this.performStartCalculation();
        } else {
            this.performStopCalculation();
        }
    }

    private void performStartCalculation() {
        if (this.getStartEnable().getValue() != ENABLED || this.getScheduleStatus().getValue() == ACTIVE) {
            this.setProgramMode(NO_CALCULATION);
            return;
        }
        if (!this.startDone && this.getSpaceTemp().getStatus().isValid()) {
            if (this.getProgramMode() != START_IN_PROCESS) {
                this.setProgramMode(START_CALCULATION);
                this.leadTime = this.getSpaceTemp().getValue() > (double)this.getUpperComfortLimit() ? 1 + (int)((this.getSpaceTemp().getValue() - (double)this.getUpperComfortLimit()) * (double)this.getRuntimePerDegreeCooling()) : (this.getSpaceTemp().getValue() < (double)this.getLowerComfortLimit() ? 1 + (int)(((double)this.getLowerComfortLimit() - this.getSpaceTemp().getValue()) * (double)this.getRuntimePerDegreeHeating()) : 0);
            }
        } else {
            this.leadTime = 0;
        }
        ossLog.trace(this.getParent().getName() + "." + this.getName() + "::oss start lead time = " + this.leadTime);
    }

    private void performStopCalculation() {
        if (this.getStopEnable().getValue() != ENABLED || this.getScheduleStatus().getValue() == INACTIVE) {
            this.setProgramMode(NO_CALCULATION);
            return;
        }
        if (!this.getSpaceTemp().getStatus().isValid() || this.getProgramMode() == STOP_IN_PROCESS) {
            this.leadTime = 0;
            return;
        }
        this.setProgramMode(STOP_CALCULATION);
        if (this.getSpaceTemp().getValue() > (double)this.getLowerComfortLimit()) {
            this.controlModeAtBeginning = this.getHeatCoolMode().getValue();
            this.leadTime = this.getHeatCoolMode().getValue() == HEATING ? (int)((this.getSpaceTemp().getValue() - (double)this.getLowerComfortLimit()) * (double)this.getDrifttimePerDegreeHeating()) : (int)(((double)this.getUpperComfortLimit() - this.getSpaceTemp().getValue()) * (double)this.getDrifttimePerDegreeCooling());
        }
        ossLog.trace(this.getName() + "::oss stop lead time = " + this.leadTime);
    }

    private void performStartStopControl() {
        BTime currentTime;
        if (this.getProgramMode() != START_CALCULATION && this.getProgramMode() != STOP_CALCULATION) {
            this.setCalculatedCommandTime(BTime.make((BAbsTime)this.getNextEventTime()));
            return;
        }
        long calcCmdTime = this.getNextEventTime().getTimeOfDayMillis() - (long)this.leadTime * TIME_00_01;
        if (calcCmdTime < this.getEarliestStartTime().getTimeOfDayMillis()) {
            calcCmdTime = this.getEarliestStartTime().getTimeOfDayMillis();
        }
        this.setCalculatedCommandTime(BTime.make((BRelTime)BRelTime.make((long)calcCmdTime)));
        if (this.getProgramMode() == STOP_CALCULATION && this.getCalculatedCommandTime().isBefore(this.getEarliestStopTime())) {
            this.setCalculatedCommandTime(this.getEarliestStopTime());
        }
        if ((currentTime = BTime.make((BAbsTime)Clock.time())).isAfter(this.getCalculatedCommandTime()) || currentTime.isAfter(BTime.make((BAbsTime)this.getNextEventTime()))) {
            if (this.getProgramMode() == START_CALCULATION) {
                this.startDone = true;
                this.setProgramMode(START_IN_PROCESS);
                this.setLastStartTime(Clock.time());
                this.getSpaceTempAtBeginning().setValue(this.getSpaceTemp().getValue());
                this.getOutsideTempAtBeginning().setValue(this.getOutsideTemp().getValue());
                this.startTimeTrigger();
                this.getMessage().setValue("Optimized start for " + this.getNextEventTime() + " schedule time.  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + ".");
            } else {
                this.setProgramMode(STOP_IN_PROCESS);
                this.setLastStopTime(Clock.time());
                this.getSpaceTempAtBeginning().setValue(this.getSpaceTemp().getValue());
                this.getOutsideTempAtBeginning().setValue(this.getOutsideTemp().getValue());
                this.controlModeAtBeginning = this.getHeatCoolMode().getValue();
                this.stopTimeTrigger();
                this.getMessage().setValue("Optimized stop for " + this.getNextEventTime() + " schedule time.  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + ".");
            }
        }
    }

    private void updateControlOutput() {
        if (this.getProgramMode() == START_IN_PROCESS) {
            this.getStartTimeCommand().setValue(START);
            this.getStartTimeCommand().setStatusNull(false);
            this.getStopTimeCommand().setValue(STOP);
            this.getStopTimeCommand().setStatusNull(true);
        } else if (this.getProgramMode() == STOP_IN_PROCESS) {
            this.getStopTimeCommand().setValue(STOP);
            this.getStopTimeCommand().setStatusNull(false);
            this.getStartTimeCommand().setValue(STOP);
            this.getStartTimeCommand().setStatusNull(true);
        } else {
            this.getStopTimeCommand().setValue(STOP);
            this.getStopTimeCommand().setStatusNull(true);
            this.getStartTimeCommand().setValue(STOP);
            this.getStartTimeCommand().setStatusNull(true);
            this.analysisComplete = false;
        }
    }

    private void performStartStopAnalysis() {
        if (!this.getDynamicParameterAdjust() || this.analysisComplete || !this.getSpaceTemp().getStatus().isValid()) {
            return;
        }
        if (this.lastProgramMode == START_IN_PROCESS) {
            this.handleStartAnalysis();
        } else if (this.lastProgramMode == STOP_IN_PROCESS) {
            this.handleStopAnalysis();
        }
    }

    private void handleStartAnalysis() {
        if (this.isCoolingAnalysis()) {
            if (this.getSpaceTemp().getValue() < this.getSpaceTempAtBeginning().getValue() && (this.getSpaceTemp().getValue() <= (double)this.getUpperComfortLimit() || this.getScheduleStatus().getValue() == ACTIVE)) {
                this.spaceTempChange = (float)(this.getSpaceTempAtBeginning().getValue() - this.getSpaceTemp().getValue());
                this.optimizedRuntimeMinutes = this.getLastStartTime().delta(this.now).getMinutes();
                this.observedMinutesPerDegree = (float)this.optimizedRuntimeMinutes / this.spaceTempChange;
                this.setRuntimePerDegreeCooling((this.getRuntimePerDegreeCooling() * (float)this.getOldParameterMultiplier() + this.observedMinutesPerDegree) / (float)(this.getOldParameterMultiplier() + 1));
                this.analysisComplete = true;
                this.getMessage().setValue("Optimized start analysis done at " + this.now + ".  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + ".");
            }
        } else if (this.getSpaceTemp().getValue() > this.getSpaceTempAtBeginning().getValue() && (this.getSpaceTemp().getValue() >= (double)this.getLowerComfortLimit() || this.getScheduleStatus().getValue() == ACTIVE)) {
            this.spaceTempChange = (float)(this.getSpaceTemp().getValue() - this.getSpaceTempAtBeginning().getValue());
            this.optimizedRuntimeMinutes = this.getLastStartTime().delta(this.now).getMinutes();
            this.observedMinutesPerDegree = (float)this.optimizedRuntimeMinutes / this.spaceTempChange;
            this.setRuntimePerDegreeHeating((this.getRuntimePerDegreeHeating() * (float)this.getOldParameterMultiplier() + this.observedMinutesPerDegree) / (float)(this.getOldParameterMultiplier() + 1));
            this.analysisComplete = true;
            this.getMessage().setValue("Optimized start analysis done at " + this.now + ".  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + ".");
        }
    }

    private boolean isCoolingAnalysis() {
        return this.getSpaceTempAtBeginning().getValue() > (double)this.getUpperComfortLimit();
    }

    private void handleStopAnalysis() {
        if (this.controlModeAtBeginning == HEATING) {
            if (this.getSpaceTemp().getValue() < this.getSpaceTempAtBeginning().getValue() && (this.getSpaceTemp().getValue() <= (double)this.getLowerComfortLimit() || this.getScheduleStatus().getValue() == INACTIVE)) {
                this.spaceTempChange = (float)this.getSpaceTempAtBeginning().getValue() - (float)this.getSpaceTemp().getValue();
                this.optimizedRuntimeMinutes = this.getLastStopTime().delta(this.now).getMinutes();
                this.observedMinutesPerDegree = (float)this.optimizedRuntimeMinutes / this.spaceTempChange;
                this.setDrifttimePerDegreeHeating((this.getDrifttimePerDegreeHeating() * (float)this.getOldParameterMultiplier() + this.observedMinutesPerDegree) / (float)(this.getOldParameterMultiplier() + 1));
                this.getMessage().setValue("Optimized stop analysis done at " + this.now + ".  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + ".");
                this.analysisComplete = true;
            }
        } else if (this.getSpaceTemp().getValue() > this.getSpaceTempAtBeginning().getValue() && (this.getSpaceTemp().getValue() >= (double)this.getUpperComfortLimit() || this.getScheduleStatus().getValue() == INACTIVE)) {
            this.spaceTempChange = (float)this.getSpaceTemp().getValue() - (float)this.getSpaceTempAtBeginning().getValue();
            this.optimizedRuntimeMinutes = this.getLastStopTime().delta(this.now).getMinutes();
            this.observedMinutesPerDegree = (float)this.optimizedRuntimeMinutes / this.spaceTempChange;
            this.setDrifttimePerDegreeCooling((this.getDrifttimePerDegreeCooling() * (float)this.getOldParameterMultiplier() + this.observedMinutesPerDegree) / (float)(this.getOldParameterMultiplier() + 1));
            this.getMessage().setValue("Optimized stop analysis done at " + this.now + ".  Space temp is " + this.formatNumeric(this.getSpaceTemp().getValue(), "#0.0") + ".");
            this.analysisComplete = true;
        }
    }
}

