/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platDaemon.BDaemonSurrogate;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.util.CommandLineArguments;
import java.io.EOFException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraSingleton
public class BWatchStationCommand
extends BDaemonSessionCommand {
    @Generated
    public static final BWatchStationCommand INSTANCE = new BWatchStationCommand();
    @Generated
    public static final Type TYPE = Sys.loadType(BWatchStationCommand.class);
    private static final Logger log = Logger.getLogger("watchstation");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BWatchStationCommand() {
    }

    public String getCommandName() {
        return "watchstation";
    }

    public String getCommandDescription() {
        return "monitor the output of a Niagara station";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbenchAzul";
    }

    public void usage() {
        BWatchStationCommand.println((String)"", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"usage:", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"  plat watchstation <flags> [stationname]", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"parameters:", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"  stationname              name of the station to view, or \"daemon\"", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"                             if the daemon's output is to be watched.", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"                             If omitted, the first/only station will be used", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"required flags:", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"  -h:<hostord>             ORD for the remote host", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"  -usr:<userName>          user name for the host's platform daemon", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"  -pwd:<password>          password for the host's platform daemon", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"  -follow                  if specified, the command will execute until", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"                             it is killed (ctrl-c), and will continue", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"                             to display output as the station produces it", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"  -f                       same as -follow", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"  -noinput                 if given, command will fail when username\n                             and password are missing or incorrect,\n                             instead of prompting and reading them\n                             from stdin", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"  -p:<port>                port for the host's platform daemon\n                             if omitted, default port 3011 or 5011 is used", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"  -secure                  if given, the connection will be encrypted with TLS", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"  -locale:<x>              set the default locale (en_US)", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"  -@<option>               pass option to Java VM", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"  -buildreg                force rebuild of the registry", (Object[])new Object[0]);
        BWatchStationCommand.println((String)"", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invoke(CommandLineArguments args) throws Exception {
        BStationSurrogate station;
        InputStream in;
        if (args.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        boolean follow = args.hasOption("follow") || args.hasOption("f");
        byte[] buf = new byte[8192];
        if (args.parameters.length != 0) {
            if (args.parameters[0].equals("daemon")) {
                System.out.println();
                if (follow) {
                    System.out.println("Output will be followed, use control-c to exit");
                }
                System.out.println("------------------ Output of Niagara platform daemon on " + session.getHost() + " ------------------");
                in = new BDaemonSurrogate(session).getDaemonOutput(follow, false);
            } else {
                station = BStationSurrogate.make((BDaemonSession)session, (String)args.parameters[0]);
                if (station == null) {
                    log.warning("Station " + args.parameters[0] + " not found");
                    return 4;
                }
                System.out.println();
                if (follow) {
                    System.out.println("Output will be followed, use control-c to exit");
                }
                System.out.println("------------------ Output of station " + station.getStationName() + " on " + session.getHost() + " ------------------");
                in = station.getStationOutput(follow);
            }
        } else {
            BStationSurrogate[] stations = BStationSurrogate.makeAll((BDaemonSession)session);
            if (stations.length == 0) {
                log.warning("No stations on remote host");
                return 4;
            }
            station = stations[0];
            System.out.println();
            if (follow) {
                System.out.println("Output will be followed, use control-c to exit");
            }
            System.out.println("------------------ Output of station " + station.getStationName() + " on " + session.getHost() + " ------------------");
            in = station.getStationOutput(follow);
        }
        try {
            while (true) {
                int numRead;
                try {
                    numRead = in.read(buf, 0, 8192);
                }
                catch (InterruptedIOException ste) {
                    if (follow) continue;
                    break;
                }
                catch (EOFException eofe) {
                    break;
                }
                if (numRead > 0) {
                    System.out.write(buf, 0, numRead);
                    continue;
                }
                break;
            }
        }
        finally {
            new Thread(() -> {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
        }
        session.close();
        return 0;
    }
}

