/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.util.CommandLineArguments;
import java.util.logging.Logger;
import javax.baja.naming.BLocalHost;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraSingleton
public class BRebootHostCommand
extends BDaemonSessionCommand {
    @Generated
    public static final BRebootHostCommand INSTANCE = new BRebootHostCommand();
    @Generated
    public static final Type TYPE = Sys.loadType(BRebootHostCommand.class);
    private static final Logger log = Logger.getLogger("reboothost");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BRebootHostCommand() {
    }

    public String getCommandName() {
        return "reboothost";
    }

    public String getCommandDescription() {
        return "request that a remote Niagara Platform Daemon reboot its host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbenchAzul";
    }

    public void usage() {
        BRebootHostCommand.println((String)"", (Object[])new Object[0]);
        BRebootHostCommand.println((String)"usage:", (Object[])new Object[0]);
        BRebootHostCommand.println((String)"  plat reboothost <flags>", (Object[])new Object[0]);
        BRebootHostCommand.println((String)"required flags:", (Object[])new Object[0]);
        BRebootHostCommand.println((String)"  -h:<hostord>             ORD for the remote host", (Object[])new Object[0]);
        BRebootHostCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BRebootHostCommand.println((String)"  -usr:<userName>          user name for the host's platform daemon", (Object[])new Object[0]);
        BRebootHostCommand.println((String)"  -pwd:<password>          password for the host's platform daemon", (Object[])new Object[0]);
        BRebootHostCommand.println((String)"  -noinput                 if given, command will fail when username\n                             and password are missing or incorrect,\n                             instead of prompting and reading them\n                             from stdin", (Object[])new Object[0]);
        BRebootHostCommand.println((String)"  -p:<port>                port for the host's platform daemon\n                             if omitted, default port 3011 or 5011 is used", (Object[])new Object[0]);
        BRebootHostCommand.println((String)"  -secure                  if given, the connection will be encrypted with TLS", (Object[])new Object[0]);
        BRebootHostCommand.println((String)"  -locale:<x>              set the default locale (en_US)", (Object[])new Object[0]);
        BRebootHostCommand.println((String)"  -@<option>               pass option to Java VM", (Object[])new Object[0]);
        BRebootHostCommand.println((String)"  -buildreg                force rebuild of the registry", (Object[])new Object[0]);
        BRebootHostCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        if (args.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        if (session.getHost() == BLocalHost.INSTANCE) {
            log.severe("Cannot reboot the local host");
            return 1;
        }
        session.sendRebootRequest();
        log.info("Host " + session.getHost().getNavDisplayName(null) + " rebooting");
        return 0;
    }
}

