/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.util.CommandLineArguments;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraSingleton
public class BModuleInstallCommand
extends BDaemonSessionCommand {
    @Generated
    public static final BModuleInstallCommand INSTANCE = new BModuleInstallCommand();
    @Generated
    public static final Type TYPE = Sys.loadType(BModuleInstallCommand.class);
    private static final Logger log = Logger.getLogger("moduleinstall");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BModuleInstallCommand() {
    }

    public String getCommandName() {
        return "moduleinstall";
    }

    public String getCommandDescription() {
        return "install Niagara modules to a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbenchAzul";
    }

    public void usage() {
        BModuleInstallCommand.println((String)"", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"usage:", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  plat moduleinstall <flags> [modulename]*", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"parameters:", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  modulename               names of a module to install to the remote host", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"required flags:", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -h:<hostord>             ORD for the remote host", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -usr:<userName>          user name for the host's platform daemon", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -pwd:<password>          password for the host's platform daemon", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -ood                     all out-of-date modules are to be upgraded", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -noinput                 if given, command will fail when username\n                             and password are missing or incorrect,\n                             instead of prompting and reading them\n                             from stdin", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -p:<port>                port for the host's platform daemon\n                             if omitted, default port 3011 or 5011 is used", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -secure                  if given, the connection will be encrypted with TLS", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -locale:<x>              set the default locale (en_US)", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -@<option>               pass option to Java VM", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -buildreg                force rebuild of the registry", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        UnmeetableDependency[] unmet;
        if (args.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        boolean oodArg = args.hasOption("ood");
        if (!oodArg && args.parameters.length == 0) {
            this.usage();
            return 2;
        }
        int retCode = 0;
        BRemoteDaemonPlatform targetPlatform = BRemoteDaemonPlatform.make((BDaemonSession)session, null);
        targetPlatform.checkSession();
        targetPlatform.loadPreferredVerificationMode();
        BDependency[] moduleDeps = new BDependency[args.parameters.length];
        for (int i = 0; i < args.parameters.length; ++i) {
            moduleDeps[i] = BDependency.forModule((String)args.parameters[i]);
        }
        Listener listener = new Listener();
        InstallScenario scenario = InstallScenario.solve((BDaemonPlatform)targetPlatform, (DaemonSessionTaskListener)listener, null, (BDependency[])moduleDeps, null, null, (InstallableRegistry)LocalInstallableRegistry.getInstance(), (CertificateChainValidator)CertificateChainValidator.make((ICoreCryptoManager)BPlatCryptoManager.make((BDaemonPlatform)targetPlatform)));
        if (scenario.canCommit() && oodArg) {
            scenario = InstallScenario.upgradeOutOfDate((InstallScenario)scenario, (InstallableRegistry)LocalInstallableRegistry.getInstance());
        }
        if ((unmet = scenario.getUnmeetableDependencies()).length > 0) {
            log.severe("The following dependencies cannot be met");
            for (UnmeetableDependency unmeetableDependency : unmet) {
                System.out.println("  " + unmeetableDependency);
            }
            return 1;
        }
        if (scenario.getToInstall().length == 0) {
            log.info("All remote modules are already up to date.");
            return retCode;
        }
        if (!scenario.canCommit()) {
            log.severe("cannot commit installation");
            return 1;
        }
        log.info("Stopping stations on " + session.getHost().getNavDisplayName(null));
        BAppSurrogate[] stopped = BAppSurrogate.stopAllApps((BDaemonSession)session, null, null, null);
        scenario.commit((DaemonSessionTaskListener)listener, null);
        log.info("Installation complete.");
        for (BAppSurrogate appSurrogate : stopped) {
            if (!appSurrogate.isRestartEnabled()) continue;
            appSurrogate.startAppAsync();
            log.info("Started " + appSurrogate.toString(null));
        }
        return retCode;
    }

    private static class Listener
    implements DaemonSessionTaskListener {
        String lastText = null;

        private Listener() {
        }

        public void taskStarted(DaemonSessionTask task) {
            if (!task.getMessage().equals(this.lastText)) {
                System.out.println(task.getMessage());
                this.lastText = task.getMessage();
            }
        }

        public void taskUpdated(DaemonSessionTask task) {
            this.taskStarted(task);
        }

        public void taskFinished(DaemonSessionTask task) {
        }

        public boolean isCancelEnabled() {
            return false;
        }
    }
}

