/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDefaultDaemonFileSpace;
import com.tridium.util.CommandLineArguments;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public class BFileListCommand
extends BDaemonSessionCommand {
    @Generated
    public static final BFileListCommand INSTANCE = new BFileListCommand();
    @Generated
    public static final Type TYPE = Sys.loadType(BFileListCommand.class);
    private final DecimalFormat numFormat = new DecimalFormat(Lexicon.make((String)"platDaemon").getText("Formats.num"));
    private static final int NAME_WIDTH = 32;
    private static final int SIZE_WIDTH = 10;
    private static final int LAST_MODIFIED_WIDTH = 21;
    private static final int CRC_WIDTH = 13;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BFileListCommand() {
    }

    public String getCommandName() {
        return "flist";
    }

    public String getCommandDescription() {
        return "provide file details for a single file, or for all files in a directory";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbenchAzul";
    }

    public void usage() {
        BFileListCommand.println((String)"", (Object[])new Object[0]);
        BFileListCommand.println((String)"usage:", (Object[])new Object[0]);
        BFileListCommand.println((String)"  plat flist <flags> <path>", (Object[])new Object[0]);
        BFileListCommand.println((String)"parameters:", (Object[])new Object[0]);
        BFileListCommand.println((String)"  path                     path of an existing file or directory", (Object[])new Object[0]);
        BFileListCommand.println((String)"required flags:", (Object[])new Object[0]);
        BFileListCommand.println((String)"  -h:<hostord>             ORD for the remote host", (Object[])new Object[0]);
        BFileListCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BFileListCommand.println((String)"  -usr:<userName>          user name for the host's platform daemon", (Object[])new Object[0]);
        BFileListCommand.println((String)"  -pwd:<password>          password for the host's platform daemon", (Object[])new Object[0]);
        BFileListCommand.println((String)"  -recurse                 apply file operation recursively", (Object[])new Object[0]);
        BFileListCommand.println((String)"  -r                       same as -recurse", (Object[])new Object[0]);
        BFileListCommand.println((String)"  -noinput                 if given, command will fail when username\n                             and password are missing or incorrect,\n                             instead of prompting and reading them\n                             from stdin", (Object[])new Object[0]);
        BFileListCommand.println((String)"  -p:<port>                port for the host's platform daemon\n                             if omitted, default port 3011 or 5011 is used", (Object[])new Object[0]);
        BFileListCommand.println((String)"  -secure                  if given, the connection will be encrypted with TLS", (Object[])new Object[0]);
        BFileListCommand.println((String)"  -locale:<x>              set the default locale (en_US)", (Object[])new Object[0]);
        BFileListCommand.println((String)"  -@<option>               pass option to Java VM", (Object[])new Object[0]);
        BFileListCommand.println((String)"  -buildreg                force rebuild of the registry", (Object[])new Object[0]);
        BFileListCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        boolean recurse;
        if (args.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        boolean bl = recurse = args.hasOption("r") || args.hasOption("recurse");
        if (args.parameters.length < 1) {
            this.usage();
            return 2;
        }
        BDefaultDaemonFileSpace space = session.getFileSpace();
        this.printHeaders();
        for (int i = 0; i < args.parameters.length; ++i) {
            FilePath path = new FilePath(args.parameters[i]);
            BIFile file = space.findFile(path);
            if (file == null) {
                System.out.println(path.getBody() + " does not exist");
                continue;
            }
            if (file.isDirectory()) {
                this.listDirectory((BDirectory)file, recurse);
                continue;
            }
            this.listFile(file);
        }
        return 0;
    }

    private void listFile(BIFile file) {
        System.out.print(TextUtil.padRight((String)file.getFileName(), (int)32));
        System.out.print(" ");
        if (file.getSize() < 0L) {
            System.out.print(TextUtil.padLeft((String)"", (int)10));
        } else {
            System.out.print(TextUtil.padLeft((String)DaemonFileUtil.fileSize((long)file.getSize()), (int)10));
        }
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)file.getLastModified().toString(), (int)21));
        System.out.print(" ");
        System.out.print(TextUtil.padLeft((String)this.numFormat.format(DaemonFileUtil.getCrc((BIFile)file)), (int)13));
        System.out.println();
    }

    private void listDirectory(BDirectory directory, boolean recurse) {
        if (recurse) {
            System.out.println("Contents of directory " + directory.getFilePath().getBody());
            this.printDashes(directory.getFilePath().getBody().length() + 22);
            System.out.println();
        }
        ArrayList<BIFile> dirKids = new ArrayList<BIFile>();
        BIFile[] kids = directory.listFiles();
        for (BIFile kid : kids) {
            if (kid.isDirectory()) {
                dirKids.add(kid);
                continue;
            }
            this.listFile(kid);
        }
        for (BIFile dirKid : dirKids) {
            BDirectory dir = (BDirectory)dirKid;
            if (recurse) {
                this.listDirectory(dir, true);
                continue;
            }
            System.out.print(TextUtil.padRight((String)dir.getFileName(), (int)32));
            System.out.println(" (directory)");
        }
    }

    private void printHeaders() {
        System.out.print(TextUtil.padRight((String)"Name", (int)32));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"Size", (int)10));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"Last modified", (int)21));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"CRC", (int)13));
        System.out.println();
        this.printDashes(32);
        System.out.print(" ");
        this.printDashes(10);
        System.out.print(" ");
        this.printDashes(21);
        System.out.print(" ");
        this.printDashes(13);
        System.out.println();
    }

    private void printDashes(int width) {
        for (int i = 0; i < width; ++i) {
            System.out.print('-');
        }
    }
}

