/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon;

import com.tridium.nre.jetty.log.NullLogger;
import com.tridium.platform.daemon.BDaemonLogLevel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.ConsoleInputStream;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DumpThreadsMessage;
import com.tridium.platform.daemon.message.GetDaemonOutputMessage;
import com.tridium.platform.daemon.message.GetLogLevelsMessage;
import com.tridium.platform.daemon.message.GetOutputMessage;
import com.tridium.platform.daemon.message.SaveLogLevelMessage;
import com.tridium.platform.daemon.message.SetLogLevelMessage;
import java.io.InputStream;
import java.net.ConnectException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import org.eclipse.jetty.util.log.Log;

@NiagaraType
@NiagaraProperty(name="logLevels", type="BVector", defaultValue="new BVector()", flags=1)
public class BDaemonSurrogate
extends BComponent {
    @Generated
    public static final Property logLevels = BDaemonSurrogate.newProperty((int)1, (BValue)new BVector(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDaemonSurrogate.class);
    private static final BIcon icon;
    private int logServletVersion = 1;
    private String forceLevel = null;
    private final BDaemonSession session;
    public static Logger log;
    private static final int STREAM_TIMEOUT_MILLIS;

    @Generated
    public BVector getLogLevels() {
        return (BVector)this.get(logLevels);
    }

    @Generated
    public void setLogLevels(BVector v) {
        this.set(logLevels, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDaemonSurrogate() {
        this.session = null;
    }

    public BDaemonSurrogate(BDaemonSession session) {
        this.session = session;
    }

    public static BDaemonSurrogate make(BDaemonSession session) throws Exception {
        BDaemonSurrogate result = new BDaemonSurrogate(session);
        result.poll();
        return result;
    }

    public void poll() throws Exception {
        InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)GetLogLevelsMessage.getInstance());
        if (in != null) {
            this.updateFields(XParser.make((InputStream)in).parse());
        }
    }

    public void updateFields(XElem daemonElement) {
        ArrayList<String> oldNames = new ArrayList<String>();
        SlotCursor c = this.getLogLevels().getProperties();
        while (c.next()) {
            oldNames.add(c.property().getName());
        }
        XElem[] filterElems = daemonElement.elems("filter");
        this.forceLevel = daemonElement.get("forceLevel", null);
        this.logServletVersion = daemonElement.geti("version", 1);
        for (XElem filterElem : filterElems) {
            String slotName = SlotPath.escape((String)filterElem.get("name"));
            if (oldNames.remove(slotName)) {
                if (this.logServletVersion == 1) {
                    this.getLogLevels().set(slotName, (BValue)BDaemonLogLevel.make((int)filterElem.geti("value")));
                    continue;
                }
                if (this.logServletVersion >= 2) {
                    this.getLogLevels().set(slotName, (BValue)BString.make((String)filterElem.get("value")));
                    continue;
                }
                throw new IllegalArgumentException("Unknown logfilter servlet version: " + this.logServletVersion);
            }
            if (this.logServletVersion == 1) {
                this.getLogLevels().add(slotName, (BValue)BDaemonLogLevel.make((int)filterElem.geti("value")));
                continue;
            }
            if (this.logServletVersion >= 2) {
                this.getLogLevels().add(slotName, (BValue)BString.make((String)filterElem.get("value")));
                continue;
            }
            throw new IllegalArgumentException("Unknown logfilter servlet version: " + this.logServletVersion);
        }
        for (String oldName : oldNames) {
            this.getLogLevels().remove(oldName);
        }
    }

    public void dumpThreads() throws ConnectException, AuthenticationException {
        this.getDaemonSession().sendMessage((DaemonMessage)DumpThreadsMessage.getInstance());
    }

    protected BDaemonSession getDaemonSession() {
        return this.session;
    }

    public void setLogLevel(String logName, BDaemonLogLevel level) throws ConnectException, AuthenticationException {
        this.setLogLevel(logName, level, true);
    }

    public void setLogLevel(String logName, BDaemonLogLevel level, boolean save) throws ConnectException, AuthenticationException {
        if (this.logServletVersion == 1) {
            this.getDaemonSession().sendMessage((DaemonMessage)new SetLogLevelMessage(logName, level, this.forceLevel == null && save));
        } else if (this.logServletVersion >= 2) {
            Level javaLogLevel = null;
            switch (level.getOrdinal()) {
                case 3: {
                    javaLogLevel = Level.SEVERE;
                    break;
                }
                case 2: {
                    javaLogLevel = Level.WARNING;
                    break;
                }
                case 1: {
                    javaLogLevel = Level.INFO;
                    break;
                }
                case 0: {
                    javaLogLevel = Level.ALL;
                }
            }
            this.getDaemonSession().sendMessage((DaemonMessage)new SetLogLevelMessage(logName, javaLogLevel, this.forceLevel == null && save));
        } else {
            throw new UnsupportedOperationException("Unknown daemon logfilter servlet version");
        }
    }

    public void setLogLevel(String logName, Level level, boolean save) throws ConnectException, AuthenticationException {
        if (this.logServletVersion == 1) {
            BDaemonLogLevel logLevel;
            if (level == Level.ALL || level == Level.FINE || level == Level.FINER || level == Level.FINEST) {
                logLevel = BDaemonLogLevel.trace;
            } else if (level == Level.INFO || level == Level.CONFIG) {
                logLevel = BDaemonLogLevel.message;
            } else if (level == Level.WARNING) {
                logLevel = BDaemonLogLevel.warning;
            } else if (level == Level.SEVERE) {
                logLevel = BDaemonLogLevel.error;
            } else {
                throw new IllegalArgumentException("Unsupported Java Log Level: " + level);
            }
            this.getDaemonSession().sendMessage((DaemonMessage)new SetLogLevelMessage(logName, logLevel, this.forceLevel == null && save));
        } else if (this.logServletVersion >= 2) {
            this.getDaemonSession().sendMessage((DaemonMessage)new SetLogLevelMessage(logName, level, this.forceLevel == null && save));
        } else {
            throw new UnsupportedOperationException("Unknown daemon logfilter servlet version");
        }
    }

    public void saveLogLevels() throws ConnectException, AuthenticationException {
        this.getDaemonSession().sendMessage((DaemonMessage)SaveLogLevelMessage.getInstance());
    }

    public InputStream getDaemonOutput() throws ConnectException, AuthenticationException {
        return this.getDaemonOutput(true, false);
    }

    public InputStream getDaemonOutput(boolean follow, boolean updatesOnly) throws ConnectException, AuthenticationException {
        GetDaemonOutputMessage daemonOutputMessage = new GetDaemonOutputMessage(follow, updatesOnly);
        if (this.getDaemonSession().getHostProperties().isNiagara4()) {
            return ConsoleInputStream.make((InputStream)this.getDaemonSession().getWebSocketInputStream((GetOutputMessage)daemonOutputMessage, BDaemonSession.DEFAULT_TIMEOUT, STREAM_TIMEOUT_MILLIS), (boolean)true);
        }
        return ConsoleInputStream.make((InputStream)this.getDaemonSession().getInputStream((DaemonMessage)daemonOutputMessage, STREAM_TIMEOUT_MILLIS));
    }

    public String getLogForceLevel() {
        return this.forceLevel;
    }

    public BIcon getIcon() {
        return icon;
    }

    private static int initStreamTimeout() {
        int timeout = 500;
        try {
            timeout = AccessController.doPrivileged(() -> Integer.parseInt(System.getProperty("niagara.daemonsession.streamtimeout", "500")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return timeout;
    }

    public static int getStreamTimeoutMillis() {
        return STREAM_TIMEOUT_MILLIS;
    }

    static {
        Log.setLog((org.eclipse.jetty.util.log.Logger)NullLogger.getInstance());
        icon = BIcon.std((String)"daemon.png");
        log = Logger.getLogger("platDaemon.daemonSurrogate");
        STREAM_TIMEOUT_MILLIS = BDaemonSurrogate.initStreamTimeout();
    }
}

