/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ServerCertificateHealth;
import com.tridium.crypto.core.io.TrustAnchorConsumer;
import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.jetty.BJettyAcceptRateLimit;
import com.tridium.jetty.BJettyConnectionLimit;
import com.tridium.jetty.BJettyDoSFilter;
import com.tridium.jetty.BJettyInetAccessHandler;
import com.tridium.jetty.BJettyQoSFilter;
import com.tridium.jetty.BJettyServerConnector;
import com.tridium.jetty.BJettySizeLimitHandler;
import com.tridium.jetty.BNCSARequestLog;
import com.tridium.jetty.ContextSessionData;
import com.tridium.jetty.NiagaraAuthenticator;
import com.tridium.jetty.NiagaraDefaultHandler;
import com.tridium.jetty.NiagaraHttpSession;
import com.tridium.jetty.NiagaraLogger;
import com.tridium.jetty.NiagaraLoginService;
import com.tridium.jetty.NiagaraSecurityHandler;
import com.tridium.jetty.NiagaraSessionCache;
import com.tridium.jetty.NiagaraSessionDataStore;
import com.tridium.jetty.NiagaraSessionDataStoreFactory;
import com.tridium.jetty.NiagaraSessionHandler;
import com.tridium.jetty.NiagaraSessionIdManager;
import com.tridium.jetty.PrivilegedQueuedThreadPool;
import com.tridium.jetty.WebErrorHandler;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.nre.jetty.JettyThreadUtil;
import com.tridium.nre.jetty.JettyUtil;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.nre.util.InterfaceNetworkSettings;
import com.tridium.security.BServerCertificateHealth;
import com.tridium.session.SessionManager;
import com.tridium.sys.module.ModuleManager;
import com.tridium.sys.module.NModule;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.web.BAdditionalHttpsCerts;
import com.tridium.web.BProfileFilterFactory;
import com.tridium.web.filters.AddSubjectFilter;
import com.tridium.web.filters.ContextFilter;
import com.tridium.web.filters.LocaleFilter;
import com.tridium.web.filters.TridiumSecurityFilter;
import com.tridium.web.filters.WebStartServletFilter;
import com.tridium.web.servlets.LoginFileServlet;
import com.tridium.web.servlets.LoginServlet;
import com.tridium.web.servlets.LogoutServlet;
import com.tridium.web.servlets.PreloginServlet;
import com.tridium.web.servlets.WebStartServlet;
import com.tridium.web.session.NiagaraWebSession;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.security.ServerTlsParameters;
import javax.baja.nre.security.TlsCipherSuiteGroup;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.session.INiagaraSuperSession;
import javax.baja.session.SessionUtil;
import javax.baja.space.BISpaceNode;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.web.BINiagaraWebServlet;
import javax.baja.web.BWebServer;
import javax.baja.web.BWebService;
import javax.baja.web.BWebServlet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SessionCookieConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.providers.WebAppProvider;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.AcceptRateLimit;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.InetAccessHandler;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.SizeLimitHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionCache;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.DoSFilter;
import org.eclipse.jetty.servlets.QoSFilter;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="minThreads", type="int", defaultValue="Math.max(8, JettyThreadUtil.getBaseThreadCount(Runtime.getRuntime().availableProcessors()))", facets={@Facet(name="BFacets.MIN", value="Math.max(8, JettyThreadUtil.getBaseThreadCount(Runtime.getRuntime().availableProcessors()))")}), @NiagaraProperty(name="maxThreads", type="int", defaultValue="30"), @NiagaraProperty(name="threadIdleTimeout", type="BRelTime", defaultValue="BRelTime.makeMinutes(5)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(1)")}), @NiagaraProperty(name="httpConnectorSettings", type="BJettyServerConnector", defaultValue="new BJettyServerConnector()", flags=4), @NiagaraProperty(name="httpsConnectorSettings", type="BJettyServerConnector", defaultValue="new BJettyServerConnector()", flags=4), @NiagaraProperty(name="denialOfServiceSettings", type="BJettyDoSFilter", defaultValue="new BJettyDoSFilter()"), @NiagaraProperty(name="qualityOfServiceSettings", type="BJettyQoSFilter", defaultValue="new BJettyQoSFilter()"), @NiagaraProperty(name="connectionLimit", type="BJettyConnectionLimit", defaultValue="new BJettyConnectionLimit()"), @NiagaraProperty(name="acceptRateLimit", type="BJettyAcceptRateLimit", defaultValue="new BJettyAcceptRateLimit()"), @NiagaraProperty(name="inetAccessHandler", type="BJettyInetAccessHandler", defaultValue="new BJettyInetAccessHandler()"), @NiagaraProperty(name="sizeLimitHandler", type="BJettySizeLimitHandler", defaultValue="new BJettySizeLimitHandler()"), @NiagaraProperty(name="acceptorPriorityDelta", type="int", defaultValue="0", flags=4, facets={@Facet(name="BFacets.MIN", value="Thread.MIN_PRIORITY - Thread.NORM_PRIORITY"), @Facet(name="BFacets.MAX", value="Thread.MAX_PRIORITY - Thread.NORM_PRIORITY")}), @NiagaraProperty(name="NCSALog", type="BNCSARequestLog", defaultValue="new BNCSARequestLog()"), @NiagaraProperty(name="diagnosticsEnabled", type="boolean", defaultValue="false")})
@NiagaraAction(name="cacheSessionsAndRestart", flags=16)
public final class BJettyWebServer
extends BWebServer
implements TrustAnchorConsumer {
    @Generated
    public static final Property minThreads = BJettyWebServer.newProperty((int)0, (int)Math.max(8, JettyThreadUtil.getBaseThreadCount((int)Runtime.getRuntime().availableProcessors())), (BFacets)BFacets.make((String)"min", (int)Math.max(8, JettyThreadUtil.getBaseThreadCount((int)Runtime.getRuntime().availableProcessors()))));
    @Generated
    public static final Property maxThreads = BJettyWebServer.newProperty((int)0, (int)30, null);
    @Generated
    public static final Property threadIdleTimeout = BJettyWebServer.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    @Generated
    public static final Property httpConnectorSettings = BJettyWebServer.newProperty((int)4, (BValue)new BJettyServerConnector(), null);
    @Generated
    public static final Property httpsConnectorSettings = BJettyWebServer.newProperty((int)4, (BValue)new BJettyServerConnector(), null);
    @Generated
    public static final Property denialOfServiceSettings = BJettyWebServer.newProperty((int)0, (BValue)new BJettyDoSFilter(), null);
    @Generated
    public static final Property qualityOfServiceSettings = BJettyWebServer.newProperty((int)0, (BValue)new BJettyQoSFilter(), null);
    @Generated
    public static final Property connectionLimit = BJettyWebServer.newProperty((int)0, (BValue)new BJettyConnectionLimit(), null);
    @Generated
    public static final Property acceptRateLimit = BJettyWebServer.newProperty((int)0, (BValue)new BJettyAcceptRateLimit(), null);
    @Generated
    public static final Property inetAccessHandler = BJettyWebServer.newProperty((int)0, (BValue)new BJettyInetAccessHandler(), null);
    @Generated
    public static final Property sizeLimitHandler = BJettyWebServer.newProperty((int)0, (BValue)new BJettySizeLimitHandler(), null);
    @Generated
    public static final Property acceptorPriorityDelta = BJettyWebServer.newProperty((int)4, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)-4), (BFacets)BFacets.make((String)"max", (int)5)));
    @Generated
    public static final Property NCSALog = BJettyWebServer.newProperty((int)0, (BValue)new BNCSARequestLog(), null);
    @Generated
    public static final Property diagnosticsEnabled = BJettyWebServer.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Action cacheSessionsAndRestart = BJettyWebServer.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJettyWebServer.class);
    private static boolean ignoreHttpsSelectFailure = false;
    static final Context DIAGNOSTIC_CONTEXT = new BasicContext(Context.NULL, BFacets.make((String)"diagnostic", (BIDataValue)BBoolean.TRUE));
    private int selectorRestartCount = 0;
    private static final java.util.logging.Logger log = java.util.logging.Logger.getLogger("web");
    private static final String[] GZIP_MIME_TYPES = new String[]{"text/plain", "text/html", "text/css", "text/javascript", "application/xml", "application/xhtml+xml", "application/rss+xml", "application/javascript", "application/x-javascript", "application/json"};
    private static final Set<Property> restartBlacklist = Collections.unmodifiableSet(new HashSet<Property>(Arrays.asList(BWebService.requireHttpsForPasswords, BWebService.xFrameOptions, BWebService.loginTemplate, BWebService.clientEnvironments, BWebService.showStackTrace, BWebService.appletModuleCachingType, BAbstractService.status, BAbstractService.faultCause, BAbstractService.enabled, BWebServer.serverState)));
    private volatile Server jetty;
    private volatile ContextHandlerCollection contextHandlers;
    private volatile PrivilegedQueuedThreadPool threadPool;
    private volatile int minimumThreads = 0;
    private static final String HTTP_CONNECTOR_NAME = "niagaraHttp";
    private static final String HTTPS_CONNECTOR_NAME = "niagaraHttps";
    private volatile ServerConnector httpConnector;
    private volatile ServerConnector httpsConnector;
    private ContextSessionData contextSessionData;
    private volatile NCSARequestLog ncsaRequestLog;
    private volatile Authenticator authenticator;
    private boolean logHandlerSet;
    private static volatile Collection<TypeInfo> profileFilterFactories;
    private static final BINiagaraWebServlet[] EMPTY_SERVLET_ARRAY;
    private final Map<String, BINiagaraWebServlet> byServletName = new ConcurrentHashMap<String, BINiagaraWebServlet>();
    private final Map<BINiagaraWebServlet, Handler> byHandler = new ConcurrentHashMap<BINiagaraWebServlet, Handler>();
    private static final String preloginPath = "/prelogin";
    private static final String loginPath = "/login";
    private static final String logoutPath = "/logout";
    private static final String webstartPath = "/webstart";
    private static final String defaultRealmName = "station";
    private static final String jettySpyName = "stationJetty";
    private static final String downloadSpyName = "downloadTest";
    private static final java.util.logging.Logger diagnosticLog;
    private static final boolean validateCertificate;
    private static final int idleTimeout;
    private static final long HSTS_MAX_AGE;
    private String trustAnchorConsumerId = null;
    private static final Object restartLock;
    private static volatile Timer QNX_ACCEPTOR_THREAD_GC_TIMER;

    @Generated
    public int getMinThreads() {
        return this.getInt(minThreads);
    }

    @Generated
    public void setMinThreads(int v) {
        this.setInt(minThreads, v, null);
    }

    @Generated
    public int getMaxThreads() {
        return this.getInt(maxThreads);
    }

    @Generated
    public void setMaxThreads(int v) {
        this.setInt(maxThreads, v, null);
    }

    @Generated
    public BRelTime getThreadIdleTimeout() {
        return (BRelTime)this.get(threadIdleTimeout);
    }

    @Generated
    public void setThreadIdleTimeout(BRelTime v) {
        this.set(threadIdleTimeout, (BValue)v, null);
    }

    @Generated
    public BJettyServerConnector getHttpConnectorSettings() {
        return (BJettyServerConnector)this.get(httpConnectorSettings);
    }

    @Generated
    public void setHttpConnectorSettings(BJettyServerConnector v) {
        this.set(httpConnectorSettings, (BValue)v, null);
    }

    @Generated
    public BJettyServerConnector getHttpsConnectorSettings() {
        return (BJettyServerConnector)this.get(httpsConnectorSettings);
    }

    @Generated
    public void setHttpsConnectorSettings(BJettyServerConnector v) {
        this.set(httpsConnectorSettings, (BValue)v, null);
    }

    @Generated
    public BJettyDoSFilter getDenialOfServiceSettings() {
        return (BJettyDoSFilter)this.get(denialOfServiceSettings);
    }

    @Generated
    public void setDenialOfServiceSettings(BJettyDoSFilter v) {
        this.set(denialOfServiceSettings, (BValue)v, null);
    }

    @Generated
    public BJettyQoSFilter getQualityOfServiceSettings() {
        return (BJettyQoSFilter)this.get(qualityOfServiceSettings);
    }

    @Generated
    public void setQualityOfServiceSettings(BJettyQoSFilter v) {
        this.set(qualityOfServiceSettings, (BValue)v, null);
    }

    @Generated
    public BJettyConnectionLimit getConnectionLimit() {
        return (BJettyConnectionLimit)this.get(connectionLimit);
    }

    @Generated
    public void setConnectionLimit(BJettyConnectionLimit v) {
        this.set(connectionLimit, (BValue)v, null);
    }

    @Generated
    public BJettyAcceptRateLimit getAcceptRateLimit() {
        return (BJettyAcceptRateLimit)this.get(acceptRateLimit);
    }

    @Generated
    public void setAcceptRateLimit(BJettyAcceptRateLimit v) {
        this.set(acceptRateLimit, (BValue)v, null);
    }

    @Generated
    public BJettyInetAccessHandler getInetAccessHandler() {
        return (BJettyInetAccessHandler)this.get(inetAccessHandler);
    }

    @Generated
    public void setInetAccessHandler(BJettyInetAccessHandler v) {
        this.set(inetAccessHandler, (BValue)v, null);
    }

    @Generated
    public BJettySizeLimitHandler getSizeLimitHandler() {
        return (BJettySizeLimitHandler)this.get(sizeLimitHandler);
    }

    @Generated
    public void setSizeLimitHandler(BJettySizeLimitHandler v) {
        this.set(sizeLimitHandler, (BValue)v, null);
    }

    @Generated
    public int getAcceptorPriorityDelta() {
        return this.getInt(acceptorPriorityDelta);
    }

    @Generated
    public void setAcceptorPriorityDelta(int v) {
        this.setInt(acceptorPriorityDelta, v, null);
    }

    @Generated
    public BNCSARequestLog getNCSALog() {
        return (BNCSARequestLog)this.get(NCSALog);
    }

    @Generated
    public void setNCSALog(BNCSARequestLog v) {
        this.set(NCSALog, (BValue)v, null);
    }

    @Generated
    public boolean getDiagnosticsEnabled() {
        return this.getBoolean(diagnosticsEnabled);
    }

    @Generated
    public void setDiagnosticsEnabled(boolean v) {
        this.setBoolean(diagnosticsEnabled, v, null);
    }

    @Generated
    public void cacheSessionsAndRestart() {
        this.invoke(cacheSessionsAndRestart, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.addJettySpy();
        if (profileFilterFactories == null) {
            List list = Arrays.stream(Sys.getRegistry().getConcreteTypes(BProfileFilterFactory.TYPE.getTypeInfo())).filter(BProfileFilterFactory::isProfileFilterFactoryAllowed).collect(Collectors.toList());
            profileFilterFactories = Collections.unmodifiableList(list);
        }
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        BJettyWebServer.removeJettySpy();
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE, BWebServer.TYPE};
    }

    public void doStartWebServer() throws Exception {
        if (this.jetty != null && this.jetty.isRunning()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Jetty server already started");
            }
            return;
        }
        this.getWebService().setServerCertificateHealth(new BServerCertificateHealth());
        try {
            BJettyAcceptRateLimit jettyAcceptRateLimit;
            BJettyConnectionLimit jettyConnectionLimit;
            Log.setLog((Logger)NiagaraLogger.defaultLogger);
            this.removeAllJettyStatisticsSpy();
            this.removeAllJettyStructsSpy();
            if (this.authenticator == null) {
                this.authenticator = new NiagaraAuthenticator();
            }
            this.ncsaRequestLog = new NCSARequestLog();
            if (this.contextSessionData == null) {
                this.contextSessionData = new ContextSessionData();
            }
            AccessController.doPrivileged(() -> {
                this.threadPool = new PrivilegedQueuedThreadPool();
                this.threadPool.setAccessControlContext(AccessController.getContext());
                this.threadPool.setName("Jetty:ThreadPool");
                this.jetty = new Server((ThreadPool)this.threadPool);
                this.jetty.addBean((Object)new ScheduledExecutorScheduler());
                this.jetty.addBean((Object)new NiagaraSessionDataStoreFactory(this.contextSessionData));
                if (this.getDiagnosticsEnabled()) {
                    MBeanContainer mBeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
                    this.jetty.addEventListener((Container.Listener)mBeanContainer);
                    this.jetty.addBean((Object)mBeanContainer);
                    this.jetty.addBean((Object)Log.getLog());
                }
                this.jetty.setStopAtShutdown(true);
                this.jetty.setStopTimeout(15000L);
                return null;
            });
            NiagaraSessionIdManager sessionIdManager = new NiagaraSessionIdManager(this.jetty);
            AccessController.doPrivileged(() -> this.lambda$doStartWebServer$1((SessionIdManager)sessionIdManager));
            BWebService service = this.getWebService();
            HttpConfiguration baseHttpConfig = JettyUtil.makeBasicHttpConfiguration();
            if (service.getHttpEnabled()) {
                int acceptorThreads;
                HttpConfiguration config = new HttpConfiguration(baseHttpConfig);
                BJettyServerConnector serverConnectorConfig = this.getHttpConnectorSettings();
                BJettyWebServer.applyServerConfig(serverConnectorConfig, config);
                config.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
                if (service.getHttpsEnabled()) {
                    config.setSecurePort(service.getHttpsPort().getPublicServerPort());
                }
                if ((acceptorThreads = JettyThreadUtil.calcAcceptorThreads((int)serverConnectorConfig.getAcceptorThreads(), (int)Runtime.getRuntime().availableProcessors())) > 0 && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx) && QNX_ACCEPTOR_THREAD_GC_TIMER == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Starting GC task for acceptor thread usage");
                    }
                    QNX_ACCEPTOR_THREAD_GC_TIMER = new Timer("Jetty:ThreadPool-acceptor-gc", true);
                    QNX_ACCEPTOR_THREAD_GC_TIMER.scheduleAtFixedRate((TimerTask)new GCTimerTask(), 43200000L, 43200000L);
                }
                int selectorThreads = JettyThreadUtil.calcSelectorThreads((int)serverConnectorConfig.getSelectorThreads(), (int)Runtime.getRuntime().availableProcessors());
                this.httpConnector = AccessController.doPrivileged(() -> new NiagaraCustomConnector(this.jetty, acceptorThreads, selectorThreads, service.getHttpPort().getPublicServerPort(), false, new ConnectionFactory[]{new HttpConnectionFactory(config)}));
                this.httpConnector.setPort(service.getHttpPort().getBindingPort());
                this.httpConnector.setIdleTimeout((long)idleTimeout);
                if (service.getHttpPort().getBindToLoopback()) {
                    this.httpConnector.setHost("127.0.0.1");
                }
                this.httpConnector.setAcceptorPriorityDelta(this.getAcceptorPriorityDelta());
                this.httpConnector.setName(HTTP_CONNECTOR_NAME);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("creating ServerConnector with accept threads = " + this.httpConnector.getAcceptors() + " (delta = " + this.httpConnector.getAcceptorPriorityDelta() + "), selector threads = " + this.httpConnector.getSelectorManager().getSelectorCount());
                }
                AccessController.doPrivileged(() -> {
                    this.jetty.addConnector((Connector)this.httpConnector);
                    return null;
                });
            }
            if (service.getHttpsEnabled()) {
                SslContextFactory sslContextFactory;
                try {
                    sslContextFactory = AccessController.doPrivileged(() -> {
                        ServerCertificateHealth certStatus;
                        String protocol = this.getWebService().getHttpsMinProtocol().encodeToString();
                        TlsCipherSuiteGroup cipherSuiteGroup = this.getWebService().getCipherSuiteGroup().getCipherSuiteGroup();
                        CoreCryptoManager ccm = CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
                        BCertificateAliasAndPassword aliasAndPassword = this.getWebService().getMainCertAliasAndPassword();
                        SecretChars certPasswordChars = null;
                        String certAlias = null;
                        if (!aliasAndPassword.getPassword().isDefault()) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("using cert password to retrieve certificate " + aliasAndPassword.getAlias());
                            }
                            try {
                                certPasswordChars = AccessController.doPrivileged(() -> ((BPassword)aliasAndPassword.getPassword()).getSecretChars());
                            }
                            catch (Exception e) {
                                log.log(Level.SEVERE, "error decoding password for cert", e);
                            }
                            certStatus = ccm.checkServerCertificateStatus(aliasAndPassword.getAlias(), certPasswordChars, log);
                            this.getWebService().setServerCertificateHealth(new BServerCertificateHealth(certStatus));
                            certAlias = certStatus.getReturnedCert();
                            if ("default".equals(certAlias)) {
                                certPasswordChars = null;
                            }
                        } else {
                            certStatus = ccm.checkServerCertificateStatus(aliasAndPassword.getAlias(), null, log);
                            this.getWebService().setServerCertificateHealth(new BServerCertificateHealth(certStatus));
                            certAlias = certStatus.getReturnedCert();
                        }
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("service started with cert " + aliasAndPassword.getAlias());
                        }
                        if ("tridium".equals(certAlias) || "default".equals(certAlias)) {
                            log.warning("Using default TLS server certificate '" + certAlias + "' is not recommended. Generate a certificate specifically for this installation and sign it with a proper CA.");
                        }
                        boolean wantClientAuth = !ccm.getTrustAnchors().isEmpty();
                        ServerTlsParameters tlsParams = new ServerTlsParameters(protocol, certAlias, cipherSuiteGroup, wantClientAuth);
                        if (certPasswordChars != null) {
                            tlsParams.setKeyPassphrase(certPasswordChars.get());
                        }
                        if (cipherSuiteGroup != TlsCipherSuiteGroup.recommended) {
                            log.warning("not using recommended tls cipher suite group, using " + tlsParams);
                        } else if (log.isLoggable(Level.FINE)) {
                            log.fine("using " + tlsParams);
                        }
                        Map<Object, Object> sniAliases = Collections.emptyMap();
                        try {
                            sniAliases = this.getSniAliases();
                        }
                        catch (Exception e) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.WARNING, "unable to retrieve sni aliases", e);
                            }
                            log.warning("unable to retrieve sni aliases");
                        }
                        try {
                            SslContextFactory.Server factory = ccm.getSslContextFactory(tlsParams, sniAliases);
                            this.updateAdditionalCertStatuses(factory.getKeyStore());
                            if (factory == null) {
                                throw new IOException("Could not initialize SslContextFactory");
                            }
                            factory.setValidateCerts(false);
                            SslContextFactory.Server server = factory;
                            return server;
                        }
                        finally {
                            for (SecretChars secretChars : sniAliases.values()) {
                                if (secretChars == null) continue;
                                secretChars.close();
                            }
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
                HttpConfiguration config = new HttpConfiguration(baseHttpConfig);
                BJettyServerConnector serverConnectorConfig = this.getHttpsConnectorSettings();
                BJettyWebServer.applyServerConfig(serverConnectorConfig, config);
                config.setSecureScheme("https");
                config.setSecurePort(service.getHttpsPort().getBindingPort());
                SecureRequestCustomizer customizer = new SecureRequestCustomizer();
                customizer.setStsMaxAge(HSTS_MAX_AGE);
                config.addCustomizer((HttpConfiguration.Customizer)customizer);
                int acceptorThreads = JettyThreadUtil.calcAcceptorThreads((int)serverConnectorConfig.getAcceptorThreads(), (int)Runtime.getRuntime().availableProcessors());
                if (acceptorThreads > 0 && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx) && QNX_ACCEPTOR_THREAD_GC_TIMER == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Starting GC task for acceptor thread usage");
                    }
                    QNX_ACCEPTOR_THREAD_GC_TIMER = new Timer("Jetty:ThreadPool-acceptor-gc", true);
                    QNX_ACCEPTOR_THREAD_GC_TIMER.scheduleAtFixedRate((TimerTask)new GCTimerTask(), 43200000L, 43200000L);
                }
                int selectorThreads = JettyThreadUtil.calcSelectorThreads((int)serverConnectorConfig.getSelectorThreads(), (int)Runtime.getRuntime().availableProcessors());
                this.httpsConnector = AccessController.doPrivileged(() -> new NiagaraCustomConnector(this.jetty, acceptorThreads, selectorThreads, service.getHttpsPort().getPublicServerPort(), true, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.toString()), new HttpConnectionFactory(config)}));
                this.httpsConnector.setPort(service.getHttpsPort().getBindingPort());
                this.httpsConnector.setIdleTimeout((long)idleTimeout);
                if (service.getHttpsPort().getBindToLoopback()) {
                    this.httpsConnector.setHost("127.0.0.1");
                }
                this.httpsConnector.setAcceptorPriorityDelta(this.getAcceptorPriorityDelta());
                this.httpsConnector.setName(HTTPS_CONNECTOR_NAME);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("creating secure ServerConnector with accept threads = " + this.httpsConnector.getAcceptors() + " (delta = " + this.httpsConnector.getAcceptorPriorityDelta() + "), selector threads = " + this.httpsConnector.getSelectorManager().getSelectorCount());
                }
                AccessController.doPrivileged(() -> {
                    this.jetty.addConnector((Connector)this.httpsConnector);
                    return null;
                });
            }
            if (this.getDiagnosticsEnabled()) {
                this.initializeJettyStatistics();
            }
            if (this.authenticator instanceof NiagaraAuthenticator) {
                boolean webLauncherEnabled = service.getWebStartConfig().getWebStartEnabled();
                ((NiagaraAuthenticator)this.authenticator).setWebStartEnabled(webLauncherEnabled);
            }
            NiagaraLoginService loginService = new NiagaraLoginService(defaultRealmName);
            AccessController.doPrivileged(() -> this.jetty.addBean((Object)loginService));
            if (this.contextHandlers != null) {
                AccessController.doPrivileged(() -> {
                    this.contextHandlers.destroy();
                    return null;
                });
                this.contextHandlers = null;
            }
            this.contextHandlers = new ContextHandlerCollection();
            this.addModuleWebAppHandlers();
            if (this.getQualityOfServiceSettings().getEnabled() && log.isLoggable(Level.FINE)) {
                log.fine("applying QoSFilter settings to web server (maxRequests = " + this.getQualityOfServiceSettings().getMaxRequests() + ")");
            }
            if (this.getDenialOfServiceSettings().getEnabled() && log.isLoggable(Level.FINE)) {
                log.fine("applying DoSFilter settings to web server (maxRequestsPerSec = " + this.getDenialOfServiceSettings().getMaxRequestsPerSec() + ")");
            }
            this.byServletName.values().forEach(this::addWebServlet);
            HandlerCollection allHandlers = new HandlerCollection();
            allHandlers.addHandler((Handler)new NiagaraDefaultHandler());
            if (this.getWebService().getGzipEnabled()) {
                GzipHandler gzipHandler = new GzipHandler();
                gzipHandler.setHandler((Handler)this.contextHandlers);
                gzipHandler.addIncludedMimeTypes(GZIP_MIME_TYPES);
                allHandlers.addHandler((Handler)gzipHandler);
            }
            allHandlers.addHandler((Handler)this.contextHandlers);
            if (this.getNCSALog().getEnabled()) {
                this.logHandlerSet = true;
                RequestLogHandler logHandler = new RequestLogHandler();
                logHandler.setRequestLog((RequestLog)this.ncsaRequestLog);
                this.updateLoggingConfiguration();
                allHandlers.addHandler((Handler)logHandler);
            }
            Object coreHandler = allHandlers;
            if (this.getDiagnosticsEnabled()) {
                StatisticsHandler statisticsHandler = new StatisticsHandler();
                statisticsHandler.setHandler((Handler)allHandlers);
                DiagnosticBenchmarkHandler diagnosticBenchmarkHandler = new DiagnosticBenchmarkHandler();
                diagnosticBenchmarkHandler.setHandler((Handler)statisticsHandler);
                coreHandler = diagnosticBenchmarkHandler;
            }
            if ((jettyConnectionLimit = this.getConnectionLimit()).getEnabled()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("creating ConnectionLimit with maxConnections = " + jettyConnectionLimit.getMaxConnections() + ", idleTimeout = " + jettyConnectionLimit.getIdleTimeout());
                }
                NiagaraConnectionLimit connectionLimit = new NiagaraConnectionLimit(jettyConnectionLimit.getMaxConnections(), this.jetty);
                connectionLimit.setIdleTimeout(jettyConnectionLimit.getIdleTimeout());
                AccessController.doPrivileged(() -> {
                    this.jetty.addBean((Object)connectionLimit);
                    return null;
                });
            }
            if ((jettyAcceptRateLimit = this.getAcceptRateLimit()).getEnabled()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("creating AcceptRateLimit with acceptRateLimit = " + jettyAcceptRateLimit.getAcceptRateLimit() + ", period = " + jettyAcceptRateLimit.getPeriod());
                }
                AcceptRateLimit acceptRateLimit = new AcceptRateLimit(jettyAcceptRateLimit.getAcceptRateLimit(), jettyAcceptRateLimit.getPeriod(), TimeUnit.MILLISECONDS, this.jetty);
                AccessController.doPrivileged(() -> {
                    this.jetty.addBean((Object)acceptRateLimit);
                    return null;
                });
            }
            InetAccessHandler inetAccessHandler = null;
            BJettyInetAccessHandler jettyInetAccessHandler = this.getInetAccessHandler();
            if (jettyInetAccessHandler.getEnabled()) {
                inetAccessHandler = new InetAccessHandler();
                String includeListOrEmpty = Optional.ofNullable(jettyInetAccessHandler.getAllowedList()).orElse("").trim();
                String excludeListOrEmpty = Optional.ofNullable(jettyInetAccessHandler.getBlockedList()).orElse("").trim();
                LinkedHashSet<String> excludes = new LinkedHashSet<String>(Arrays.asList(TextUtil.split((String)excludeListOrEmpty, (char)',')));
                LinkedHashSet<String> includes = new LinkedHashSet<String>(Arrays.asList(TextUtil.split((String)includeListOrEmpty, (char)',')));
                LinkedHashSet<String> localAdaptersSet = new LinkedHashSet<String>();
                if (!includes.isEmpty() && jettyInetAccessHandler.getAllowLocalAdapters()) {
                    IPAddressUtil.clearLocalHostCache();
                    IPAddressUtil.getLocalHost();
                    IPAddressUtil.getLocalHost(null);
                    for (InterfaceNetworkSettings localAdapter : IPAddressUtil.getLocalHostInterfaces()) {
                        String localAddress = localAdapter.getInetAddress().getHostAddress();
                        localAdaptersSet.add(localAddress);
                    }
                }
                LinkedHashSet<String> loopbackSet = new LinkedHashSet<String>();
                if (!includes.isEmpty() && jettyInetAccessHandler.getAllowLoopback()) {
                    loopbackSet.addAll(Arrays.asList("127.0.0.1", "::1"));
                }
                if (!includes.isEmpty() || excludes.isEmpty()) {
                    if (!includes.isEmpty() && excludes.isEmpty()) {
                        includes.addAll(loopbackSet);
                        includes.addAll(localAdaptersSet);
                        excludes.addAll(Arrays.asList("0.0.0.0", "::"));
                    } else if (!includes.isEmpty() || !excludes.isEmpty()) {
                        includes.addAll(loopbackSet);
                        includes.addAll(localAdaptersSet);
                    }
                }
                if (!includes.isEmpty()) {
                    inetAccessHandler.include(includes.toArray(new String[0]));
                }
                if (!excludes.isEmpty()) {
                    inetAccessHandler.exclude(excludes.toArray(new String[0]));
                }
                if (this.httpConnector != null) {
                    inetAccessHandler.includeConnector(this.httpConnector.getName());
                }
                if (this.httpsConnector != null) {
                    inetAccessHandler.includeConnector(this.httpsConnector.getName());
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("creating InetAccessHandler with include list '" + (includes.isEmpty() ? "[*]" : includes) + "', exclude list '" + excludes + "'");
                }
            }
            SizeLimitHandler sizeLimitHandler = null;
            BJettySizeLimitHandler jettySizeLimitHandler = this.getSizeLimitHandler();
            if (jettySizeLimitHandler.getEnabled()) {
                long requestLimit = jettySizeLimitHandler.getRequestLimit();
                long responseLimit = jettySizeLimitHandler.getResponseLimit();
                sizeLimitHandler = new SizeLimitHandler(requestLimit, responseLimit);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("creating SizeLimitHandler with request size limit " + requestLimit + ", response size limit " + responseLimit);
                }
            }
            if (!java.util.logging.Logger.getLogger("web.jetty").isLoggable(Level.WARNING) && (this.getDenialOfServiceSettings().getEnabled() || this.getQualityOfServiceSettings().getEnabled() || this.getAcceptRateLimit().getEnabled() || this.getConnectionLimit().getEnabled() || this.getInetAccessHandler().getEnabled() || this.getSizeLimitHandler().getEnabled())) {
                log.warning("Jetty DoSFilter, QoSFilter, AcceptRateLimit, ConnectionLimit, InetAccessHandler, or SizeLimitHandler protection is enabled and may prevent or limit valid web connections to this host.");
                log.warning("Consider switching the 'web.jetty' log level to WARNING to see if any valid web connections have been interrupted and adjust settings as required.");
            }
            NiagaraSecurityHandler blockTraceHandler = new NiagaraSecurityHandler();
            blockTraceHandler.setHandler((Handler)coreHandler);
            coreHandler = blockTraceHandler;
            if (sizeLimitHandler != null) {
                sizeLimitHandler.setHandler((Handler)coreHandler);
                coreHandler = sizeLimitHandler;
            }
            if (inetAccessHandler != null) {
                inetAccessHandler.setHandler((Handler)coreHandler);
                coreHandler = inetAccessHandler;
            }
            Object _coreHandler = coreHandler;
            AccessController.doPrivileged(() -> this.lambda$doStartWebServer$11((Handler)_coreHandler));
            AccessController.doPrivileged(() -> {
                this.updateThreadPool();
                return null;
            });
            try {
                AccessController.doPrivileged(() -> {
                    this.jetty.start();
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            String httpStarted = "HTTP port " + service.getHttpPort().getPublicServerPort();
            String httpsStarted = "HTTPS port " + service.getHttpsPort().getPublicServerPort();
            BWebService webService = this.getWebService();
            if (webService.getHttpEnabled() && webService.getHttpsEnabled()) {
                log.info("Jetty web server started on " + httpsStarted + " and " + httpStarted);
            } else if (webService.getHttpEnabled()) {
                log.info("Jetty web server started on " + httpStarted);
            } else if (webService.getHttpsEnabled()) {
                log.info("Jetty web server started on " + httpsStarted);
            } else {
                log.info("Jetty web server started (HTTP and HTTPS disabled)");
            }
            if (this.getDiagnosticsEnabled()) {
                this.addAllJettyStatisticsSpy();
            }
            this.addAllJettyStructsSpy();
        }
        catch (BindException e) {
            BWebService webService = this.getWebService();
            int httpPort = webService.getHttpPort().getPublicServerPort();
            int httpsPort = webService.getHttpsPort().getPublicServerPort();
            if (webService.getHttpEnabled() && webService.getHttpsEnabled()) {
                throw new BindException(String.format("Failed to bind to https port [%d], http port [%d], or both", httpsPort, httpPort));
            }
            if (webService.getHttpEnabled()) {
                throw new BindException(String.format("Failed to bind to http port [%d]", httpPort));
            }
            throw new BindException(String.format("Failed to bind to https port [%d]", httpsPort));
        }
        catch (MultiException e) {
            List contents = e.getThrowables();
            for (Throwable t : contents) {
                if (t instanceof BindException) continue;
                throw e;
            }
            BWebService webService = this.getWebService();
            int httpPort = webService.getHttpPort().getPublicServerPort();
            int httpsPort = webService.getHttpsPort().getPublicServerPort();
            throw new BindException(String.format("Failed to bind to https port [%d], http port [%d], or both", httpPort, httpsPort));
        }
        this.trustAnchorConsumerId = CoreCryptoManager.get().registerTrustAnchorConsumer((TrustAnchorConsumer)this);
    }

    private Map<String, SecretChars> getSniAliases() {
        BAdditionalHttpsCerts[] additionalHttpsCerts = (BAdditionalHttpsCerts[])this.getWebService().getChildren(BAdditionalHttpsCerts.class);
        if (additionalHttpsCerts.length > 0) {
            return AccessController.doPrivileged(() -> additionalHttpsCerts[0].getCertAliases());
        }
        return Collections.emptyMap();
    }

    private void updateAdditionalCertStatuses(KeyStore keyStore) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        BAdditionalHttpsCerts[] additionalHttpsCerts = (BAdditionalHttpsCerts[])this.getWebService().getChildren(BAdditionalHttpsCerts.class);
        if (additionalHttpsCerts.length > 0) {
            additionalHttpsCerts[0].updateSniStatus(keyStore);
        }
    }

    public void doStopWebServer() throws Exception {
        this.doStopWebServer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStopWebServer(Context context) throws Exception {
        try {
            BBoolean contextFacet;
            BBoolean retainSessions = BBoolean.FALSE;
            if (context != null && (contextFacet = (BBoolean)context.getFacet("retainSessions")) != null) {
                retainSessions = contextFacet;
            }
            if (!retainSessions.isActive()) {
                this.invalidateAllSessions();
            } else {
                SessionManager.getNiagaraSessions(NiagaraWebSession.class).forEach(session -> ((NiagaraHttpSession)session).removeAllHttpSessions());
            }
            this.removeAllJettyStatisticsSpy();
            this.removeAllJettyStructsSpy();
            CoreCryptoManager.get().unregisterTrustAnchorConsumer(this.trustAnchorConsumerId);
            try {
                AccessController.doPrivileged(() -> {
                    if (this.jetty != null && !this.jetty.isStopping() && !this.jetty.isStopped()) {
                        if (QNX_ACCEPTOR_THREAD_GC_TIMER != null) {
                            QNX_ACCEPTOR_THREAD_GC_TIMER.cancel();
                            QNX_ACCEPTOR_THREAD_GC_TIMER = null;
                        }
                        try {
                            for (Connector connector : this.jetty.getConnectors()) {
                                if (!(connector instanceof ServerConnector)) continue;
                                ServerConnector serverConnector = (ServerConnector)connector;
                                serverConnector.getSelectorManager().stop();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (this.jetty != null) {
                                this.jetty.stop();
                                this.jetty.destroy();
                                this.jetty = null;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        finally {
            if (this.threadPool != null && !this.threadPool.isStopped()) {
                if (!this.threadPool.isStopping()) {
                    this.threadPool.stop();
                }
                this.threadPool.join();
            }
        }
        log.info("Jetty stopped");
    }

    protected void doWebServiceConfigurationChanged(Property property, Context context) {
        if (BWebService.logFileDirectory == property) {
            this.updateLoggingConfiguration();
        }
    }

    protected boolean isRestartRequired(Property property, Context context) {
        return context != DIAGNOSTIC_CONTEXT && !restartBlacklist.contains(property);
    }

    public void updateTrustAnchors() {
        this.scheduleRestart(BRelTime.make((long)120000L), true);
    }

    protected synchronized void scheduleRestart(BRelTime delay, boolean cacheSessions) {
        this.restartTicket.cancel();
        if (!this.isRunning()) {
            return;
        }
        this.restartTicket = cacheSessions ? Clock.schedule((BComponent)this, (BRelTime)delay, (Action)cacheSessionsAndRestart, null) : Clock.schedule((BComponent)this, (BRelTime)delay, (Action)restart, null);
    }

    protected void invalidateAllSessions() {
        try {
            for (NiagaraWebSession niagaraSession : SessionManager.getNiagaraSessions(NiagaraWebSession.class)) {
                niagaraSession.invalidate();
            }
        }
        catch (Exception e) {
            SessionManager.logger.warning(() -> "Could not invalidate HTTP sessions. Cause is: " + e.getLocalizedMessage());
        }
    }

    private void addModuleWebAppHandlers() {
        DeploymentManager deployer = new DeploymentManager();
        WebAppProvider provider = new WebAppProvider();
        Arrays.stream((NModuleInfo[])Sys.getRegistry().getModules()).filter(NModuleInfo::isWar).forEach(info -> {
            RuntimeProfile runtimeProfile = info.getRuntimeProfile();
            AccessController.doPrivileged(() -> {
                try {
                    NModule module = ModuleManager.instance.loadModule(info.getModuleName(), runtimeProfile);
                    App app = new App(deployer, (AppProvider)provider, module.getFile().getAbsolutePath());
                    WebAppContext context = (WebAppContext)app.getContextHandler();
                    context.setClassLoader(BJettyWebServer.getWebAppClassLoader(module));
                    context.setContextPath("/" + info.getModuleName());
                    context.setAllowNullPathInfo(true);
                    this.configureNiagaraWebApp((ServletContextHandler)context);
                    this.configureSameSite(context.getServletContext());
                    this.contextHandlers.addHandler((Handler)context);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Could not load Web App for: " + info, e);
                }
                return null;
            });
        });
    }

    private void configureNiagaraWebApp(ServletContextHandler context) {
        BJettyQoSFilter qosFilterSettings;
        context.setErrorHandler((ErrorHandler)new WebErrorHandler());
        context.setInitParameter("org.eclipse.jetty.servlet.SessionPath", "/");
        context.setInitParameter("org.eclipse.jetty.servlet.SessionIdPathParameterName", "none");
        context.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        security.setConstraintMappings(Collections.singletonList(BJettyWebServer.makeAllMapping()));
        security.setAuthenticator(this.authenticator);
        security.setRealmName(defaultRealmName);
        context.setSecurityHandler((SecurityHandler)security);
        if (this.getDiagnosticsEnabled()) {
            context.addFilter(new FilterHolder((Filter)new DiagnosticBenchmarkFilter(context.getDisplayName())), "/*", null);
        }
        if (profileFilterFactories != null) {
            profileFilterFactories.forEach(typeInfo -> {
                try {
                    BProfileFilterFactory factory = (BProfileFilterFactory)typeInfo.getInstance();
                    factory.makeFilter().ifPresent(f -> context.addFilter(new FilterHolder(f), factory.getPathSpec(), null));
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Could not create profile filter from: " + typeInfo, e);
                }
            });
        }
        context.addFilter(AddSubjectFilter.class, "/*", null);
        context.addFilter(TridiumSecurityFilter.class, "/*", null);
        context.addFilter(LocaleFilter.class, "/*", null);
        context.addFilter(ContextFilter.class, "/*", null);
        context.addFilter(WebStartServletFilter.class, "/*", null);
        BJettyDoSFilter dosFilterSettings = this.getDenialOfServiceSettings();
        if (dosFilterSettings.getEnabled()) {
            FilterHolder dosHolder = new FilterHolder(DoSFilter.class);
            dosHolder.setInitParameter("maxRequestsPerSec", String.valueOf(dosFilterSettings.getMaxRequestsPerSec()));
            dosHolder.setInitParameter("delayMs", String.valueOf(dosFilterSettings.getDelayMs()));
            dosHolder.setInitParameter("maxWaitMs", String.valueOf(dosFilterSettings.getMaxWaitMs()));
            dosHolder.setInitParameter("throttledRequests", String.valueOf(dosFilterSettings.getThrottledRequests()));
            dosHolder.setInitParameter("throttleMs", String.valueOf(dosFilterSettings.getThrottleMs()));
            dosHolder.setInitParameter("maxRequestMs", String.valueOf(dosFilterSettings.getMaxRequestMs()));
            dosHolder.setInitParameter("maxIdleTrackerMs", String.valueOf(dosFilterSettings.getMaxIdleTrackerMs()));
            dosHolder.setInitParameter("insertHeaders", String.valueOf(dosFilterSettings.getInsertHeaders()));
            dosHolder.setInitParameter("trackSessions", String.valueOf(dosFilterSettings.getTrackSessions()));
            dosHolder.setInitParameter("remotePort", String.valueOf(dosFilterSettings.getRemotePort()));
            dosHolder.setInitParameter("ipWhitelist", String.valueOf(dosFilterSettings.getIpWhitelist()));
            dosHolder.setInitParameter("managedAttr", String.valueOf(dosFilterSettings.getManagedAttr()));
            dosHolder.setInitParameter("tooManyCode", String.valueOf(dosFilterSettings.getTooManyCode()));
            context.addFilter(dosHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        if ((qosFilterSettings = this.getQualityOfServiceSettings()).getEnabled()) {
            FilterHolder qosHolder = new FilterHolder(QoSFilter.class);
            qosHolder.setInitParameter("maxRequests", String.valueOf(qosFilterSettings.getMaxRequests()));
            qosHolder.setInitParameter("maxPriority", String.valueOf(qosFilterSettings.getMaxPriority()));
            qosHolder.setInitParameter("waitMs", String.valueOf(qosFilterSettings.getWaitMs()));
            qosHolder.setInitParameter("suspendMs", String.valueOf(qosFilterSettings.getSuspendMs()));
            qosHolder.setInitParameter("managedAttr", String.valueOf(qosFilterSettings.getManagedAttr()));
            context.addFilter(qosHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        AccessController.doPrivileged(() -> {
            context.addServlet(new ServletHolder((Servlet)new PreloginServlet()), preloginPath);
            context.addServlet(new ServletHolder((Servlet)new LoginServlet()), loginPath);
            context.addServlet(new ServletHolder((Servlet)new LoginFileServlet()), "/login/*");
            context.addServlet(new ServletHolder((Servlet)new LogoutServlet()), logoutPath);
            return null;
        });
        context.addServlet(new ServletHolder((Servlet)new WebStartServlet()), "/webstart/*");
        context.setSessionHandler(BJettyWebServer.newSessionHandler(this.contextSessionData));
    }

    private static ConstraintMapping makeAllMapping() {
        Constraint constraint = new Constraint();
        constraint.setName("FORM");
        constraint.setAuthenticate(true);
        constraint.setRoles(new String[]{"**", "*"});
        BWebService service = (BWebService)Sys.getService((Type)BWebService.TYPE);
        if (service.getHttpsEnabled() && service.getHttpsOnly()) {
            constraint.setDataConstraint(2);
        }
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setPathSpec("/*");
        return mapping;
    }

    private void updateThreadPool() {
        if (this.threadPool != null) {
            int connectorThreadBaseline = 0;
            for (Connector connector : this.jetty.getConnectors()) {
                if (!(connector instanceof ServerConnector)) continue;
                ServerConnector serverConnector = (ServerConnector)connector;
                connectorThreadBaseline += serverConnector.getAcceptors();
                connectorThreadBaseline += serverConnector.getSelectorManager().getSelectorCount();
            }
            this.threadPool.setMinThreads(this.getMinThreads() + connectorThreadBaseline);
            this.threadPool.setMaxThreads(this.getMaxThreads() + connectorThreadBaseline);
            this.threadPool.setIdleTimeout((int)this.getThreadIdleTimeout().getMillis());
            this.minimumThreads = this.threadPool.getMinThreads();
        }
    }

    private void updateLoggingConfiguration() {
        AccessController.doPrivileged(() -> {
            if (this.ncsaRequestLog != null) {
                try {
                    this.ncsaRequestLog.stop();
                    BNCSARequestLog options = this.getNCSALog();
                    this.ncsaRequestLog.setFilename(BJettyWebServer.ordToDirPath(this.getWebService().getLogFileDirectory()) + "/yyyy_mm_dd.request.log");
                    this.ncsaRequestLog.setRetainDays(options.getRetainDays());
                    this.ncsaRequestLog.setAppend(true);
                    this.ncsaRequestLog.setExtended(options.getExtendedFormat());
                    this.ncsaRequestLog.setLogCookies(options.getLogCookies());
                    this.ncsaRequestLog.setLogTimeZone(options.getLogTimeZone().getId());
                    if (options.getEnabled() && !this.logHandlerSet) {
                        this.scheduleRestart(BRelTime.make((long)1L));
                    }
                    if (this.getNCSALog().getEnabled()) {
                        this.ncsaRequestLog.start();
                    }
                }
                catch (Exception e) {
                    log.warning(this.getLexicon().getText("j.logConfigEx", new Object[]{e}));
                }
            }
            return null;
        });
    }

    private static String ordToDirPath(BOrd ord) throws Exception {
        OrdQuery[] queries = ord.parse();
        OrdQuery lastQuery = queries[queries.length - 1];
        if (lastQuery instanceof FilePath) {
            File dir = BFileSystem.INSTANCE.pathToLocalFile((FilePath)lastQuery);
            dir.mkdirs();
            return dir.getAbsolutePath();
        }
        throw new IllegalStateException("not a directory: " + ord);
    }

    private static void applyServerConfig(BJettyServerConnector serverConnectorConfig, HttpConfiguration config) {
        if (serverConnectorConfig.getOutputBufferSize() > 0) {
            config.setOutputBufferSize(serverConnectorConfig.getOutputBufferSize());
        }
        if (serverConnectorConfig.getOutputAggregationSize() > 0) {
            config.setOutputAggregationSize(serverConnectorConfig.getOutputAggregationSize());
        }
        if (serverConnectorConfig.getHeaderCacheSize() > -1) {
            config.setHeaderCacheSize(serverConnectorConfig.getHeaderCacheSize());
        }
        if (serverConnectorConfig.getRequestHeaderSize() > 0) {
            config.setRequestHeaderSize(serverConnectorConfig.getRequestHeaderSize());
        }
        if (serverConnectorConfig.getResponseHeaderSize() > 0) {
            config.setResponseHeaderSize(serverConnectorConfig.getResponseHeaderSize());
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (minThreads == property || maxThreads == property || threadIdleTimeout == property) {
            this.post(this::updateThreadPool);
        } else if (NCSALog == property) {
            this.post(this::updateLoggingConfiguration);
        } else {
            super.changed(property, context);
            if (this.isRestartRequired(property, context)) {
                this.scheduleRestart();
            }
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        Property prop;
        if (slot.isProperty() && ((prop = slot.asProperty()) == minThreads || prop == maxThreads)) {
            int minThreadCount = this.getComponentSpace() != null && this.getComponentSpace().isProxyComponentSpace() ? FoxRpcUtil.doSilentRpc((BISpaceNode)this, (String)"calcMinNeededThreads", (Object[])new Object[0]).orElseGet(() -> this.calcMinNeededThreads(null)).intValue() : this.calcMinNeededThreads(null);
            if (prop == minThreads) {
                return BFacets.make((BFacets)minThreads.getFacets(), (BFacets)BFacets.make((String)"max", (int)this.getMaxThreads()));
            }
            int maxThreadsMin = Math.max(this.getMinThreads(), ((BNumber)minThreads.getDefaultValue()).getInt() + 2);
            return BFacets.make((String)"min", (int)Math.max(maxThreadsMin, minThreadCount));
        }
        return super.getSlotFacets(slot);
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.fox), @Transport(type=TransportType.box)}, permissions="r")
    public int calcMinNeededThreads(Context cx) {
        return JettyThreadUtil.getBaseThreadCount((int)this.getCores(cx)) + Optional.ofNullable(this.jetty).map(JettyThreadUtil::getThreadCount).orElseGet(this::calcThreadsFromProperties);
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox)}, permissions="r")
    public int getCores(Context cx) {
        return Runtime.getRuntime().availableProcessors();
    }

    private int calcThreadsFromProperties() {
        int cores = this.getComponentSpace() != null && this.getComponentSpace().isProxyComponentSpace() ? FoxRpcUtil.doSilentRpc((BISpaceNode)this, (String)"getCores", (Object[])new Object[0]).orElseGet(() -> this.getCores(null)).intValue() : this.getCores(null);
        return this.getProperties().stream().filter(property -> property.getType().is(BJettyServerConnector.TYPE)).map(property -> (BJettyServerConnector)this.get((Property)property)).mapToInt(property -> JettyThreadUtil.calcThreads((int)property.getAcceptorThreads(), (int)property.getSelectorThreads(), (int)cores)).sum();
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this.getPropertyValidator(new Property[]{property}, context);
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        List<Property> props = Arrays.asList(properties);
        if (props.stream().anyMatch(property -> property.getType().is(BJettyServerConnector.TYPE))) {
            return new ConnectorThreadPropertyValidator();
        }
        if (props.contains(minThreads) || props.contains(maxThreads)) {
            return new ThreadCountPropertyValidator();
        }
        return super.getPropertyValidator(properties, context);
    }

    private static ClassLoader getWebAppClassLoader(NModule module) {
        return new CompositeClassLoader((ClassLoader)module.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BWebServlet[] getWebServlets() {
        Map<String, BINiagaraWebServlet> map = this.byServletName;
        synchronized (map) {
            ArrayList<BWebServlet> webServlets = new ArrayList<BWebServlet>(this.byServletName.size());
            for (BINiagaraWebServlet servlet : this.byServletName.values()) {
                if (!(servlet instanceof BWebServlet)) continue;
                webServlets.add((BWebServlet)servlet);
            }
            return webServlets.toArray(EMPTY_WEB_SERVLET_ARRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BINiagaraWebServlet[] getServlets() {
        Map<String, BINiagaraWebServlet> map = this.byServletName;
        synchronized (map) {
            return this.byServletName.values().toArray(EMPTY_SERVLET_ARRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRegister(BINiagaraWebServlet servlet) {
        BINiagaraWebServlet registeredServlet;
        String name = servlet.getServletName();
        if (!SlotPath.isValidName((String)name)) {
            log.log(Level.SEVERE, Lexicon.make((String)"web").getText("web.badServletName", new Object[]{name}));
            servlet.setValidServletName(false);
            return;
        }
        Map<String, BINiagaraWebServlet> map = this.byServletName;
        synchronized (map) {
            registeredServlet = this.byServletName.putIfAbsent(name, servlet);
        }
        if (registeredServlet == null) {
            servlet.setValidServletName(true);
            this.addWebServlet(servlet);
        } else if (registeredServlet != servlet) {
            log.log(Level.SEVERE, Lexicon.make((String)"web").getText("web.duplicateServlet", new Object[]{name}));
            servlet.setValidServletName(false);
        }
    }

    private void addWebServlet(BINiagaraWebServlet servlet) {
        if (this.contextHandlers != null && this.jetty != null) {
            AccessController.doPrivileged(() -> {
                String servletName = servlet.getServletName();
                ServletContextHandler wsHandler = new ServletContextHandler(3);
                wsHandler.setContextPath("/" + servletName);
                wsHandler.addServlet(new ServletHolder((Servlet)servlet.getHttpServlet()), "/*");
                wsHandler.setAllowNullPathInfo(true);
                this.configureNiagaraWebApp(wsHandler);
                this.byHandler.put(servlet, (Handler)wsHandler);
                if (this.contextHandlers.isStarted()) {
                    wsHandler.setServer(this.jetty);
                    this.contextHandlers.addManaged((LifeCycle)wsHandler);
                }
                this.configureSameSite(wsHandler.getServletContext());
                this.contextHandlers.addHandler((Handler)wsHandler);
                return null;
            });
        }
    }

    private void configureSameSite(ContextHandler.Context context) {
        switch (this.getWebService().getSameSite().getOrdinal()) {
            case 2: {
                context.setAttribute("org.eclipse.jetty.cookie.sameSiteDefault", (Object)HttpCookie.SameSite.STRICT);
                break;
            }
            case 0: {
                context.setAttribute("org.eclipse.jetty.cookie.sameSiteDefault", (Object)HttpCookie.SameSite.NONE);
                break;
            }
            default: {
                context.setAttribute("org.eclipse.jetty.cookie.sameSiteDefault", (Object)HttpCookie.SameSite.LAX);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnregister(BINiagaraWebServlet servlet) {
        Handler handler;
        Map<String, BINiagaraWebServlet> map = this.byServletName;
        synchronized (map) {
            this.byServletName.values().removeIf(ws -> ws == servlet);
        }
        if (this.contextHandlers != null && (handler = this.byHandler.get(servlet)) != null) {
            this.byHandler.remove(servlet);
            AccessController.doPrivileged(() -> {
                this.contextHandlers.removeHandler(handler);
                return null;
            });
        }
    }

    private static SessionHandler newSessionHandler(ContextSessionData contextSessionData) {
        NiagaraSessionHandler sessionHandler = new NiagaraSessionHandler();
        sessionHandler.setSecureRequestOnly(true);
        sessionHandler.setHttpOnly(true);
        NiagaraSessionCache sessionCache = new NiagaraSessionCache(sessionHandler);
        sessionCache.setSessionDataStore((SessionDataStore)new NiagaraSessionDataStore(contextSessionData));
        sessionHandler.setSessionCache((SessionCache)sessionCache);
        SessionCookieConfig sessionCookieConfig = sessionHandler.getSessionCookieConfig();
        sessionCookieConfig.setPath("/");
        return sessionHandler;
    }

    public void spy(SpyWriter out) throws Exception {
        out.w((Object)"<div>").a("spy:/stationJetty", (Object)"Station Jetty Spy").w((Object)"</div>");
        super.spy(out);
    }

    private void addJettySpy() {
        if (Spy.ROOT.find(jettySpyName) == null) {
            Spy.ROOT.add(jettySpyName, (Spy)new JettySpy());
        }
    }

    private static void removeJettySpy() {
        Spy.ROOT.remove(jettySpyName);
    }

    private void initializeJettyStatistics() {
        this.jetty.addBeanToAllConnectors((Object)new ConnectionStatistics());
    }

    private void addAllJettyStatisticsSpy() {
        JettySpy jettySpy = (JettySpy)Spy.ROOT.find(jettySpyName);
        if (jettySpy == null) {
            return;
        }
        for (Connector connector : this.jetty.getConnectors()) {
            ConnectionStatistics stats = (ConnectionStatistics)connector.getBean(ConnectionStatistics.class);
            String connectorName = connector.getName();
            if (connectorName == null || connectorName.isEmpty()) {
                connectorName = connector.toString();
            }
            if (stats != null) {
                jettySpy.add(connectorName, new JettyStatisticsSpy(stats));
                continue;
            }
            log.warning("Could not find stats for connector " + connectorName);
        }
    }

    private void removeAllJettyStatisticsSpy() {
        JettySpy jettySpy = (JettySpy)Spy.ROOT.find(jettySpyName);
        if (jettySpy == null) {
            return;
        }
        for (String name : jettySpy.list()) {
            Spy spy = jettySpy.find(name);
            if (!(spy instanceof JettyStatisticsSpy)) continue;
            jettySpy.remove(name);
        }
    }

    private void addAllJettyStructsSpy() {
        JettySpy jettySpy = (JettySpy)Spy.ROOT.find(jettySpyName);
        if (jettySpy == null) {
            return;
        }
        jettySpy.add("denialOfServiceSettings", new JettyStructPropertySpy("Denial of Service Settings", this.getDenialOfServiceSettings()));
        jettySpy.add("qualityOfServiceSettings", new JettyStructPropertySpy("Quality Of Service Settings", this.getQualityOfServiceSettings()));
        jettySpy.add("connectionLimitSettings", new JettyStructPropertySpy("Connection Limit", this.getConnectionLimit()));
        jettySpy.add("acceptRateLimitSettings", new JettyStructPropertySpy("Accept Rate Limit", this.getAcceptRateLimit()));
        jettySpy.add("inetAccessHandler", new JettyStructPropertySpy("Inet Access Handler", this.getInetAccessHandler()));
        jettySpy.add("sizeLimitHandler", new JettyStructPropertySpy("Size Limit Handler", this.getSizeLimitHandler()));
    }

    private void removeAllJettyStructsSpy() {
        JettySpy jettySpy = (JettySpy)Spy.ROOT.find(jettySpyName);
        if (jettySpy == null) {
            return;
        }
        for (String name : jettySpy.list()) {
            Spy spy = jettySpy.find(name);
            if (!(spy instanceof JettyStructPropertySpy)) continue;
            jettySpy.remove(name);
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == cacheSessionsAndRestart) {
            this.post((Runnable)new Invocation((BComponent)this, action, argument, cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doCacheSessionsAndRestart(Context cx) throws Exception {
        Object object = restartLock;
        synchronized (object) {
            this.doRestart((Context)new BasicContext(Context.NULL, BFacets.make((String)"retainSessions", (BIDataValue)BBoolean.TRUE)));
        }
    }

    protected final void enginePanic(boolean panic) {
        try {
            if (this.getWebService().getEnabled() && this.getWebService().getWebServer() != null && BWebServer.ServerState.started.name().equals(this.getWebService().getWebServer().getServerState()) && this.getWebService().getHttpsEnabled() && this.httpsConnector != null) {
                if (panic) {
                    ignoreHttpsSelectFailure = true;
                    if (this.httpsConnector.isRunning() && this.minimumThreads < this.threadPool.getBusyThreads()) {
                        for (EndPoint endPoint : this.httpsConnector.getConnectedEndPoints()) {
                            try {
                                IO.close((Closeable)endPoint);
                            }
                            catch (Throwable throwable) {}
                        }
                        this.httpsConnector.stop();
                    }
                } else {
                    if (this.httpsConnector.isStopped()) {
                        this.httpsConnector.start();
                    }
                    ignoreHttpsSelectFailure = false;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to " + (panic ? "enter" : "exit") + " panic state", e);
        }
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (1003 == x) {
            this.enginePanic((Boolean)a);
        }
        return super.fw(x, a, b, c, d);
    }

    private /* synthetic */ Void lambda$doStartWebServer$11(Handler _coreHandler) {
        this.jetty.setHandler(_coreHandler);
        return null;
    }

    private /* synthetic */ Void lambda$doStartWebServer$1(SessionIdManager sessionIdManager) {
        this.jetty.setSessionIdManager(sessionIdManager);
        return null;
    }

    static {
        EMPTY_SERVLET_ARRAY = new BINiagaraWebServlet[0];
        diagnosticLog = java.util.logging.Logger.getLogger("diagnostics.web.speedTest");
        validateCertificate = AccessController.doPrivileged(() -> Boolean.getBoolean("web.validateCertificate"));
        idleTimeout = AccessController.doPrivileged(() -> Integer.getInteger("web.idleTimeout", 300000));
        HSTS_MAX_AGE = AccessController.doPrivileged(() -> Long.getLong("hstsMaxAge", 63072000L));
        restartLock = new Object();
        QNX_ACCEPTOR_THREAD_GC_TIMER = null;
    }

    private static class GCTimerTask
    extends TimerTask {
        private GCTimerTask() {
        }

        @Override
        public void run() {
            if (log != null && log.isLoggable(Level.FINE)) {
                log.fine("Requesting GC for acceptor thread usage");
            }
            System.gc();
        }
    }

    private class RestartSelectorTask
    implements Consumer<NiagaraManagedSelector> {
        private RestartSelectorTask() {
        }

        @Override
        public void accept(NiagaraManagedSelector customManagedSelector) {
            try {
                customManagedSelector.stop();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("RestartSelectorTask stopped selector for connector port " + customManagedSelector.port);
                }
                customManagedSelector.start();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("RestartSelectorTask started selector for connector port " + customManagedSelector.port);
                }
                BJettyWebServer.this.selectorRestartCount++;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "RestartSelectorTask failed to restart the webserver selector on port " + customManagedSelector.port + ", restarting webserver", e);
                BJettyWebServer.this.getWebService().getWebServer().restart();
            }
        }
    }

    private static class NiagaraManagedSelector
    extends ManagedSelector {
        private final Set<EndPoint> endpoints = ConcurrentHashMap.newKeySet();
        private final Consumer<NiagaraManagedSelector> onSelectFailConsumer;
        int port;
        boolean secure;

        public NiagaraManagedSelector(SelectorManager selectorManager, int id, int port, boolean secure, Consumer<NiagaraManagedSelector> onSelectFailConsumer) {
            super(selectorManager, id);
            this.onSelectFailConsumer = onSelectFailConsumer;
            this.port = port;
            this.secure = secure;
        }

        protected void endPointOpened(EndPoint endPoint) {
            super.endPointOpened(endPoint);
            this.endpoints.add(endPoint);
        }

        protected void endPointClosed(EndPoint endPoint) {
            super.endPointClosed(endPoint);
            this.endpoints.remove(endPoint);
        }

        protected void onSelectFailed(Throwable cause) {
            if (ignoreHttpsSelectFailure && this.secure) {
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Selector thread '" + Thread.currentThread().getName() + "' select() failure (" + cause + "), restarting selector");
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINE, "Stack trace:", cause);
                }
            }
            this.endpoints.forEach(endpoint -> {
                if (endpoint.getConnection() != null) {
                    try {
                        IO.close((Closeable)endpoint.getConnection());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    IO.close((Closeable)endpoint);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            this.endpoints.clear();
            new Thread(() -> this.onSelectFailConsumer.accept(this), "OnSelectFailedTask").start();
        }
    }

    private class NiagaraCustomConnector
    extends ServerConnector {
        private final Consumer<NiagaraManagedSelector> onSelectFailConsumer;
        int port;
        boolean secure;

        public NiagaraCustomConnector(Server server, int acceptors, int selectors, int port, boolean secure, ConnectionFactory ... factories) {
            super(server, acceptors, selectors, factories);
            this.onSelectFailConsumer = new RestartSelectorTask();
            this.port = port;
            this.secure = secure;
        }

        protected SelectorManager newSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
            return new ServerConnector.ServerConnectorManager(executor, scheduler, selectors){

                protected ManagedSelector newSelector(int id) {
                    return new NiagaraManagedSelector((SelectorManager)this, id, NiagaraCustomConnector.this.port, NiagaraCustomConnector.this.secure, NiagaraCustomConnector.this.onSelectFailConsumer);
                }
            };
        }
    }

    private class NiagaraConnectionLimit
    extends ConnectionLimit {
        public NiagaraConnectionLimit(@Name(value="server") int maxConnections, Server server) {
            super(maxConnections, server);
        }

        public void onOpened(Connection connection) {
            super.onOpened(connection);
            BJettyConnectionLimit limit = BJettyWebServer.this.getConnectionLimit();
            if (limit.getTrackConnections()) {
                int connections = this.getConnections();
                limit.setInt(BJettyConnectionLimit.currentConnections, connections, DIAGNOSTIC_CONTEXT);
                if (connections > limit.getPeakConnections()) {
                    limit.setInt(BJettyConnectionLimit.peakConnections, connections, DIAGNOSTIC_CONTEXT);
                }
            }
        }

        public void onClosed(Connection connection) {
            super.onClosed(connection);
            BJettyConnectionLimit limit = BJettyWebServer.this.getConnectionLimit();
            if (limit.getTrackConnections()) {
                limit.setInt(BJettyConnectionLimit.currentConnections, this.getConnections(), DIAGNOSTIC_CONTEXT);
            }
        }

        protected void limit() {
            super.limit();
            log.warning("Webserver maximum connection limit " + this.getMaxConnections() + " reached, limiting new connections");
        }

        protected void unlimit() {
            super.unlimit();
            log.info("Webserver maximum connection limit cleared");
        }
    }

    private final class JettyStructPropertySpy
    extends Spy {
        String name = null;
        BStruct structToSpy = null;

        JettyStructPropertySpy(String name, BStruct toSpy) {
            this.structToSpy = toSpy;
            this.name = name;
        }

        public void write(SpyWriter out) throws Exception {
            AcceptRateLimit acceptRateLimit;
            out.startProps();
            out.trTitle((Object)this.name, 2);
            SlotCursor c = this.structToSpy.getProperties();
            while (c.next()) {
                out.prop((Object)c.slot(), (Object)c.get());
            }
            if (this.structToSpy instanceof BJettyAcceptRateLimit && (acceptRateLimit = (AcceptRateLimit)BJettyWebServer.this.jetty.getBean(AcceptRateLimit.class)) != null) {
                out.prop((Object)"currentRate", acceptRateLimit.getRate());
            }
            out.endProps();
        }
    }

    private static final class JettyStatisticsSpy
    extends Spy {
        private final ConnectionStatistics stats;

        private JettyStatisticsSpy(ConnectionStatistics stats) {
            this.stats = stats;
        }

        public void write(SpyWriter out) throws Exception {
            out.startProps();
            out.trTitle((Object)"Connector stats", 2);
            out.prop((Object)"state", (Object)this.stats.getState());
            out.prop((Object)"received bytes", (double)this.stats.getReceivedBytes());
            out.prop((Object)"received bytes rate", (double)this.stats.getReceivedBytesRate());
            out.prop((Object)"sent bytes", (double)this.stats.getSentBytes());
            out.prop((Object)"sent bytes rate", (double)this.stats.getSentBytesRate());
            out.prop((Object)"max duration (ms)", (double)this.stats.getConnectionDurationMax());
            out.prop((Object)"mean duration (ms)", this.stats.getConnectionDurationMean());
            out.prop((Object)"stddev duration (ms)", this.stats.getConnectionDurationStdDev());
            out.prop((Object)"total connections", (double)this.stats.getConnectionsTotal());
            out.prop((Object)"current connections", (double)this.stats.getConnections());
            out.prop((Object)"max connections", (double)this.stats.getConnectionsMax());
            out.prop((Object)"received messages", (double)this.stats.getReceivedMessages());
            out.prop((Object)"received messages rate", (double)this.stats.getReceivedMessagesRate());
            out.prop((Object)"sent messages", (double)this.stats.getSentMessages());
            out.prop((Object)"sent messages rate", (double)this.stats.getSentMessagesRate());
            out.endProps();
        }
    }

    private static final class SpeedTestSpy
    extends Spy {
        private SpeedTestSpy() {
        }

        public void write(SpyWriter out) throws Exception {
            out.startProps();
            out.trTitle((Object)"Speed Test", 2);
            out.unsafe().prop((Object)"Estimated Latency", (Object)"<span id='latency' style='min-width: 100px; display: block'></span>");
            out.unsafe().prop((Object)"Download Speed", (Object)"<span id='download'></span>");
            out.unsafe().prop((Object)"Upload Speed", (Object)"<span id='upload'></span>");
            out.endProps();
            INiagaraSuperSession superSession = SessionUtil.getCurrentNiagaraSuperSession();
            if (superSession != null) {
                out.w((Object)"<input type='hidden' id='csrfToken' value='").w((Object)superSession.getCsrfToken()).w((Object)"'/>");
            }
            if (diagnosticLog.isLoggable(Level.FINE)) {
                out.w((Object)"<script type='text/javascript'>window.speedTestResults=true;</script>");
            }
            out.w((Object)"<script type='text/javascript' src='module://web/rc/util/speedTest.js'></script>");
        }
    }

    private final class JettySpy
    extends SpyDir {
        public JettySpy() {
            this.add("speedTest", new SpeedTestSpy());
        }

        public void write(SpyWriter out) throws Exception {
            PrivilegedQueuedThreadPool pool;
            boolean isRunning;
            out.startProps();
            BJettyWebServer webServer = (BJettyWebServer)Sys.getService((Type)TYPE);
            out.w((Object)"<div>").a("spy:/nav/localhost/station" + webServer.toPathString(), (Object)"Jetty Web Server Component").w((Object)"</div>");
            super.write(out);
            out.trTitle((Object)"Jetty", 2);
            out.prop((Object)"Version", (Object)Server.getVersion());
            out.prop((Object)"Validate certificate", validateCertificate);
            out.prop((Object)"Connection idle timeout", idleTimeout);
            Server server = BJettyWebServer.this.jetty;
            boolean bl = isRunning = server != null && server.isRunning();
            if (isRunning && (pool = BJettyWebServer.this.threadPool) != null) {
                pool.setDetailedDump(true);
                out.w((Object)"<tr class='spy-prop'><td class='spy-prop-name'>").w((Object)"threadPool").w((Object)"</td><td class='spy-prop-value'>").w((Object)"<pre>").safe((Object)AccessController.doPrivileged(() -> ((QueuedThreadPool)pool).dump())).w((Object)"</pre>").w((Object)"</td></tr>\n");
                pool.setDetailedDump(false);
            }
            out.endProps();
            if (!isRunning) {
                out.write("Jetty is not running");
            }
        }
    }

    private static final class CompositeClassLoader
    extends ClassLoader {
        private final ClassLoader clsLoader;

        private CompositeClassLoader(ClassLoader clsLoader) {
            super(CompositeClassLoader.class.getClassLoader());
            this.clsLoader = clsLoader;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return this.clsLoader.loadClass(name);
        }

        @Override
        protected URL findResource(String name) {
            return this.clsLoader.getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.clsLoader.getResources(name);
        }
    }

    private class ThreadCountPropertyValidator
    implements IPropertyValidator {
        private ThreadCountPropertyValidator() {
        }

        public void validateSet(Validatable validatable, Context context) {
            int newMaxThreads;
            int currentMinThreads = ((BNumber)validatable.getExistingValue(minThreads)).getInt();
            int currentMaxThreads = ((BNumber)validatable.getExistingValue(maxThreads)).getInt();
            int newMinThreads = Optional.ofNullable(validatable.getProposedValue(minThreads)).map(value -> ((BNumber)value).getInt()).orElse(currentMinThreads);
            if (newMinThreads > (newMaxThreads = Optional.ofNullable(validatable.getProposedValue(maxThreads)).map(value -> ((BNumber)value).getInt()).orElse(currentMaxThreads).intValue())) {
                throw new LocalizableRuntimeException("jetty", "jetty.minThreadsMustBeSmaller", new Object[]{newMinThreads, newMaxThreads});
            }
            int minNeededThreads = BJettyWebServer.this.calcMinNeededThreads(context);
            if (newMaxThreads < minNeededThreads) {
                throw new LocalizableRuntimeException("jetty", "jetty.notEnoughThreads", new Object[]{minNeededThreads, newMaxThreads});
            }
        }
    }

    private class ConnectorThreadPropertyValidator
    implements IPropertyValidator {
        private ConnectorThreadPropertyValidator() {
        }

        public void validateSet(Validatable validatable, Context context) {
            int currentAcceptors = ((BNumber)validatable.getExistingValue("acceptorThreads")).getInt();
            int currentSelectors = ((BNumber)validatable.getExistingValue("selectorThreads")).getInt();
            int newAcceptors = Optional.ofNullable(validatable.getProposedValue("acceptorThreads")).map(value -> ((BNumber)value).getInt()).orElse(currentAcceptors);
            int newSelectors = Optional.ofNullable(validatable.getProposedValue("selectorThreads")).map(value -> ((BNumber)value).getInt()).orElse(currentSelectors);
            int cores = FoxRpcUtil.doSilentRpc((BISpaceNode)BJettyWebServer.this, (String)"getCores", (Object[])new Object[0]).orElseGet(() -> BJettyWebServer.this.getCores(null));
            int neededThreads = JettyThreadUtil.calcThreads((int)newAcceptors, (int)newSelectors, (int)cores);
            int currentThreads = JettyThreadUtil.calcThreads((int)currentAcceptors, (int)currentSelectors, (int)cores);
            int minThreads = BJettyWebServer.this.calcMinNeededThreads(context);
            int newMinThreads = minThreads - currentThreads + neededThreads;
            if (newMinThreads > BJettyWebServer.this.getMaxThreads()) {
                throw new LocalizableRuntimeException("jetty", "jetty.notEnoughThreads", new Object[]{newMinThreads, BJettyWebServer.this.getMaxThreads()});
            }
        }
    }

    private static final class DiagnosticBenchmarkFilter
    implements Filter {
        private final String name;

        private DiagnosticBenchmarkFilter(String name) {
            this.name = name;
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            long start = DiagnosticUtil.startIfLoggable((String)"jetty.doFilter");
            try {
                filterChain.doFilter(servletRequest, servletResponse);
            }
            finally {
                DiagnosticUtil.complete((long)start, (String)"jetty.doFilter", (Object)this.name);
            }
        }

        public void destroy() {
        }
    }

    private static class DiagnosticBenchmarkHandler
    extends HandlerWrapper {
        private DiagnosticBenchmarkHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            long start = DiagnosticUtil.nanoTime();
            try {
                super.handle(target, baseRequest, request, response);
            }
            finally {
                DiagnosticUtil.complete((long)start, (String)"handle", (Object)baseRequest.getRequestURI());
            }
        }
    }
}

