/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;

public abstract class HtmlTokenizer {
    private static final int TEXT = 0;
    private static final int COMMENT = 1;
    private static final int END_TAG = 2;
    private static final int START_TAG = 3;
    private static final int NAME = 0;
    private static final int BEFORE_EQUALS = 1;
    private static final int EQUALS = 2;
    private static final int AFTER_EQUALS = 3;
    private static final int QUOTED_VALUE = 4;
    private static final int UNQUOTED_VALUE = 5;
    private static final String DOCTYPE = "!DOCTYPE";
    private Array<StringBuffer> text = null;
    private String source = null;
    private int offset;
    private static Map<String, String> validTags = new HashMap<String, String>();
    static Literal[] literals;
    static final String literalPattern;
    static final Pattern pattern;
    static final Map<String, String> literalMap;

    public abstract void handleText(String var1);

    public abstract void handleComment(String var1);

    public abstract void handleStartTag(int var1, String var2, Map<String, String> var3);

    public abstract void handleEndTag(int var1, String var2);

    public final void parse(InputStream stream) throws IOException {
        this.parse(stream, true);
    }

    public final void parse(InputStream stream, boolean closeStream) throws IOException {
        this.parse(new InputStreamReader(stream), closeStream);
    }

    public final void parse(Reader reader, boolean closeStream) throws IOException {
        String str;
        BufferedReader in;
        this.text = new Array(StringBuffer.class);
        this.source = null;
        BufferedReader bufferedReader = in = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        while ((str = in.readLine()) != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(str).append("\n");
            this.text.add((Object)sb);
        }
        if (closeStream) {
            in.close();
        }
        this.parseFromList();
    }

    public final void parse(String htmlStr) {
        this.text = new Array(StringBuffer.class);
        this.source = null;
        String[] tokens = TextUtil.split((String)htmlStr, (char)'\n');
        for (int i = 0; i < tokens.length; ++i) {
            String s = tokens[i];
            StringBuffer sb = new StringBuffer(s.length() + 1);
            sb.append(s).append("\n");
            this.text.add((Object)sb);
        }
        this.parseFromList();
    }

    public final String getSource() {
        if (this.source == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.text.size(); ++i) {
                sb.append(((StringBuffer)this.text.get(i)).toString());
            }
            this.source = sb.toString();
        }
        return this.source;
    }

    private void parseFromList() {
        int state = 0;
        int markRow = 0;
        int markCol = 0;
        this.offset = 0;
        for (int row = 0; row < this.text.size(); ++row) {
            StringBuffer sb = (StringBuffer)this.text.get(row);
            for (int col = 0; col < sb.length(); ++col) {
                switch (state) {
                    case 0: {
                        if (sb.charAt(col + 0) == '<' && sb.charAt(col + 1) == '!' && sb.charAt(col + 2) == '-' && sb.charAt(col + 3) == '-') {
                            if (HtmlTokenizer.validElement(row, col, markRow, markCol)) {
                                this.handleText(this.getElement(row, col, markRow, markCol));
                            }
                            markCol = col;
                            markRow = row;
                            state = 1;
                            break;
                        }
                        if (sb.charAt(col + 0) == '<' && sb.charAt(col + 1) == '/') {
                            if (HtmlTokenizer.validElement(row, col, markRow, markCol)) {
                                this.handleText(this.getElement(row, col, markRow, markCol));
                            }
                            markCol = col;
                            markRow = row;
                            state = 2;
                            break;
                        }
                        if (sb.charAt(col + 0) != '<') break;
                        if (HtmlTokenizer.validElement(row, col, markRow, markCol)) {
                            this.handleText(this.getElement(row, col, markRow, markCol));
                        }
                        markCol = col;
                        markRow = row;
                        state = 3;
                        break;
                    }
                    case 1: {
                        if (sb.charAt(col + 0) != '-' || sb.charAt(col + 1) != '-' || sb.charAt(col + 2) != '>') break;
                        if (HtmlTokenizer.validElement(row, col, markRow, markCol)) {
                            this.handleComment(this.getElement(row, col, markRow, markCol + 4));
                        }
                        markCol = col + 3;
                        markRow = row;
                        state = 0;
                        break;
                    }
                    case 2: {
                        String elm;
                        String tagName;
                        if (sb.charAt(col + 0) != '>') break;
                        if (HtmlTokenizer.validElement(row, col, markRow, markCol) && validTags.containsKey(tagName = HtmlTokenizer.getTagName(elm = this.getElement(row, col, markRow, markCol + 2)))) {
                            this.handleEndTag(row, elm.toUpperCase());
                        }
                        markCol = col + 1;
                        markRow = row;
                        state = 0;
                        break;
                    }
                    case 3: {
                        String elm;
                        String tagName;
                        if (sb.charAt(col + 0) != '>') break;
                        if (HtmlTokenizer.validElement(row, col, markRow, markCol) && ((elm = this.getElement(row, col, markRow, markCol + 1)).length() < DOCTYPE.length() || !elm.substring(0, DOCTYPE.length()).equals(DOCTYPE)) && validTags.containsKey(tagName = HtmlTokenizer.getTagName(elm))) {
                            this.handleStartTag(row, HtmlTokenizer.getTagName(elm), HtmlTokenizer.getAttributes(elm));
                        }
                        markCol = col + 1;
                        markRow = row;
                        state = 0;
                    }
                }
                ++this.offset;
            }
            if (state != 0) continue;
            if (HtmlTokenizer.validElement(row, sb.length(), markRow, markCol)) {
                this.handleText(this.getElement(row, sb.length(), markRow, markCol));
            }
            markCol = 0;
            markRow = row + 1;
        }
    }

    private static boolean validElement(int row, int col, int markRow, int markCol) {
        if (markRow < row) {
            return true;
        }
        return markRow == row && markCol < col;
    }

    private String getElement(int row, int col, int markRow, int markCol) {
        StringBuilder sb = new StringBuilder("");
        if (markRow == row) {
            String str = ((StringBuffer)this.text.get(row)).substring(markCol, col);
            sb.append(str);
        } else {
            Array lines = new Array(String.class);
            String str = ((StringBuffer)this.text.get(markRow)).substring(markCol);
            if (str.length() > 0) {
                lines.add((Object)str);
            }
            for (int r = markRow + 1; r < row; ++r) {
                str = ((StringBuffer)this.text.get(r)).toString();
                if (str.length() <= 0) continue;
                lines.add((Object)str);
            }
            str = ((StringBuffer)this.text.get(row)).substring(0, col);
            if (str.length() > 0) {
                lines.add((Object)str);
            }
            if (lines.size() > 0) {
                for (int i = 0; i < lines.size(); ++i) {
                    sb.append((String)lines.get(i));
                }
            }
        }
        return sb.toString();
    }

    private static String getTagName(String elm) {
        int n = elm.indexOf(32);
        if (n == -1) {
            return elm.toUpperCase();
        }
        return elm.substring(0, n).toUpperCase();
    }

    private static Map<String, String> getAttributes(String elm) {
        HashMap<String, String> attribs = new HashMap<String, String>();
        int n = elm.indexOf(32);
        if (n != -1) {
            int mark = ++n;
            int state = 0;
            char quoteChar = '\"';
            String name = "";
            String value = "";
            while (n < elm.length()) {
                switch (state) {
                    case 0: {
                        if (elm.charAt(n) == '=') {
                            name = elm.substring(mark, n).trim().toUpperCase();
                            state = 2;
                            break;
                        }
                        if (elm.charAt(n) != ' ') break;
                        name = elm.substring(mark, n).trim().toUpperCase();
                        attribs.put(name, null);
                        mark = n + 1;
                        break;
                    }
                    case 2: {
                        if (elm.charAt(n) == '\"' || elm.charAt(n) == '\'') {
                            quoteChar = elm.charAt(n);
                            mark = n + 1;
                            state = 4;
                            break;
                        }
                        if (elm.charAt(n) == ' ') break;
                        mark = n;
                        state = 5;
                        break;
                    }
                    case 4: {
                        if (elm.charAt(n) != quoteChar) break;
                        value = elm.substring(mark, n);
                        attribs.put(name, value);
                        mark = n + 1;
                        state = 0;
                        break;
                    }
                    case 5: {
                        if (elm.charAt(n) != ' ') break;
                        value = elm.substring(mark, n);
                        attribs.put(name, value);
                        mark = n + 1;
                        state = 0;
                    }
                }
                ++n;
            }
            if (state == 5) {
                value = elm.substring(mark, n);
                attribs.put(name, value);
            } else if (state == 0) {
                name = elm.substring(mark, n).trim().toUpperCase();
                attribs.put(name, null);
            }
        }
        return attribs;
    }

    protected int getOffset() {
        return this.offset;
    }

    public static void main(String ... args) {
        System.out.println(HtmlTokenizer.replaceLiterals("&quot;this is a quotation&quot; 1 &lt;= 2"));
    }

    public static String replaceLiterals(String input) {
        Matcher matcher = pattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, literalMap.get(matcher.group()));
        }
        return matcher.appendTail(sb).toString();
    }

    static {
        validTags.put("A", null);
        validTags.put("B", null);
        validTags.put("BODY", null);
        validTags.put("BR", null);
        validTags.put("CODE", null);
        validTags.put("DD", null);
        validTags.put("DL", null);
        validTags.put("DT", null);
        validTags.put("EM", null);
        validTags.put("FONT", null);
        validTags.put("H1", null);
        validTags.put("H2", null);
        validTags.put("H3", null);
        validTags.put("H4", null);
        validTags.put("H5", null);
        validTags.put("HEAD", null);
        validTags.put("HR", null);
        validTags.put("HTML", null);
        validTags.put("I", null);
        validTags.put("IMG", null);
        validTags.put("LI", null);
        validTags.put("LINK", null);
        validTags.put("OL", null);
        validTags.put("P", null);
        validTags.put("PRE", null);
        validTags.put("STRONG", null);
        validTags.put("TABLE", null);
        validTags.put("TD", null);
        validTags.put("TH", null);
        validTags.put("TITLE", null);
        validTags.put("TR", null);
        validTags.put("TT", null);
        validTags.put("UL", null);
        literals = new Literal[]{new Literal("&quot;", "\""), new Literal("&#34;", "\""), new Literal("&amp;", "&"), new Literal("&#38;", "&"), new Literal("&lt;", "<"), new Literal("&#60;", "<"), new Literal("&gt;", ">"), new Literal("&#62;", ">"), new Literal("&ndash;", "-"), new Literal("&#8211;", "-"), new Literal("&mdash;", "--"), new Literal("&#8212;", "--"), new Literal("&lsquo;", "'"), new Literal("&#8216;", "'"), new Literal("&rsquo;", "'"), new Literal("&#8217;", "'"), new Literal("&ldquo;", "\""), new Literal("&#8220;", "\""), new Literal("&rdquo;", "\""), new Literal("&#8221;", "\""), new Literal("&prime;", "'"), new Literal("&#8242;", "'"), new Literal("&Prime;", "\""), new Literal("&#8243;", "\""), new Literal("&trade;", "\u0099"), new Literal("&#8482;", "\u0099"), new Literal("&#x2013;", "-"), new Literal("&#x2014;", "--"), new Literal("&#x2018;", "'"), new Literal("&#x2019;", "'"), new Literal("&#x201c;", "\""), new Literal("&#x201d;", "\""), new Literal("&#x2032;", "'"), new Literal("&#x2033;", "\""), new Literal("&#x2122;", "\u0099"), new Literal("&#9474;", "\u00a6"), new Literal("&bull;", "\u2022"), new Literal("&#8226;", "\u2022"), new Literal("&dagger;", "\u2020"), new Literal("&#8224;", "\u2020"), new Literal("&Dagger;", "\u2021"), new Literal("&#8225;", "\u2021"), new Literal("&lsaquo;", "\u2039"), new Literal("&#8249;", "\u2039"), new Literal("&rsaquo;", "\u203a"), new Literal("&#8250;", "\u203a"), new Literal("&euro;", "\u20ac"), new Literal("&#8364;", "\u20ac"), new Literal("&tilde;", "\u02dc"), new Literal("&#732;", "\u02dc"), new Literal("&circ;", "\u02c6"), new Literal("&#710;", "\u02c6"), new Literal("&#x2022;", "\u2022"), new Literal("&#x2020;", "\u2020"), new Literal("&#x2021;", "\u2021"), new Literal("&#x2039;", "\u2039"), new Literal("&#x203a;", "\u203a"), new Literal("&#x20ac;", "\u20ac"), new Literal("&#x2dc;", "\u02dc"), new Literal("&#x2c6;", "\u02c6"), new Literal("&#124;", "|"), new Literal("&ring;", "\u02da"), new Literal("&#730;", "\u02da"), new Literal("&nbsp;", " "), new Literal("&#160;", " "), new Literal("&iexcl;", "\u00a1"), new Literal("&#161;", "\u00a1"), new Literal("&cent;", "\u00a2"), new Literal("&#162;", "\u00a2"), new Literal("&pound;", "\u00a3"), new Literal("&#163;", "\u00a3"), new Literal("&curren;", "\u00a4"), new Literal("&#164;", "\u00a4"), new Literal("&yen;", "\u00a5"), new Literal("&#165;", "\u00a5"), new Literal("&brvbar;", "\u00a6"), new Literal("&#166;", "\u00a6"), new Literal("&sect;", "\u00a7"), new Literal("&#167;", "\u00a7"), new Literal("&uml;", "\u00a8"), new Literal("&#168;", "\u00a8"), new Literal("&copy;", "\u00a9"), new Literal("&#169;", "\u00a9"), new Literal("&ordf;", "\u00aa"), new Literal("&#170;", "\u00aa"), new Literal("&laquo;", "\u00ab"), new Literal("&#171;", "\u00ab"), new Literal("&not;", "\u00ac"), new Literal("&#172;", "\u00ac"), new Literal("&shy;", "\u00ad"), new Literal("&#173;", "\u00ad"), new Literal("&reg;", "\u00ae"), new Literal("&#174;", "\u00ae"), new Literal("&macr;", "\u00af"), new Literal("&#175;", "\u00af"), new Literal("&deg;", "\u00b0"), new Literal("&#176;", "\u00b0"), new Literal("&plusmn;", "\u00b1"), new Literal("&#177;", "\u00b1"), new Literal("&sup2;", "\u00b2"), new Literal("&#178;", "\u00b2"), new Literal("&sup3;", "\u00b3"), new Literal("&#179;", "\u00b3"), new Literal("&acute;", "\u00b4"), new Literal("&#180;", "\u00b4"), new Literal("&micro;", "\u00b5"), new Literal("&#181;", "\u00b5"), new Literal("&para;", "\u00b6"), new Literal("&#182;", "\u00b6"), new Literal("&middot;", "\u00b7"), new Literal("&#183;", "\u00b7"), new Literal("&cedil;", "\u00b8"), new Literal("&#184;", "\u00b8"), new Literal("&sup1;", "\u00b9"), new Literal("&#185;", "\u00b9"), new Literal("&ordm;", "\u00ba"), new Literal("&#186;", "\u00ba"), new Literal("&raquo;", "\u00bb"), new Literal("&#187;", "\u00bb"), new Literal("&frac14;", "\u00bc"), new Literal("&#188;", "\u00bc"), new Literal("&frac12;", "\u00bd"), new Literal("&#189;", "\u00bd"), new Literal("&frac34;", "\u00be"), new Literal("&#190;", "\u00be"), new Literal("&iquest;", "\u00bf"), new Literal("&#191;", "\u00bf"), new Literal("&Agrave;", "\u00c0"), new Literal("&#192;", "\u00c0"), new Literal("&Aacute;", "\u00c1"), new Literal("&#193;", "\u00c1"), new Literal("&Acirc;", "\u00c2"), new Literal("&#194;", "\u00c2"), new Literal("&Atilde;", "\u00c3"), new Literal("&#195;", "\u00c3"), new Literal("&Auml;", "\u00c4"), new Literal("&#196;", "\u00c4"), new Literal("&Aring;", "\u00c5"), new Literal("&#197;", "\u00c5"), new Literal("&AElig;", "\u00c6"), new Literal("&#198;", "\u00c6"), new Literal("&Ccedil;", "\u00c7"), new Literal("&#199;", "\u00c7"), new Literal("&Egrave;", "\u00c8"), new Literal("&#200;", "\u00c8"), new Literal("&Eacute;", "\u00c9"), new Literal("&#201;", "\u00c9"), new Literal("&Ecirc;", "\u00ca"), new Literal("&#202;", "\u00ca"), new Literal("&Euml;", "\u00cb"), new Literal("&#203;", "\u00cb"), new Literal("&Igrave;", "\u00cc"), new Literal("&#204;", "\u00cc"), new Literal("&Iacute;", "\u00cd"), new Literal("&#205;", "\u00cd"), new Literal("&Icirc;", "\u00ce"), new Literal("&#206;", "\u00ce"), new Literal("&Iuml;", "\u00cf"), new Literal("&#207;", "\u00cf"), new Literal("&ETH;", "\u00d0"), new Literal("&#208;", "\u00d0"), new Literal("&Ntilde;", "\u00d1"), new Literal("&#209;", "\u00d1"), new Literal("&Ograve;", "\u00d2"), new Literal("&#210;", "\u00d2"), new Literal("&Oacute;", "\u00d3"), new Literal("&#211;", "\u00d3"), new Literal("&Ocirc;", "\u00d4"), new Literal("&#212;", "\u00d4"), new Literal("&Otilde;", "\u00d5"), new Literal("&#213;", "\u00d5"), new Literal("&Ouml;", "\u00d6"), new Literal("&#214;", "\u00d6"), new Literal("&times;", "\u00d7"), new Literal("&#215;", "\u00d7"), new Literal("&Oslash;", "\u00d8"), new Literal("&#216;", "\u00d8"), new Literal("&Ugrave;", "\u00d9"), new Literal("&#217;", "\u00d9"), new Literal("&Uacute;", "\u00da"), new Literal("&#218;", "\u00da"), new Literal("&Ucirc;", "\u00db"), new Literal("&#219;", "\u00db"), new Literal("&Uml;", "\u00dc"), new Literal("&#220;", "\u00dc"), new Literal("&Yacute;", "\u00dd"), new Literal("&#221;", "\u00dd"), new Literal("&THORN;", "\u00de"), new Literal("&#222;", "\u00de"), new Literal("&szlig;", "\u00df"), new Literal("&#223;", "\u00df"), new Literal("&agrave;", "\u00e0"), new Literal("&#224;", "\u00e0"), new Literal("&aacute;", "\u00e1"), new Literal("&#225;", "\u00e1"), new Literal("&acirc;", "\u00e2"), new Literal("&#226;", "\u00e2"), new Literal("&atilde;", "\u00e3"), new Literal("&#227;", "\u00e3"), new Literal("&auml;", "\u00e4"), new Literal("&#228;", "\u00e4"), new Literal("&aring;", "\u00e5"), new Literal("&#229;", "\u00e5"), new Literal("&aelig;", "\u00e6"), new Literal("&#230;", "\u00e6"), new Literal("&ccedil;", "\u00e7"), new Literal("&#231;", "\u00e7"), new Literal("&egrave;", "\u00e8"), new Literal("&#232;", "\u00e8"), new Literal("&eacute;", "\u00e9"), new Literal("&#233;", "\u00e9"), new Literal("&ecirc;", "\u00ea"), new Literal("&#234;", "\u00ea"), new Literal("&euml;", "\u00eb"), new Literal("&#235;", "\u00eb"), new Literal("&igrave;", "\u00ec"), new Literal("&#236;", "\u00ec"), new Literal("&iacute;", "\u00ed"), new Literal("&#237;", "\u00ed"), new Literal("&icirc;", "\u00ee"), new Literal("&#238;", "\u00ee"), new Literal("&iuml;", "\u00ef"), new Literal("&#239;", "\u00ef"), new Literal("&eth;", "\u00f0"), new Literal("&#240;", "\u00f0"), new Literal("&ntilde;", "\u00f1"), new Literal("&#241;", "\u00f1"), new Literal("&ograve;", "\u00f2"), new Literal("&#242;", "\u00f2"), new Literal("&oacute;", "\u00f3"), new Literal("&#243;", "\u00f3"), new Literal("&ocirc;", "\u00f4"), new Literal("&#244;", "\u00f4"), new Literal("&otilde;", "\u00f5"), new Literal("&#245;", "\u00f5"), new Literal("&ouml;", "\u00f6"), new Literal("&#246;", "\u00f6"), new Literal("&divide;", "\u00f7"), new Literal("&#247;", "\u00f7"), new Literal("&oslash;", "\u00f8"), new Literal("&#248;", "\u00f8"), new Literal("&ugrave;", "\u00f9"), new Literal("&#249;", "\u00f9"), new Literal("&uacute;", "\u00fa"), new Literal("&#250;", "\u00fa"), new Literal("&ucirc;", "\u00fb"), new Literal("&#251;", "\u00fb"), new Literal("&uuml;", "\u00fc"), new Literal("&#252;", "\u00fc"), new Literal("&yacute;", "\u00fd"), new Literal("&#253;", "\u00fd"), new Literal("&thorn;", "\u00fe"), new Literal("&#254;", "\u00fe"), new Literal("&yuml;", "\u00ff"), new Literal("&#255;", "\u00ff")};
        literalMap = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < literals.length; ++i) {
            Literal lit = literals[i];
            if (i > 0) {
                sb.append("|");
            }
            sb.append("(").append(lit.from).append(")");
            literalMap.put(lit.from, lit.to);
        }
        literalPattern = sb.toString();
        pattern = Pattern.compile(literalPattern);
    }

    static class Literal {
        String from;
        String to;

        Literal(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }
}

