/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.ui;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionType;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.ui.BTypeTableView;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.workbench.BWbShell;

@NiagaraType
public class BTypeTable
extends BTable {
    @Generated
    public static final Type TYPE = Sys.loadType(BTypeTable.class);
    private BTypeTableView view;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTypeTable() {
        throw new UnsupportedOperationException();
    }

    public BTypeTable(BTypeTableView view, BOrionType btype) {
        super((TableModel)new Model(btype), (TableController)new Controller());
        this.setSelection(new Selection());
        this.view = view;
    }

    public void updateCommands() {
        this.setDeleteEnabled(!this.getSelection().isEmpty());
    }

    public CommandArtifact doDelete() {
        this.view.deleteObjects();
        return null;
    }

    static class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            ((BTypeTable)this.getTable()).updateCommands();
        }
    }

    static class Controller
    extends TableController {
        Controller() {
        }

        public void cellDoubleClicked(BMouseEvent evt, int row, int col) {
            BIOrionObject o = ((Model)this.getModel()).getObject(row);
            BOrd ord = o.getNavOrd();
            if (!ord.isNull()) {
                ((BWbShell)this.getTable().getShell()).hyperlink(ord);
            }
        }
    }

    static class Model
    extends TableModel {
        private BOrionType btype;
        private Property[] cols = new Property[0];
        private BIOrionObject[] rows = new BIOrionObject[0];

        public Model(BOrionType btype) {
            this.btype = btype;
            this.load();
        }

        public BIOrionObject getObject(int row) {
            return this.rows[row];
        }

        public Object getSubject(int row) {
            return this.rows[row];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load() {
            OrionType type = this.btype.getOrionType();
            this.cols = type.getPersistentProperties();
            try (OrionSession session = this.btype.getOrionDatabase().createSession(null);){
                OrionCursor c = session.scan(type);
                Array temp = new Array(BIOrionObject.class, 64);
                while (c.next()) {
                    temp.add((Object)((BIOrionObject)c.get()));
                }
                this.rows = (BIOrionObject[])temp.trim();
            }
            this.updateTable();
        }

        public int getColumnCount() {
            return this.cols.length;
        }

        public String getColumnName(int index) {
            return this.cols[index].getName();
        }

        public int getRowCount() {
            return this.rows.length;
        }

        public Object getValueAt(int row, int col) {
            BIOrionObject obj = this.rows[row];
            return obj.get(this.cols[col]);
        }
    }
}

