/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.ui;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionType;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"orion:OrionType"}, requiredPermissions="R")})
public class BOrionTypeSummary
extends BWbView {
    @Generated
    public static final Type TYPE = Sys.loadType(BOrionTypeSummary.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context cx) {
        OrionType orionType = ((BOrionType)value).getOrionType();
        Lexicon lex = Lexicon.make((BModule)this.getType().getModule(), (Context)cx);
        BEdgePane main = new BEdgePane();
        main.setTop(this.makeSummaryPane(orionType, lex));
        main.setCenter(this.makePropertiesPane(orionType, lex));
        this.setContent((BWidget)main);
    }

    private BWidget makeSummaryPane(OrionType orionType, Lexicon lex) {
        BGridPane summaryInfo = new BGridPane(2);
        summaryInfo.setStretchColumn(1);
        summaryInfo.setColumnGap(10.0);
        summaryInfo.add("idLabel", (BValue)new BLabel(lex.getText("orion.type"), Theme.widget().getBoldText()));
        summaryInfo.add("id", (BValue)new BLabel(orionType.getOrionTypeId().toString()));
        OrionType superType = orionType.getOrionSuperType();
        if (superType != null) {
            summaryInfo.add("superLabel", (BValue)new BLabel(lex.getText("orion.superType"), Theme.widget().getBoldText()));
            summaryInfo.add("superId", (BValue)new BLabel(superType.getOrionTypeId().toString()));
        }
        BTitlePane summary = new BTitlePane(lex.getText("orion.summary"), (BWidget)new BBorderPane((BWidget)summaryInfo, BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0)));
        return summary;
    }

    private BWidget makePropertiesPane(OrionType orionType, Lexicon lex) {
        BTable propTable = new BTable((TableModel)new PropertyModel(orionType, lex));
        propTable.setController((TableController)new Controller());
        BTitlePane properties = new BTitlePane(lex.getText("orion.properties"), (BWidget)propTable);
        return properties;
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cellDoubleClicked(BMouseEvent evt, int row, int col) {
            Property p = (Property)this.getModel().getSubject(row);
            if (p.getType() == BRef.TYPE) {
                BOrionType parentType = (BOrionType)BOrionTypeSummary.this.getCurrentValue();
                BOrionDatabase db = parentType.getOrionDatabase();
                BRef def = (BRef)p.getDefaultValue();
                try (OrionSession session = db.createSession(null);){
                    OrionType refType = def.getTargetOrionType(session);
                    BOrd hyperlink = BOrd.make((String)(db.getType(refType).getOrdInSpace() + "|view:orion:OrionTypeSummary"));
                    BOrionTypeSummary.this.getWbShell().hyperlink(hyperlink);
                }
            }
        }
    }

    private class PropertyModel
    extends TableModel {
        OrionType type;
        Property[] properties;
        Lexicon lex;

        public PropertyModel(OrionType type, Lexicon lex) {
            this.type = type;
            this.lex = lex;
            this.properties = type.getProperties();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return this.lex.getText("orion.name");
                }
                case 1: {
                    return this.lex.getText("orion.type");
                }
                case 2: {
                    return this.lex.getText("orion.default");
                }
                case 3: {
                    return this.lex.getText("orion.facets");
                }
            }
            return "Error-" + col;
        }

        public int getRowCount() {
            return this.properties.length;
        }

        public Object getSubject(int row) {
            return this.properties[row];
        }

        public Object getValueAt(int row, int col) {
            Property p = this.properties[row];
            switch (col) {
                case 0: {
                    return p.getName();
                }
                case 1: {
                    return p.getType().toString();
                }
                case 2: {
                    return p.getDefaultValue().toString();
                }
                case 3: {
                    return p.getFacets();
                }
            }
            return "Error " + row + "," + col;
        }
    }
}

