/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.ui;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.priv.dt.BDynamicTableColumn;
import com.tridium.orion.priv.ui.BDynamicColumnTable;
import com.tridium.orion.priv.ui.BDynamicTableOptions;
import com.tridium.orion.priv.ui.BEqualPane;
import com.tridium.util.ObjectUtil;
import java.util.HashMap;
import javax.baja.gx.BInsets;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.BTitlePane;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"orion:DynamicTable"}, requiredPermissions="R")})
@NiagaraActions(value={@NiagaraAction(name="rowTypeChanged", flags=4), @NiagaraAction(name="fromTypeChanged", flags=4), @NiagaraAction(name="fromPropChanged", flags=4), @NiagaraAction(name="linkedPropChanged", flags=4), @NiagaraAction(name="handleSetModified", flags=4)})
public class BDynamicTableConfig
extends BWbComponentView {
    @Generated
    public static final Action rowTypeChanged = BDynamicTableConfig.newAction((int)4, null);
    @Generated
    public static final Action fromTypeChanged = BDynamicTableConfig.newAction((int)4, null);
    @Generated
    public static final Action fromPropChanged = BDynamicTableConfig.newAction((int)4, null);
    @Generated
    public static final Action linkedPropChanged = BDynamicTableConfig.newAction((int)4, null);
    @Generated
    public static final Action handleSetModified = BDynamicTableConfig.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDynamicTableConfig.class);
    public static final int PNAME = 0;
    public static final int ALIAS = 1;
    public static final int ON = 2;
    private boolean saveToOptions;
    private BOrionDatabase db;
    private BSplitPane split;
    private BDynamicColumnTable columnTable;
    private ColumnModel columnModel;
    private BListDropDown rowTypeChoice;
    private BList fromList;
    private BList fromPropList;
    private BList linkedPropList;
    private BLink setModifiedLink;
    private Command addCmd;
    private Command defaultColumns;

    @Generated
    public void rowTypeChanged() {
        this.invoke(rowTypeChanged, null, null);
    }

    @Generated
    public void fromTypeChanged() {
        this.invoke(fromTypeChanged, null, null);
    }

    @Generated
    public void fromPropChanged() {
        this.invoke(fromPropChanged, null, null);
    }

    @Generated
    public void linkedPropChanged() {
        this.invoke(linkedPropChanged, null, null);
    }

    @Generated
    public void handleSetModified() {
        this.invoke(handleSetModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BOrionDatabase getDb() {
        if (this.db == null) {
            BDynamicTable table = (BDynamicTable)this.getCurrentValue();
            if (!table.getDbOrd().isNull()) {
                this.db = (BOrionDatabase)table.getDbOrd().get((BObject)table);
            } else if (!table.getAppOrd().isNull()) {
                BOrionSpace orion = (BOrionSpace)BOrd.make((String)"orion:").get((BObject)table);
                this.db = orion.getOrionDatabaseForApp(table.getAppOrd());
                if (this.db == null) {
                    throw new OrionException("Database not available.");
                }
            } else {
                throw new OrionException("Database not configured.");
            }
        }
        return this.db;
    }

    public void doLoadValue(BObject o, Context cx) {
        BDynamicTable dtable = (BDynamicTable)o;
        this.split = new BSplitPane(BOrientation.vertical, 50.0);
        this.columnTable = this.makeColumnTable(dtable, cx);
        this.setTransferWidget((BTransferWidget)this.columnTable);
        this.linkTo((BComponent)this.columnTable, (Slot)BTable.tableModified, (Slot)setModified);
        BTitlePane propertyPane = BTitlePane.makePane((String)"Columns", (BTable)this.columnTable, (String)"columns");
        this.split.setWidget1((BWidget)propertyPane);
        BEdgePane builder = new BEdgePane();
        BGridPane rowTypeHeader = new BGridPane(2);
        rowTypeHeader.setHalign(BHalign.left);
        rowTypeHeader.add("label", (BValue)new BLabel("Row Type"));
        this.rowTypeChoice = this.buildRowTypeChoice(dtable, cx);
        this.linkTo((BComponent)this.rowTypeChoice, (Slot)BListDropDown.valueModified, (Slot)rowTypeChanged);
        this.linkTo((BComponent)this.rowTypeChoice, (Slot)BListDropDown.valueModified, (Slot)setModified);
        rowTypeHeader.add("choice", (BValue)this.rowTypeChoice);
        builder.setTop((BWidget)new BBorderPane((BWidget)rowTypeHeader, BInsets.make((double)4.0, (double)4.0, (double)4.0, (double)2.0)));
        BEqualPane propSelector = new BEqualPane();
        this.fromList = this.buildFromList();
        propSelector.add("from", (BValue)new BTitlePane("From", (BWidget)this.fromList));
        this.linkTo((BComponent)this.fromList, (Slot)BList.selectionModified, (Slot)fromTypeChanged);
        this.fromPropList = this.buildFromPropList();
        propSelector.add("fromProps", (BValue)new BTitlePane("Property", (BWidget)this.fromPropList));
        this.linkTo((BComponent)this.fromPropList, (Slot)BList.selectionModified, (Slot)fromPropChanged);
        this.linkedPropList = this.buildLinkedPropList();
        propSelector.add("linkedProps", (BValue)new BTitlePane("Linked Property", (BWidget)this.linkedPropList));
        this.linkTo((BComponent)this.linkedPropList, (Slot)BList.selectionModified, (Slot)linkedPropChanged);
        this.setModifiedLink = this.linkTo((BComponent)this, (Slot)setModified, (Slot)handleSetModified);
        builder.setCenter((BWidget)propSelector);
        BGridPane buttons = new BGridPane(2);
        this.addCmd = new AddColumn();
        BButton addButton = new BButton(this.addCmd, true, true);
        buttons.add("add", (BValue)addButton);
        this.defaultColumns = new DefaultColumnsCommand();
        BButton defaultColumnsButton = new BButton(this.defaultColumns, true, true);
        buttons.add("defaultColumns", (BValue)defaultColumnsButton);
        builder.setBottom((BWidget)new BBorderPane((BWidget)buttons, BInsets.make((double)4.0, (double)4.0, (double)4.0, (double)4.0)));
        this.split.setWidget2((BWidget)builder);
        this.setContent((BWidget)this.split);
        this.rowTypeChanged();
        BDynamicTableOptions options = BDynamicTableOptions.make();
        this.saveToOptions = options.getColumns((BDynamicTable)this.getCurrentValue(), this.getCurrentContext()) != null;
    }

    public BObject doSaveValue(BObject o, Context cx) throws Exception {
        Lexicon lex;
        int dialogResult;
        BDynamicTable result = (BDynamicTable)o;
        BOrionDatabase db = this.getDb();
        Context tx = cx;
        BOrionTypeId rowType = ((OrionType)this.rowTypeChoice.getSelectedItem()).getOrionTypeId();
        result.set(BDynamicTable.rowType, (BValue)rowType, tx);
        BDynamicTableColumn[] newColumns = this.columnModel.getColumns();
        if (this.saveToOptions && this.isSuperUser(this.getCurrentContext()) && (dialogResult = BDialog.confirm((BWidget)this, (String)"", (Object)new BLabel((lex = Lexicon.make(BDynamicTableConfig.class)).getText("saveColumnsForAllUsersQuestion")), (int)12)) == 4) {
            this.saveToOptions = false;
        }
        BDynamicTableOptions options = BDynamicTableOptions.make();
        if (this.saveToOptions) {
            BDynamicTable copy = (BDynamicTable)result.newCopy();
            copy.setColumns(newColumns);
            newColumns = copy.getColumns();
            if (newColumns.length > 0) {
                options.setColumns(result, newColumns, this.getCurrentContext());
            } else {
                options.removeColumns(result);
            }
        } else {
            result.setColumns(newColumns);
            options.removeColumns(result);
        }
        return result;
    }

    public void doHandleSetModified(Context cx) {
        this.saveToOptions = true;
    }

    public boolean isSuperUser(Context cx) {
        BUser user = cx.getUser();
        if (user != null) {
            return user.getPermissions().isSuperUser();
        }
        if (cx instanceof BFacets) {
            BFacets facets = (BFacets)cx;
            String username = facets.gets("username", null);
            BISession isession = this.getCurrentValueSession();
            try {
                BUserService userService = (BUserService)BOrd.make((String)"station:|service:baja:UserService").get((BObject)isession);
                userService.loadSlots();
                user = userService.getUser(username);
                user.loadSlots();
                return user.getPermissions().isSuperUser();
            }
            catch (Exception e) {
                return false;
            }
        }
        if (cx == null) {
            return false;
        }
        return false;
    }

    public void addColumn() {
        this.addCmd.invoke();
    }

    private BDynamicColumnTable makeColumnTable(BDynamicTable dtable, Context cx) {
        this.columnModel = new ColumnModel();
        BDynamicTableColumn[] columns = dtable.getWorkingColumns(cx);
        for (int i = 0; i < columns.length; ++i) {
            BDynamicTableColumn col = columns[i];
            this.columnModel.addColumn((BDynamicTableColumn)col.newCopy());
        }
        BDynamicColumnTable t = new BDynamicColumnTable(this.columnModel);
        t.setSelection(new ColumnSelection());
        return t;
    }

    private BListDropDown buildRowTypeChoice(BDynamicTable dtable, Context cx) {
        BOrionDatabase db = this.getDb();
        BOrionType[] types = db.getTypes();
        BOrionTypeId rowTypeId = dtable.getRowType();
        BListDropDown typeChoice = new BListDropDown();
        if (Flags.isReadonly((BComplex)dtable, (Slot)BDynamicTable.rowType)) {
            typeChoice.setEnabled(false);
        }
        BList typeList = typeChoice.getList();
        for (int i = 0; i < types.length; ++i) {
            typeList.addItem((Object)types[i].getOrionType());
            if (rowTypeId.isNull() || !types[i].getOrionTypeId().equals((Object)rowTypeId)) continue;
            typeChoice.setSelectedIndex(i);
        }
        return typeChoice;
    }

    public void doRowTypeChanged() {
        this.updateFromList((OrionType)this.rowTypeChoice.getSelectedItem());
    }

    private BList buildFromList() {
        BList fromList = new BList();
        fromList.setRenderer(new ListRenderer(){

            public String getItemText(ListRenderer.Item item) {
                if (item.value instanceof BTypeDependency) {
                    return ((BTypeDependency)item.value).getFromDisplay();
                }
                return super.getItemText(item);
            }
        });
        return fromList;
    }

    private void updateFromList(OrionType rowType) {
        this.fromList.removeAllItems();
        this.fromList.getSelection().deselectAll();
        if (rowType == null) {
            return;
        }
        this.fromList.addItem((Object)BTypeDependency.make((BOrionTypeId)rowType.getOrionTypeId(), (String)"", (BOrionTypeId)BOrionTypeId.NULL, (String)""));
        BOrionDatabase db = this.getDb();
        BTypeDependency[] dependencies = db.getDependentTypes(rowType);
        for (int i = 0; i < dependencies.length; ++i) {
            OrionType orionType = (OrionType)dependencies[i].getFromTypeId().getTypeSpec().getResolvedType();
            if (!BDynamicTableConfig.hasPermissionForOrionType(orionType, db, this.getCurrentContext())) continue;
            this.fromList.addItem((Object)dependencies[i]);
        }
    }

    public void doFromTypeChanged() {
        this.updateFromPropList(this.fromList.getSelectedItem());
    }

    public static boolean hasPermissionForOrionType(OrionType orionType, BOrionDatabase db, Context cx) {
        BOrionType bOrionType = db.getType(orionType);
        return bOrionType != null && bOrionType.getPermissions(cx).hasOperatorRead();
    }

    private BList buildFromPropList() {
        BList fromPropList = new BList();
        fromPropList.setController((ListController)new LController());
        fromPropList.setRenderer(new ListRenderer(){

            public String getItemText(ListRenderer.Item item) {
                return ((Property)item.value).getName();
            }
        });
        return fromPropList;
    }

    private void updateFromPropList(Object selection) {
        this.fromPropList.removeAllItems();
        this.fromPropList.getSelection().deselectAll();
        if (selection == null) {
            return;
        }
        BOrionDatabase db = this.getDb();
        OrionType fromType = null;
        BTypeDependency dependency = null;
        if (selection instanceof OrionType) {
            fromType = (OrionType)selection;
        } else {
            dependency = (BTypeDependency)selection;
            fromType = db.getType(dependency.getFromTypeId());
        }
        Property[] props = fromType.getProperties();
        for (int i = 0; i < props.length; ++i) {
            BRef ref;
            OrionType orionType;
            if (dependency != null && props[i].getName().equals(dependency.getFromProperty()) || props[i].getType().is(BBlob.TYPE) || props[i].getType().is(BRef.TYPE) && !BDynamicTableConfig.hasPermissionForOrionType(orionType = (OrionType)(ref = (BRef)props[i].getDefaultValue()).getTargetOrionTypeId().getTypeSpec().getResolvedType(), db, this.getCurrentContext())) continue;
            this.fromPropList.addItem((Object)props[i]);
        }
    }

    public void doFromPropChanged() {
        Property fromProp = (Property)this.fromPropList.getSelectedItem();
        if (fromProp != null && fromProp.getType() == BRef.TYPE) {
            BRef def = (BRef)fromProp.getDefaultValue();
            BOrionDatabase db = this.getDb();
            OrionType targetType = db.getType(def.getTargetOrionTypeId());
            this.updateLinkedPropList(targetType);
        } else {
            this.updateLinkedPropList(null);
        }
    }

    private BList buildLinkedPropList() {
        BList linkedPropList = new BList();
        linkedPropList.setController((ListController)new LController());
        linkedPropList.setRenderer(new ListRenderer(){

            public String getItemText(ListRenderer.Item item) {
                return ((Property)item.value).getName();
            }
        });
        return linkedPropList;
    }

    private void updateLinkedPropList(OrionType fromPropType) {
        this.linkedPropList.removeAllItems();
        this.linkedPropList.getSelection().deselectAll();
        if (fromPropType == null) {
            return;
        }
        Property[] props = fromPropType.getProperties();
        for (int i = 0; i < props.length; ++i) {
            BRef ref;
            OrionType orionType;
            if (props[i].getType().is(BBlob.TYPE) || props[i].getType().is(BRef.TYPE) && !BDynamicTableConfig.hasPermissionForOrionType(orionType = (OrionType)(ref = (BRef)props[i].getDefaultValue()).getTargetOrionTypeId().getTypeSpec().getResolvedType(), this.db, this.getCurrentContext())) continue;
            this.linkedPropList.addItem((Object)props[i]);
        }
    }

    public void doLinkedPropChanged() {
    }

    private class LController
    extends ListController {
        private LController() {
        }

        protected void itemDoubleClicked(BMouseEvent event, int index) {
            BDynamicTableConfig.this.addColumn();
        }
    }

    private class ColumnSelection
    extends TableSelection {
        private ColumnSelection() {
        }

        public void updateTable() {
            this.getTable().setDeleteEnabled(!this.isEmpty());
            super.updateTable();
        }
    }

    class ColumnModel
    extends TableModel {
        private Array<BDynamicTableColumn> visibleColumns = new Array(BDynamicTableColumn.class);
        private Array<BDynamicTableColumn> allColumns = new Array(BDynamicTableColumn.class);

        ColumnModel() {
        }

        public void addColumn(BDynamicTableColumn newColumn) {
            BDynamicTable dt = (BDynamicTable)BDynamicTableConfig.this.getCurrentValue();
            if (!newColumn.getHiddenKey() && BDynamicTable.hasPermissionForColumn(newColumn, dt.getOrionDatabase(), BDynamicTableConfig.this.getCurrentContext())) {
                this.visibleColumns.add((Object)newColumn);
            }
            this.allColumns.add((Object)newColumn);
            this.updateTable();
        }

        public void ensureVisible(BDynamicTableColumn newColumn) {
            BDynamicTable dt = (BDynamicTable)BDynamicTableConfig.this.getCurrentValue();
            BDynamicTableColumn c = this.getExisting(newColumn);
            if (!c.getHiddenKey() && BDynamicTable.hasPermissionForColumn(newColumn, dt.getOrionDatabase(), BDynamicTableConfig.this.getCurrentContext())) {
                return;
            }
            this.visibleColumns.remove((Object)c);
            c.setHiddenKey(false);
            this.visibleColumns.add((Object)c);
            this.updateTable();
        }

        public BDynamicTableColumn getExisting(BDynamicTableColumn column) {
            for (int i = 0; i < this.allColumns.size(); ++i) {
                BDynamicTableColumn existing = (BDynamicTableColumn)((Object)this.allColumns.get(i));
                if (!column.getFromType().equals((Object)existing.getFromType()) || !column.getFromProperty().equals(existing.getFromProperty())) continue;
                return existing;
            }
            return null;
        }

        public boolean exists(BDynamicTableColumn column) {
            return this.getExisting(column) != null;
        }

        public void defaultColumns() {
            this.visibleColumns.clear();
            this.allColumns.clear();
            BOrionTypeId rowType = ((OrionType)BDynamicTableConfig.this.rowTypeChoice.getSelectedItem()).getOrionTypeId();
            BDynamicTable table = (BDynamicTable)BDynamicTableConfig.this.getCurrentValue();
            BDynamicTableColumn[] columns = table.getDefaultColumns();
            for (int i = 0; i < columns.length; ++i) {
                BDynamicTableColumn col = columns[i];
                this.addColumn(col);
            }
            this.updateTable();
        }

        public void deleteSelection() {
            int i;
            int[] selection = this.getSelection().getRows();
            BDynamicTableColumn[] toDelete = new BDynamicTableColumn[selection.length];
            for (i = 0; i < selection.length; ++i) {
                toDelete[i] = (BDynamicTableColumn)((Object)this.getSubject(selection[i]));
            }
            for (i = 0; i < toDelete.length; ++i) {
                this.visibleColumns.remove((Object)toDelete[i]);
                if (!toDelete[i].isRowKey()) {
                    this.allColumns.remove((Object)toDelete[i]);
                } else {
                    this.allColumns.remove((Object)toDelete[i]);
                    toDelete[i].setHiddenKey(true);
                    this.allColumns.add((Object)toDelete[i]);
                }
                BDynamicTableConfig.this.setModified();
            }
            this.getSelection().deselectAll();
        }

        public Object getSubject(int row) {
            return this.visibleColumns.get(row);
        }

        public BDynamicTableColumn[] getColumns() {
            return (BDynamicTableColumn[])this.allColumns.trim();
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Display Name";
                }
                case 2: {
                    return "From Type";
                }
            }
            return "Error-" + col;
        }

        public int getRowCount() {
            return this.visibleColumns.size();
        }

        public Object getValueAt(int row, int col) {
            BDynamicTableColumn c = (BDynamicTableColumn)((Object)this.visibleColumns.get(row));
            switch (col) {
                case 0: {
                    return c.getColumnName();
                }
                case 1: {
                    return c.getAlias();
                }
                case 2: {
                    return c.getFromType();
                }
            }
            return "Error-" + row + "x" + col;
        }
    }

    private class AddColumn
    extends Command {
        public AddColumn() {
            super((BWidget)BDynamicTableConfig.this, TYPE.getModule(), "command.addColumn");
        }

        public CommandArtifact doInvoke() {
            BTypeDependency from = (BTypeDependency)BDynamicTableConfig.this.fromList.getSelectedItem();
            Property fromTypeProp = (Property)BDynamicTableConfig.this.fromPropList.getSelectedItem();
            Property linkedProp = (Property)BDynamicTableConfig.this.linkedPropList.getSelectedItem();
            if (from == null || fromTypeProp == null) {
                return null;
            }
            String columnName = linkedProp == null ? fromTypeProp.getName() : linkedProp.getName();
            String displayName = TextUtil.toFriendly((String)columnName);
            BDynamicTableColumn col = null;
            if (linkedProp == null) {
                BOrionTypeId fromType = from.getFromTypeId();
                col = new BDynamicTableColumn(columnName, displayName, fromType, fromTypeProp.getName(), from.getFromProperty().length() == 0 ? BTypeDependency.NULL : from);
            } else {
                BOrionTypeId refTypeId = ((BRef)fromTypeProp.getDefaultValue()).getTargetOrionTypeId();
                OrionType refType = BDynamicTableConfig.this.getDb().getType(refTypeId);
                BTypeDependency d = BTypeDependency.make((BOrionTypeId)refTypeId, (String)refType.getKey()[0].getName(), (BOrionTypeId)from.getFromTypeId(), (String)fromTypeProp.getName());
                col = new BDynamicTableColumn(columnName, displayName, refTypeId, linkedProp.getName(), d, from.getFromProperty().length() == 0 ? BTypeDependency.NULL : from);
            }
            if (!BDynamicTableConfig.this.columnModel.exists(col)) {
                BDynamicTableConfig.this.columnModel.addColumn(col);
            } else if (col.isRowKey()) {
                BDynamicTableConfig.this.columnModel.ensureVisible(col);
            }
            return null;
        }
    }

    private class DefaultColumnsCommand
    extends Command {
        public DefaultColumnsCommand() {
            super((BWidget)BDynamicTableConfig.this, TYPE.getModule(), "command.defaultColumns");
        }

        public CommandArtifact doInvoke() {
            BDynamicTable table = (BDynamicTable)BDynamicTableConfig.this.getCurrentValue();
            if (BDynamicTableConfig.this.isSuperUser(BDynamicTableConfig.this.getCurrentContext())) {
                BDynamicTableConfig.this.columnModel.defaultColumns();
            } else {
                BDynamicTableOptions options = BDynamicTableOptions.make();
                options.removeColumns(table);
                BDynamicTableConfig.this.loadValue((BObject)table, BDynamicTableConfig.this.getCurrentContext());
            }
            BDynamicTableConfig.this.saveToOptions = false;
            ((BWbShell)this.getShell()).getSaveCommand().invoke();
            BDynamicTableConfig.this.loadValue((BObject)table, BDynamicTableConfig.this.getCurrentContext());
            return null;
        }
    }

    class NameContainer
    implements ObjectUtil.NameContainer {
        private HashMap<String, String> map = new HashMap();

        NameContainer() {
        }

        public void put(String name) {
            this.map.put(name, name);
        }

        public boolean contains(String name) {
            return this.map.get(name) != null;
        }
    }
}

