/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.filter;

import com.tridium.bql.filter.BAbsTimeFilter;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.bql.util.BDynamicTimeRangeType;
import com.tridium.hx.fieldeditors.BHxAbsTimeFE;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.filter.BHxFilterFE;
import com.tridium.smartTableHx.tab.HxTabUtil;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"workbench:AbsTimeFilterFE"}, requiredPermissions="r")})
@NiagaraSingleton
public class BHxAbsTimeFilterFE
extends BHxFilterFE {
    @Generated
    public static final BHxAbsTimeFilterFE INSTANCE = new BHxAbsTimeFilterFE();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxAbsTimeFilterFE.class);
    private SmartCommand pickerCommand = new PickerCommand((BHxView)this);
    private static final LexiconModule lex = LexiconModule.make((String)"bql");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxAbsTimeFilterFE() {
        this.registerEvent((Event)this.pickerCommand);
    }

    public void write(HxOp op) throws Exception {
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        BAbsTimeFilter filter = (BAbsTimeFilter)op.get();
        BDynamicTimeRange range = filter.getDynamicTimeRange();
        BDynamicTimeRange dynamicRange = BDynamicTimeRange.make((BAbsTime)range.getFixedStartTime(), (BAbsTime)range.getFixedEndTime());
        HtmlWriter out = op.getHtmlWriter();
        BHxFieldEditor timeRangeTypeEd = BHxFieldEditor.makeFor((BObject)filter.getTimeRangeType(), (Context)op);
        HxOp timeRangeTypeOp = op.make("timeRangeType", (BObject)filter.getTimeRangeType(), null);
        if (!op.canWrite()) {
            timeRangeTypeOp.setReadonly(true);
        }
        timeRangeTypeEd.write(timeRangeTypeOp);
        out.w((Object)"<span ");
        out.attr("name", op.scope("picker"));
        out.attr("id", op.scope("picker"));
        out.attr("style", "display:none;");
        out.w((Object)"> ");
        out.w((Object)"<span ");
        out.w((Object)" onclick='").w((Object)this.pickerCommand.getInvokeCode(op)).w((Object)"'");
        out.w((Object)">");
        HxUtil.makeImageJS((BImage)this.pickerCommand.getIcon(op), null, null, null, (HxOp)op);
        out.w((Object)"</span> ");
        out.w((Object)"<input ");
        out.attr("type", "text");
        out.attr("size", "30");
        out.attr("name", op.scope("preview"));
        out.attr("id", op.scope("preview"));
        out.attr("value", this.updateField(dynamicRange, op));
        out.attr("readonly", "readonly");
        out.attr("locked", "locked");
        out.w((Object)"/>");
        BHxSmartTableView.writeFormValue("range", dynamicRange.encodeToString(), op);
        out.w((Object)"</span>");
        HxTabUtil.addEvent("change", HxTabUtil.HIDE_ELEM, HxTabUtil.CALL_NOW, timeRangeTypeOp.scope("value"), op.scope("picker"), String.valueOf(0), op);
    }

    public BObject save(HxOp op) throws Exception {
        HxOp timeRangeTypeOp;
        BAbsTimeFilter filter = (BAbsTimeFilter)op.get();
        BHxFieldEditor timeRangeTypeEd = BHxFieldEditor.makeFor((BObject)filter.getTimeRangeType(), (Context)op);
        BDynamicTimeRangeType rangeType = (BDynamicTimeRangeType)timeRangeTypeEd.save(timeRangeTypeOp = op.make("timeRangeType", (BObject)filter.getTimeRangeType(), null));
        if (rangeType == BDynamicTimeRangeType.timeRange) {
            BDynamicTimeRange range = (BDynamicTimeRange)BDynamicTimeRange.DEFAULT.decodeFromString(op.getUnsafeFormValue("range"));
            filter.initFromDynamicTimeRange(range);
        } else {
            filter.initFromDynamicTimeRange(BDynamicTimeRange.make((BDynamicTimeRangeType)rangeType));
        }
        return filter;
    }

    public String updateField(BDynamicTimeRange range, HxOp op) {
        if (range.getRangeType() != BDynamicTimeRangeType.timeRange) {
            return "";
        }
        return this.formatTimeRange(range.getFixedStartTime(), range.getFixedEndTime(), op);
    }

    private String formatTimeRange(BAbsTime startTime, BAbsTime endTime, HxOp op) {
        StringBuilder s = new StringBuilder();
        if (startTime == null || startTime.isNull()) {
            s.append(lex.getText("dynamicTimeRangeFE.epoch", (Context)op));
        } else {
            s.append(startTime.toString((Context)op));
        }
        s.append("  ").append(lex.getText("dynamicTimeRangeFE.to", (Context)op)).append("  ");
        if (endTime == null || endTime.isNull()) {
            s.append(lex.getText("dynamicTimeRangeFE.now", (Context)op));
        } else {
            s.append(endTime.toString((Context)op));
        }
        return s.toString();
    }

    public class PickerCommand
    extends SmartCommand {
        private PickerDialog dlg;

        public PickerCommand(BHxView view) {
            super(view);
            this.dlg = new PickerDialog(this, this.getDisplayName(null));
        }

        @Override
        public String getName(HxOp op) {
            return "timePicker";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            BAbsTimeFilter filter = (BAbsTimeFilter)op.get();
            filter = (BAbsTimeFilter)filter.newCopy();
            filter.setTimeRangeType(BDynamicTimeRangeType.timeRange);
            HxOp minOp = op.make("min", (BObject)filter.getStartTime(), null);
            filter.set(BAbsTimeFilter.startTime, (BValue)BHxAbsTimeFE.INSTANCE.save(minOp));
            HxOp maxOp = op.make("max", (BObject)filter.getEndTime(), null);
            filter.set(BAbsTimeFilter.endTime, (BValue)BHxAbsTimeFE.INSTANCE.save(maxOp));
            filter.setMinEnabled(op.getFormValue("minEnabledBackup") != null && op.getFormValue("minEnabledBackup").equals("true"));
            filter.setMaxEnabled(op.getFormValue("maxEnabledBackup") != null && op.getFormValue("maxEnabledBackup").equals("true"));
            HtmlWriter out = op.getHtmlWriter();
            BDynamicTimeRange range = filter.getDynamicTimeRange();
            SmartCommand.setFormValue(op.scope("preview"), BHxAbsTimeFilterFE.this.updateField(range, op), op);
            SmartCommand.setFormValue(op.scope("range"), range.encodeToString(), op);
        }

        public class PickerDialog
        extends Dialog {
            PickerDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                BAbsTimeFilter filter = (BAbsTimeFilter)op.get();
                boolean readonly = Flags.isReadonly((BComplex)filter.getParent().getParent(), (Slot)filter.getParent().getPropertyInParent());
                BDynamicTimeRange range = (BDynamicTimeRange)BDynamicTimeRange.DEFAULT.decodeFromString(op.getUnsafeFormValue("range"));
                filter.initFromDynamicTimeRange(range);
                HtmlWriter out = op.getHtmlWriter();
                HxOp minOp = op.make("min", (BObject)filter.getStartTime(), null);
                out.w((Object)"<input ");
                out.attr("type", "checkbox");
                out.attr("name", op.scope("minEnabled"));
                out.attr("id", op.scope("minEnabled"));
                out.attr("onclick", "hx.setFormValue('" + op.scope("minEnabledBackup") + "', this.checked);");
                if (filter.getMinEnabled()) {
                    op.addOnload("hx.setFormValue('" + op.scope("minEnabledBackup") + "', 'true');");
                    out.attr("checked", "on");
                }
                if (!op.canWrite() || readonly) {
                    minOp.setReadonly(true);
                    out.attr("disabled", "disabled");
                }
                out.w((Object)"/>");
                out.safe((Object)(" " + PickerCommand.this.lexModule.getText("min", (Context)op)));
                out.w((Object)"<span ");
                out.attr("style", "padding:2px");
                out.w((Object)">&nbsp;");
                out.w((Object)"</span>");
                BHxAbsTimeFE.INSTANCE.write(minOp);
                HxOp maxOp = op.make("max", (BObject)filter.getEndTime(), null);
                out.w((Object)"<br/>");
                out.w((Object)" <input ");
                out.attr("type", "checkbox");
                out.attr("name", op.scope("maxEnabled"));
                out.attr("id", op.scope("maxEnabled"));
                out.attr("onclick", "hx.setFormValue('" + op.scope("maxEnabledBackup") + "', this.checked);");
                if (filter.getMaxEnabled()) {
                    op.addOnload("hx.setFormValue('" + op.scope("maxEnabledBackup") + "', 'true');");
                    out.attr("checked", "on");
                }
                if (!op.canWrite() || readonly) {
                    maxOp.setReadonly(true);
                    out.attr("disabled", "disabled");
                }
                out.w((Object)"/>");
                out.safe((Object)(" " + PickerCommand.this.lexModule.getText("max", (Context)op) + " "));
                BHxAbsTimeFE.INSTANCE.write(maxOp);
            }
        }
    }
}

