/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.export;

import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.export.BExportData;
import com.tridium.smartTableHx.export.BExportFileScheme;
import com.tridium.smartTableHx.export.BExportFileWrapper;
import com.tridium.smartTableHx.export.BPdfStyle;
import com.tridium.smartTableHx.export.DownloadDialog;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import javax.baja.file.BExporter;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.naming.OrdTarget;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.util.Lexicon;

public class ExportCommand
extends SmartCommand {
    private ExportDialog dialog = new ExportDialog(this);

    public ExportCommand(BHxView view) {
        super(view);
    }

    @Override
    public String getName(HxOp op) {
        return "export";
    }

    @Override
    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    @Override
    public boolean readonlyEnablePolicy(HxOp op) {
        return true;
    }

    @Override
    public boolean isTableCommand(HxOp op) {
        return true;
    }

    public void handle(HxOp op) throws Exception {
        if (!this.dialog.isSubmit(op)) {
            this.dialog.open(op);
            return;
        }
        try {
            op = op.mergeFacets(BHxSmartTableView.exportTableFacets);
            BExportData data = (BExportData)this.getExportTab(op).save();
            ExportCommand.validate(data, (BHxSmartTableView)this.getView(), op);
            BExportFileWrapper wrapper = ExportCommand.makeExportFile(data, op);
            ExportCommand.redirectToWrapper(wrapper, op);
        }
        catch (Throwable e) {
            e.printStackTrace();
            new ErrorDialog("Cannot Export", (Command)this, e).open(op);
        }
    }

    public static TableContents getTableContents(BHxSmartTableView view, HxOp op) throws Exception {
        return view.writeContents(op);
    }

    public static void validate(BExportData exportData, BHxSmartTableView view, HxOp op) throws Exception {
        int maxResultsSize = view.getMaxResultSize((Context)op);
        if (exportData.isCurrentSelection()) {
            HashSet selected = new HashSet();
            Collections.addAll(selected, ExportCommand.getSelectionList(op));
            exportData.setTableContents(ExportCommand.getTableContents(view, op), maxResultsSize);
            TableContents result = exportData.getTableContents().getBasicCopy();
            for (int i = 0; i < exportData.getTableContents().tr.size(); ++i) {
                TableContents.Tr tr = exportData.getTableContents().tr.get(i);
                if (!selected.contains(tr.id)) continue;
                result.tr.add(tr);
            }
            exportData.setTableContents(result, maxResultsSize);
        } else if (exportData.isSinglePage()) {
            exportData.setTableContents(ExportCommand.getTableContents(view, op), maxResultsSize);
            exportData.setTableContents(exportData.getTableContents().getPage(view.getPage(op) - 1, view.getPageSize(op)), maxResultsSize);
        } else if (!view.supportsPaginatedQuery(op)) {
            exportData.setTableContents(ExportCommand.getTableContents(view, op), maxResultsSize);
        } else {
            int pageSize = view.getPageSize(op);
            view.setPageSize(op, view.getMaxResultSize((Context)op));
            exportData.setTableContents(ExportCommand.getTableContents(view, op), maxResultsSize);
            view.setPageSize(op, pageSize);
        }
        if (!exportData.isPdf()) {
            return;
        }
        BPdfStyle style = exportData.getResolvedStyle();
        BImage image = style.getImage();
        try {
            image.syncDimensions();
            if (image.getHeight() == 0.0) {
                throw new IllegalStateException("Please choose a PDF style with a valid image.");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Please choose a PDF style with a valid image.");
        }
    }

    public Tab getExportTab(HxOp op) throws Exception {
        BExportData exportData = new BExportData(this.getView().getPageTitle(op));
        return ExportCommand.getExportTab(exportData, op);
    }

    public static Tab getExportTab(BExportData exportData, HxOp op) {
        return new Tab(BHxFieldSheet.INSTANCE, op.make("fields", (BObject)exportData, null));
    }

    public static BExportFileWrapper makeExportFile(BExportData exportData, HxOp op) throws Exception {
        String fileName = exportData.getFileName();
        BExporter exporter = exportData.getExporter();
        BExportFileWrapper wrapper = ExportCommand.makeExportFileWrapper(fileName);
        OrdTarget target = new OrdTarget(op.getBaseOrdTarget(), (BObject)exportData);
        exporter.export(PdfOp.make((OrdTarget)target, (OutputStream)wrapper.getOutputStream()));
        wrapper.closeOutput();
        return wrapper;
    }

    public static BExportFileWrapper makeExportFileWrapper(String fileName) throws Exception {
        BExportFileWrapper wrapper = new BExportFileWrapper(fileName);
        wrapper.init();
        return wrapper;
    }

    public static void redirectToWrapper(BExportFileWrapper wrapper, HxOp op) throws Exception {
        ExportCommand.redirectToWrapper(wrapper, false, op);
    }

    public static void redirectToWrapper(BExportFileWrapper wrapper, boolean refresh, HxOp op) throws Exception {
        BExportFileScheme.addWrapper(wrapper);
        new DownloadDialog(Lexicon.make(ExportCommand.class).getText("download"), null, wrapper, refresh).open(op);
    }

    public class ExportDialog
    extends Dialog {
        public ExportDialog(Command handler) {
            super(handler);
        }

        protected String getTitle(HxOp op) {
            return ExportCommand.this.getDisplayName(op);
        }

        protected void writeContent(HxOp op) throws Exception {
            Tab tab = ExportCommand.this.getExportTab(op);
            tab.write();
            HxTabUtil.addEvent("change", HxTabUtil.HIDE_ELEM, HxTabUtil.CALL_NOW, tab.op.scope(BExportData.fileType.getName() + ".value"), tab.op.scope(BExportData.alignment.getName()), "0", op);
            HxTabUtil.addEvent("change", HxTabUtil.HIDE_ELEM, HxTabUtil.CALL_NOW, tab.op.scope(BExportData.fileType.getName() + ".value"), tab.op.scope(BExportData.style.getName()), "0", op);
            HxTabUtil.addEvent("change", HxTabUtil.HIDE_ELEM, HxTabUtil.CALL_NOW, tab.op.scope(BExportData.fileType.getName() + ".value"), tab.op.scope(BExportData.includeHeaders.getName()), "1", op);
            HxTabUtil.addEvent("change", HxTabUtil.HIDE_ELEM, HxTabUtil.CALL_NOW, tab.op.scope(BExportData.fileType.getName() + ".value"), tab.op.scope(BExportData.includeBOM.getName()), "1", op);
            HxTabUtil.addEvent("change", HxTabUtil.HIDE_ELEM, HxTabUtil.CALL_NOW, tab.op.scope(BExportData.fileType.getName() + ".value"), tab.op.scope(BExportData.useCRLF.getName()), "1", op);
            HxTabUtil.addEvent("change", HxTabUtil.HIDE_ELEM, HxTabUtil.CALL_NOW, tab.op.scope(BExportData.fileType.getName() + ".value"), tab.op.scope(BExportData.delimiter.getName()), "1", op);
        }
    }
}

