/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.exporters;

import com.tridium.data.BDataTable;
import com.tridium.file.exporters.BITableToCsv;
import com.tridium.report.exporters.BGridToText;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.baja.collection.BITable;
import javax.baja.file.ExportOp;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.report.grid.BIGrid;
import javax.baja.report.grid.GridModel;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"report:IGrid"}, requiredPermissions="r")})
@NiagaraProperties(value={@NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.DEFAULT", flags=4, override=true), @NiagaraProperty(name="encodeToString", type="boolean", defaultValue="BBoolean.FALSE", flags=4, override=true)})
public class BGridToCsv
extends BITableToCsv {
    @Generated
    public static final Property facets = BGridToCsv.newProperty((int)4, (BValue)BFacets.DEFAULT, null);
    @Generated
    public static final Property encodeToString = BGridToCsv.newProperty((int)4, (BValue)BBoolean.FALSE, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BGridToCsv.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void export(ExportOp op) throws Exception {
        BIGrid grid = (BIGrid)op.get();
        BComponent gridComp = (BComponent)grid;
        GridModel model = grid.resolve((BObject)gridComp, (Context)op);
        OutputStreamWriter osw = new OutputStreamWriter(op.getOutputStream(), "UTF-8");
        PrintWriter out = new PrintWriter(osw);
        if (this.getIncludeBOM()) {
            out.write(65279);
            out.flush();
        }
        if (this.getIncludeHeaders()) {
            out.print(gridComp.getName());
            out.print(this.getLineEnding());
            out.print(gridComp.getSlotPath());
            out.print(this.getLineEnding());
            out.print(BAbsTime.now());
            out.print(this.getLineEnding());
            out.print(this.getLineEnding());
            out.flush();
        }
        BDataTable table = BGridToText.makeTable(model, (Context)op);
        this.export((BITable)table, op);
    }
}

