/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.file.BExporter;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BExportSourceInfo
extends BSimple {
    public static final BExportSourceInfo NULL;
    public static final BExportSourceInfo DEFAULT;
    public static final Type TYPE;
    private BOrd source;
    private String agentId;
    private BExporter exporter;

    public static BExportSourceInfo make(BOrd source, String agentId, BExporter exporter) {
        return new BExportSourceInfo(source, agentId, exporter);
    }

    public static BExportSourceInfo make(String s) {
        boolean hasOrdEncoded;
        String[] splitAgentAndSourceOnFirstSemicolon;
        String agentId;
        boolean hasValueDocEncoding;
        String[] splitOnPTag = s.split("(?=<p)", 2);
        BExporter exporter = null;
        boolean bl = hasValueDocEncoding = splitOnPTag.length == 2;
        if (hasValueDocEncoding) {
            try {
                exporter = (BExporter)ValueDocDecoder.unmarshal((String)splitOnPTag[1]);
            }
            catch (Exception e) {
                throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        if ((agentId = (splitAgentAndSourceOnFirstSemicolon = splitOnPTag[0].split(";", 2))[0]).equals("null")) {
            agentId = null;
        }
        String source = null;
        boolean bl2 = hasOrdEncoded = splitAgentAndSourceOnFirstSemicolon.length >= 2;
        if (hasOrdEncoded) {
            source = splitAgentAndSourceOnFirstSemicolon[1].replaceAll(";$", "");
        }
        return new BExportSourceInfo(BOrd.make(source), agentId, exporter);
    }

    private BExportSourceInfo(BOrd source, String agentId, BExporter exporter) {
        this.source = source;
        this.agentId = agentId;
        this.exporter = exporter;
    }

    public BOrd getSource() {
        return this.source;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public BExporter getExporter() {
        return this.exporter;
    }

    public int hashCode() {
        int hash = 23 + this.source.hashCode();
        int agentHash = this.agentId != null ? this.agentId.hashCode() : 0;
        return hash * 37 + agentHash;
    }

    public boolean equals(Object obj) {
        BExportSourceInfo info;
        if (obj instanceof BExportSourceInfo && (info = (BExportSourceInfo)((Object)obj)).getSource().equals((Object)this.source)) {
            if (this.agentId == null && info.getAgentId() == null) {
                return this.checkExporter(info);
            }
            if (this.agentId != null && info.getAgentId() != null && this.agentId.equals(info.getAgentId())) {
                return this.checkExporter(info);
            }
        }
        return false;
    }

    private boolean checkExporter(BExportSourceInfo info) {
        if (this.exporter == null && info.getExporter() == null) {
            return true;
        }
        if (this.exporter != null && info.getExporter() != null) {
            return this.exporter.equivalent((Object)info.getExporter());
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        String encode = this.agentId + ";" + this.source.encodeToString();
        if (null != this.exporter) {
            encode = encode + ";" + ValueDocEncoder.marshal((BValue)this.exporter);
        }
        return encode;
    }

    public BObject decodeFromString(String s) throws IOException {
        return BExportSourceInfo.make(s);
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = BExportSourceInfo.make(BOrd.NULL, null, null);
        TYPE = Sys.loadType(BExportSourceInfo.class);
    }
}

