/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnetAws.datatypes;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.EventNotificationParameters;
import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnetAws.history.BBacnetEventRecord;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.history.BHistoryRecord;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@Deprecated
@NiagaraProperties(value={@NiagaraProperty(name="timestamp", type="BBacnetDateTime", defaultValue="new BBacnetDateTime()"), @NiagaraProperty(name="logDatum", type="BSimple", defaultValue="BBacnetNull.DEFAULT")})
public final class BBacnetEventLogRecord
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property timestamp = BBacnetEventLogRecord.newProperty((int)0, (BValue)new BBacnetDateTime(), null);
    @Generated
    public static final Property logDatum = BBacnetEventLogRecord.newProperty((int)0, (BValue)BBacnetNull.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetEventLogRecord.class);
    int logDatumChoice;
    EventNotificationParameters enp = null;
    private static final Log logger = Log.getLog((String)"bacnet");
    public static final int TIMESTAMP_TAG = 0;
    public static final int LOG_DATUM_TAG = 1;
    public static final int LOG_STATUS_TAG = 0;
    public static final int NOTIFICATION_TAG = 1;
    public static final int TIME_CHANGE_TAG = 2;

    @Generated
    public BBacnetDateTime getTimestamp() {
        return (BBacnetDateTime)this.get(timestamp);
    }

    @Generated
    public void setTimestamp(BBacnetDateTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    @Generated
    public BSimple getLogDatum() {
        return (BSimple)this.get(logDatum);
    }

    @Generated
    public void setLogDatum(BSimple v) {
        this.set(logDatum, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void writeAsn(AsnOutput out) {
    }

    public void readAsn(AsnInput in) throws AsnException {
        in.skipOpeningTag(0);
        this.getTimestamp().readAsn(in);
        in.skipClosingTag(0);
        in.skipOpeningTag(1);
        this.logDatumChoice = in.peekTag();
        switch (this.logDatumChoice) {
            case 0: {
                this.set(logDatum, (BValue)BTrendEvent.makeLogStatus((BBacnetBitString)in.readBitString(0)), noWrite);
                break;
            }
            case 1: {
                in.skipOpeningTag(1);
                this.enp = new EventNotificationParameters();
                this.enp.readEncoded((AsnInputStream)in);
                in.skipClosingTag(1);
                break;
            }
            case 2: {
                this.set(logDatum, (BValue)BTrendEvent.makeTimeChange((long)((long)in.readReal(2))), noWrite);
                break;
            }
            default: {
                logger.message("Invalid logDatumChoice!");
            }
        }
        in.skipClosingTag(1);
    }

    public String toString(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTimestamp().toString(context)).append('_').append(this.getLogDatum().toString(context)).append('_');
        return sb.toString();
    }

    public BHistoryRecord initializeNiagaraRecord(BHistoryRecord record, long seqNum) {
        BBacnetEventRecord rec = (BBacnetEventRecord)record;
        rec.setTimestamp(this.getTimestamp().toBAbsTime());
        rec.setSequenceNumber(seqNum);
        switch (this.logDatumChoice) {
            case 0: 
            case 2: {
                rec.setLogEvent((BTrendEvent)this.getLogDatum());
                rec.setTrendFlags(rec.getTrendFlags().set(4, true));
                break;
            }
            case 1: {
                rec.setLogEvent(BTrendEvent.DEFAULT);
                rec.setProcessId(Long.toString(this.enp.getProcessId()));
                rec.setInitiatingDevice(this.enp.getInitiatingDeviceId().toString());
                rec.setEventObject(this.enp.getEventObjectId().toString());
                rec.setTimeStamp(this.enp.getTimeStamp().toString());
                rec.setNotificationClass(Long.toString(this.enp.getNotificationClass()));
                rec.setPriority(Integer.toString(this.enp.getPriority()));
                rec.setEventType(this.enp.getEventType().getTag());
                rec.setMessageText(this.enp.getMessageText().toString());
                rec.setNotifyType(this.enp.getNotifyType().toString());
                rec.setAckRequired(Boolean.toString(this.enp.getAckRequired()));
                rec.setFromState(this.enp.getFromState().getTag());
                rec.setToState(this.enp.getToState().getTag());
                rec.setEventValues(this.enp.getEventValues().toString());
            }
        }
        return rec;
    }
}

