/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.servlets;

import com.tridium.bacnetAws.BBacnetAwsNetwork;
import com.tridium.bacnetAws.datatypes.BBackupConfig;
import com.tridium.bacnetAws.datatypes.BRestoreConfig;
import com.tridium.bacnetAws.job.BBackupJob;
import com.tridium.bacnetAws.job.BRestoreJob;
import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.web.RestUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.security.BPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;

public final class BacnetAwsServlet
extends HttpServlet {
    private static final Pattern downloadPattern = Pattern.compile("/download/.+");
    private static final Pattern backupPattern = Pattern.compile("/backup");
    private static final Pattern restorePattern = Pattern.compile("/restore");
    private static final Logger log = Logger.getLogger("bacnetAws");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block7: {
            resp.setHeader("transfer-encoding", "chunked");
            resp.setContentType("application/octet-stream");
            Context cx = (Context)req.getAttribute("niagara.context");
            RestUtil util = new RestUtil(req, resp);
            try {
                if (util.matches(downloadPattern)) {
                    util.respondNoCache();
                    String ord = SlotPath.unescape((String)util.get(1));
                    String fileName = SlotPath.unescape((String)util.get(2));
                    resp.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                    BBackupJob job = (BBackupJob)BOrd.make((String)("station:|" + ord)).get(null, cx);
                    job.setResponse(resp);
                    while (job.isAlive()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            throw new ServletException("InterruptedException while waiting for Job To Complete", (Throwable)e);
                        }
                    }
                } else {
                    resp.sendError(404);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "ServletException", e);
                if (e instanceof ServletException || e instanceof IOException) break block7;
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block18: {
            try {
                BWebService webService;
                Context cx = (Context)req.getAttribute("niagara.context");
                RestUtil util = new RestUtil(req, resp);
                if (req.getProtocol().equals("http") && (webService = (BWebService)Sys.getService((Type)BWebService.TYPE)).getRequireHttpsForPasswords()) {
                    throw new Exception("HTTPS connection required for setting passwords.");
                }
                try (Writer writer = null;){
                    if (util.matches(backupPattern)) {
                        util.respondNoCache();
                        String networkOrd = req.getParameter("networkOrd");
                        String valueEncoding = req.getParameter("config");
                        String password = req.getParameter("password");
                        BBackupConfig c = (BBackupConfig)BsonDecoderPlugin.unmarshal((String)valueEncoding, (Context)cx).asComplex();
                        c.set("password", (BValue)BPassword.make((String)password));
                        BBacnetAwsNetwork network = (BBacnetAwsNetwork)BOrd.make((String)networkOrd).relativizeToSession().get();
                        BBackupJob job = new BBackupJob(network, c, true);
                        BOrd ord = job.submit(cx);
                        writer = resp.getWriter();
                        writer.write(SlotPath.escape((String)ord.toString()));
                        writer.write("\n");
                        writer.write(SlotPath.escape((String)c.getDeviceDirectoryName()));
                        break block18;
                    }
                    if (util.matches(restorePattern)) {
                        util.respondNoCache();
                        InputStream inputStream = null;
                        for (Part part : req.getParts()) {
                            String name = part.getName();
                            if (!name.equals("file")) continue;
                            if (inputStream != null) {
                                log.warning("More than one 'file' specified in restore operation, closing previous stream");
                                try {
                                    inputStream.close();
                                }
                                catch (Exception network) {
                                    // empty catch block
                                }
                            }
                            inputStream = part.getInputStream();
                        }
                        BRestoreConfig c = null;
                        BBacnetAwsNetwork network = null;
                        try {
                            String networkOrd = req.getParameter("networkOrd");
                            String valueEncoding = req.getParameter("config");
                            String password = req.getParameter("password");
                            c = (BRestoreConfig)BsonDecoderPlugin.unmarshal((String)valueEncoding, (Context)cx).asComplex();
                            c.set("password", (BValue)BPassword.make((String)password));
                            network = (BBacnetAwsNetwork)BOrd.make((String)networkOrd).relativizeToSession().get();
                        }
                        catch (Exception rethrow) {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Exception valueEncoding) {
                                    // empty catch block
                                }
                            }
                            throw rethrow;
                        }
                        BRestoreJob job = new BRestoreJob(network, c, inputStream);
                        BOrd ord = job.submit(cx);
                        writer = resp.getWriter();
                        writer.write(ord.toString());
                        break block18;
                    }
                    resp.sendError(404);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "ServletException", e);
                if (e instanceof ServletException || e instanceof IOException) break block18;
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

