/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.report.ux.configuration;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBitString;
import javax.baja.sys.BObject;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BDaysOfWeekBits;

@NiagaraType
public final class BAnalyticDaysOfWeekBits
extends BBitString {
    public static final BAnalyticDaysOfWeekBits DEFAULT = new BAnalyticDaysOfWeekBits(127);
    public static final BAnalyticDaysOfWeekBits EMPTY = new BAnalyticDaysOfWeekBits(0);
    public static final BAnalyticDaysOfWeekBits ALL = DEFAULT;
    private BDaysOfWeekBits daysOfWeekBits = BDaysOfWeekBits.DEFAULT;
    public static final Type TYPE = Sys.loadType(BAnalyticDaysOfWeekBits.class);

    public static BAnalyticDaysOfWeekBits make(boolean v) {
        if (v) {
            return ALL;
        }
        return EMPTY;
    }

    public static BAnalyticDaysOfWeekBits make(int bits) {
        if (bits == ALL.getBits()) {
            return ALL;
        }
        if (bits == EMPTY.getBits()) {
            return EMPTY;
        }
        return (BAnalyticDaysOfWeekBits)new BAnalyticDaysOfWeekBits(bits).intern();
    }

    private BAnalyticDaysOfWeekBits(int bits) {
        this.daysOfWeekBits = BDaysOfWeekBits.make((int)bits);
    }

    private BAnalyticDaysOfWeekBits(BDaysOfWeekBits daysOfWeekBits) {
        this.daysOfWeekBits = daysOfWeekBits;
    }

    public boolean includes(BAbsTime absTime) {
        return this.includes(absTime.getWeekday());
    }

    public int getBits() {
        return this.daysOfWeekBits.getBits();
    }

    public boolean includes(BWeekday weekday) {
        return (this.daysOfWeekBits.getBits() & 1 << weekday.getOrdinal()) != 0;
    }

    public boolean getBit(int ordinal) {
        return (this.daysOfWeekBits.getBits() & ordinal) != 0;
    }

    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    public int[] getOrdinals() {
        return this.daysOfWeekBits.getOrdinals();
    }

    public boolean isOrdinal(int ordinal) {
        return this.daysOfWeekBits.isOrdinal(ordinal);
    }

    public String getTag(int ordinal) {
        return this.daysOfWeekBits.getTag(ordinal);
    }

    public String getDisplayTag(int ordinal, Context cx) {
        return this.daysOfWeekBits.getDisplayTag(ordinal, cx);
    }

    public BBitString getInstance(int[] ordinals) {
        int mask = 0;
        for (int i = 0; i < ordinals.length; ++i) {
            mask |= ordinals[i];
        }
        return BAnalyticDaysOfWeekBits.make(mask);
    }

    public boolean isTag(String tag) {
        return this.daysOfWeekBits.isTag(tag);
    }

    public int tagToOrdinal(String tag) {
        return this.daysOfWeekBits.tagToOrdinal(tag);
    }

    public boolean isEmpty() {
        return this.daysOfWeekBits.getBits() == 0;
    }

    public boolean isEveryDay() {
        return this.daysOfWeekBits.getBits() == ALL.getBits();
    }

    public String getEmptyTag() {
        return "none";
    }

    public int hashCode() {
        return this.daysOfWeekBits.getBits();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BAnalyticDaysOfWeekBits) {
            return ((BAnalyticDaysOfWeekBits)((Object)obj)).getBits() == this.daysOfWeekBits.getBits();
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.daysOfWeekBits.getBits());
    }

    public BObject decode(DataInput in) throws IOException {
        return BAnalyticDaysOfWeekBits.make(in.readInt());
    }

    public String encodeToString() {
        return Integer.toHexString(this.daysOfWeekBits.getBits());
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return BAnalyticDaysOfWeekBits.make(Integer.parseInt(s, 16));
        }
        catch (Exception e) {
            throw new IOException("Invalid bits: " + s);
        }
    }

    public String toString(Context cx) {
        if (this.daysOfWeekBits.getBits() == 0) {
            return "{}";
        }
        StringBuilder s = new StringBuilder();
        s.append('{');
        if (this.includes(BWeekday.sunday)) {
            s.append(BWeekday.sunday.getShortDisplayTag(cx));
            s.append(" ");
        }
        if (this.includes(BWeekday.monday)) {
            s.append(BWeekday.monday.getShortDisplayTag(cx));
            s.append(" ");
        }
        if (this.includes(BWeekday.tuesday)) {
            s.append(BWeekday.tuesday.getShortDisplayTag(cx));
            s.append(" ");
        }
        if (this.includes(BWeekday.wednesday)) {
            s.append(BWeekday.wednesday.getShortDisplayTag(cx));
            s.append(" ");
        }
        if (this.includes(BWeekday.thursday)) {
            s.append(BWeekday.thursday.getShortDisplayTag(cx));
            s.append(" ");
        }
        if (this.includes(BWeekday.friday)) {
            s.append(BWeekday.friday.getShortDisplayTag(cx));
            s.append(" ");
        }
        if (this.includes(BWeekday.saturday)) {
            s.append(BWeekday.saturday.getShortDisplayTag(cx));
            s.append(" ");
        }
        s.append('}');
        return s.toString();
    }

    public Type getType() {
        return TYPE;
    }
}

