/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.table;

import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.snmptypes.SnmpExceptionVar;
import com.tridium.snmp.snmptypes.SnmpNull;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import com.tridium.snmp.table.BSnmpSequence;
import com.tridium.snmp.table.BSnmpSequenceElement;
import com.tridium.snmp.table.BSnmpTableRow;
import com.tridium.snmp.table.BSnmpTableWalkMibJob;
import com.tridium.snmp.util.DisplayHintParser;
import com.tridium.snmp.util.SnmpUtil;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="objectIdentifier", type="String", defaultValue=""), @NiagaraProperty(name="sequence", type="BSnmpSequence", defaultValue="new BSnmpSequence()"), @NiagaraProperty(name="enablePoll", type="boolean", defaultValue="true")})
@NiagaraActions(value={@NiagaraAction(name="walkMib", returnType="BOrd"), @NiagaraAction(name="update")})
public class BSnmpTable
extends BComponent {
    @Generated
    public static final Property objectIdentifier = BSnmpTable.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property sequence = BSnmpTable.newProperty((int)0, (BValue)new BSnmpSequence(), null);
    @Generated
    public static final Property enablePoll = BSnmpTable.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action walkMib = BSnmpTable.newAction((int)0, null);
    @Generated
    public static final Action update = BSnmpTable.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSnmpTable.class);
    BSnmpDevice device = null;
    private static final BIcon icon = BIcon.make((String)"module://icons/x16/widgets/table.png");
    public static BasicContext noWrite = new BasicContext();

    @Generated
    public String getObjectIdentifier() {
        return this.getString(objectIdentifier);
    }

    @Generated
    public void setObjectIdentifier(String v) {
        this.setString(objectIdentifier, v, null);
    }

    @Generated
    public BSnmpSequence getSequence() {
        return (BSnmpSequence)this.get(sequence);
    }

    @Generated
    public void setSequence(BSnmpSequence v) {
        this.set(sequence, (BValue)v, null);
    }

    @Generated
    public boolean getEnablePoll() {
        return this.getBoolean(enablePoll);
    }

    @Generated
    public void setEnablePoll(boolean v) {
        this.setBoolean(enablePoll, v, null);
    }

    @Generated
    public BOrd walkMib() {
        return (BOrd)this.invoke(walkMib, null, null);
    }

    @Generated
    public void update() {
        this.invoke(update, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.snmpDev().registerTable(this);
    }

    public void stopped() throws Exception {
        this.snmpDev().unregisterTable(this);
        super.stopped();
    }

    public BSnmpDevice snmpDev() {
        if (this.device == null) {
            BComplex c = this.getParent();
            while (!(c instanceof BSnmpDevice)) {
                c = c.getParent();
            }
            this.device = (BSnmpDevice)c;
        }
        return this.device;
    }

    public void poll() {
        if (this.getEnablePoll()) {
            this.readTable(null);
        }
    }

    public void doUpdate() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                BSnmpTable.this.readTable(null);
            }
        };
        this.snmpDev().snmpNet().postRequest(r);
    }

    void readTable(BSnmpTableWalkMibJob job) {
        SnmpVarBind[] vars;
        BSnmpDevice dev = this.snmpDev();
        BSnmpNetwork net = dev.snmpNet();
        int maxBindings = dev.getMaxVariableBindingsPerRequest();
        boolean useBulkReq = dev.getSnmpVersion() > 1;
        long[] testOid = SnmpUtil.getLongArray(this.getObjectIdentifier());
        int colNdx = testOid.length + 1;
        BSnmpSequenceElement[] seqElms = this.getSequence().getElements();
        if (useBulkReq) {
            SnmpVarBind vb = new SnmpVarBind(new SnmpOID(testOid), new SnmpNull());
            vars = new SnmpVarBind[]{vb};
        } else {
            vars = new SnmpVarBind[seqElms.length];
            for (int i = 0; i < seqElms.length; ++i) {
                BSnmpSequenceElement se = seqElms[i];
                long[] coid = SnmpUtil.getLongArray(se.getObjectIdentifier());
                SnmpOID oid = new SnmpOID(coid);
                vars[i] = new SnmpVarBind(oid, new SnmpNull());
                if (i != 0) continue;
                testOid = coid;
            }
        }
        BSnmpTableRow[] rows = (BSnmpTableRow[])this.getChildren(BSnmpTableRow.class);
        Hashtable<String, BSnmpTableRow> rowHash = new Hashtable<String, BSnmpTableRow>();
        int cnt = 0;
        int iteration = 0;
        boolean done = false;
        while (!done) {
            int i;
            SnmpPDU msg;
            if (job != null) {
                if (job.walkCanceled) {
                    return;
                }
                job.progress(iteration++);
                if (iteration >= 95) {
                    iteration = 50;
                }
            }
            int firstColNdx = -1;
            if (useBulkReq) {
                msg = new SnmpPDU(dev, 165);
                msg.setMaxRepetitions(maxBindings);
                msg.addVariableBinding(vars[0]);
            } else {
                msg = new SnmpPDU(dev, 161);
                for (int i2 = 0; i2 < maxBindings && i2 < vars.length; ++i2) {
                    if (cnt == 0) {
                        firstColNdx = i2;
                    }
                    msg.addVariableBinding(vars[cnt++]);
                    if (cnt < vars.length) continue;
                    cnt = 0;
                }
            }
            SnmpPDU pdu = net.sendAsyncRequest(msg, (int)dev.getResponseTimeout().getMillis(), dev.getRetryCount());
            if (pdu == null) {
                net.log().severe("poll failed in " + this.getName());
                return;
            }
            Vector<SnmpVarBind> vals = pdu.getVariableBindings();
            for (i = 0; i < vals.size(); ++i) {
                SnmpVarBind vb = vals.get(i);
                SnmpVar var = vb.getVariable();
                long[] oida = vb.getObjectID().toLongArray();
                if (var instanceof SnmpExceptionVar) {
                    done = true;
                    break;
                }
                if ((useBulkReq || i == firstColNdx) && !this.isOidForMyTable(testOid, oida)) {
                    done = true;
                    break;
                }
                int col = (int)oida[colNdx] - 1;
                String rowNdx = SnmpUtil.rowIdFromOid(oida, colNdx);
                vars[useBulkReq ? 0 : col] = vb;
                BSnmpTableRow row = null;
                for (int n = 0; n < rows.length; ++n) {
                    if (!rows[n].getIndex().equals(rowNdx)) continue;
                    row = rows[n];
                    break;
                }
                if (row == null) {
                    Property p = this.add(SlotPath.escape((String)("row" + rowNdx)), (BValue)this.createRow(rowNdx, seqElms), null);
                    row = (BSnmpTableRow)this.get(p);
                    rows = (BSnmpTableRow[])this.getChildren(BSnmpTableRow.class);
                }
                rowHash.put(rowNdx, row);
                BStatusValue sv = (BStatusValue)row.get(SlotPath.escape((String)seqElms[col].getElementName()));
                try {
                    if (sv instanceof BStatusNumeric) {
                        ((BStatusNumeric)sv).setDouble(BStatusNumeric.value, SnmpUtil.getNumeric(var), (Context)noWrite);
                    } else if (sv instanceof BStatusEnum) {
                        BEnumRange range = (BEnumRange)seqElms[col].getFacets().getFacet("range");
                        ((BStatusEnum)sv).set(BStatusEnum.value, (BValue)SnmpUtil.getEnum(var, range), (Context)noWrite);
                    } else if (sv instanceof BStatusBoolean) {
                        int[] oa;
                        BFacets f = seqElms[col].getFacets();
                        BEnumRange range = (BEnumRange)f.getFacet("range");
                        if (range != null && (oa = range.getOrdinals()).length == 2) {
                            String trueText = range.getTag(oa[0]);
                            String falseText = range.getTag(oa[1]);
                            f = BFacets.make((BFacets)f, (BFacets)BFacets.makeBoolean((String)trueText, (String)falseText));
                        }
                        ((BStatusBoolean)sv).setBoolean(BStatusBoolean.value, SnmpUtil.getBoolean(var, f), (Context)noWrite);
                    } else if (sv instanceof BStatusString) {
                        ((BStatusString)sv).setString(BStatusString.value, this.getDisplayValue(var, seqElms[col].getDisplayHint()), (Context)noWrite);
                    }
                    sv.setStatusNull(false);
                    continue;
                }
                catch (Throwable e) {
                    sv.setStatusNull(true);
                }
            }
            for (i = 0; i < vars.length; ++i) {
                vars[i].setVariable(new SnmpNull());
            }
        }
        for (int i = 0; i < rows.length; ++i) {
            if (rowHash.get(rows[i].getIndex()) != null) continue;
            this.remove((BComplex)rows[i]);
        }
    }

    private String getDisplayValue(SnmpVar var, String displayHint) {
        String displayValue = var instanceof SnmpString ? DisplayHintParser.stringDisplay(((SnmpString)var).getRawData(), displayHint) : SnmpUtil.getString(var);
        return displayValue;
    }

    private boolean isOidForMyTable(long[] myOid, long[] aOid) {
        if (aOid.length < myOid.length) {
            return false;
        }
        for (int i = 0; i < myOid.length; ++i) {
            if (aOid[i] == myOid[i]) continue;
            return false;
        }
        return true;
    }

    public BOrd doWalkMib() {
        if (!this.snmpDev().isActive()) {
            throw new LocalizableRuntimeException("snmp", "walkMib.deviceInactive");
        }
        return new BSnmpTableWalkMibJob(this.snmpDev(), this).submit(null);
    }

    private BSnmpTableRow createRow(String rowId, BSnmpSequenceElement[] seqs) {
        BSnmpTableRow row = new BSnmpTableRow();
        row.setIndex(rowId);
        for (int i = 0; i < seqs.length; ++i) {
            int flags;
            BStatusValue elem = seqs[i].getElementType().getInstance();
            int n = flags = seqs[i].getWriteable() ? 0 : 1;
            if (seqs[i].getFacets().isNull()) {
                row.add(SlotPath.escape((String)seqs[i].getElementName()), (BValue)elem, flags);
                continue;
            }
            row.add(SlotPath.escape((String)seqs[i].getElementName()), (BValue)elem, flags, seqs[i].getFacets(), null);
        }
        return row;
    }

    public void updateStatus() {
        try {
            BSnmpDevice dev = this.snmpDev();
            boolean isDown = dev.isDown();
            boolean isFault = dev.isFault();
            boolean isDisabled = dev.isDisabled();
            BSnmpTableRow[] rows = (BSnmpTableRow[])this.getChildren(BSnmpTableRow.class);
            for (int i = 0; i < rows.length; ++i) {
                BStatusValue[] va = (BStatusValue[])rows[i].getChildren(BStatusValue.class);
                for (int n = 0; n < va.length; ++n) {
                    int status;
                    int newStatus = status = va[n].getStatus().getBits();
                    newStatus = isDisabled ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
                    newStatus = isDown ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
                    newStatus = isFault ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
                    if (status == newStatus) continue;
                    va[n].set(BStatusValue.status, (BValue)BStatus.make((int)newStatus), (Context)noWrite);
                }
            }
        }
        catch (Throwable e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

