/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.services;

import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.alarm.BTrapType;
import com.tridium.snmp.services.ComUtil;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import com.tridium.snmp.util.SnmpUtil;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;

public class SnmpReceiveTraps
implements Runnable {
    private boolean done = true;
    private BSnmpNetwork host;
    private DatagramSocket sock;
    private Thread myThread;

    public SnmpReceiveTraps(BSnmpNetwork snmp) {
        this.host = snmp;
    }

    public final void start() {
        try {
            this.sock = new DatagramSocket(this.host.getSnmpReceiveTrapsPort().getBindingPort());
        }
        catch (Exception e) {
            if (this.host != null) {
                this.host.log().severe("SnmpReceiveTraps: unable to create socket on port " + this.host.getSnmpReceiveTrapsPort().getPublicServerPort() + " " + e.toString());
            }
            return;
        }
        if (this.host.log().isLoggable(Level.FINE)) {
            this.host.log().fine("*** Starting SnmpReceiveTraps Service " + this.sock.getLocalPort());
        }
        this.done = false;
        this.myThread = new Thread((Runnable)this, "Snmp:RcvTraps");
        this.myThread.start();
    }

    public final void stop() {
        if (this.host.log().isLoggable(Level.FINE)) {
            this.host.log().fine("*** Stopping SnmpReceiveTraps Service");
        }
        this.done = true;
        if (this.sock != null) {
            this.sock.close();
        }
    }

    @Override
    public void run() {
        if (this.host.log().isLoggable(Level.FINE)) {
            this.host.log().fine("SnmpReceiveTraps thread is running.");
        }
        DatagramPacket pack = new DatagramPacket(new byte[1500], 1500);
        while (!this.done) {
            pack.setLength(1500);
            SnmpPDU pdu = ComUtil.receive(this.host, this.sock, pack);
            if (pdu != null && pdu.getVersion() > 2 || pdu == null || pdu.isFull()) continue;
            try {
                int command = pdu.getCommand() & 0xFF;
                if (command == 164) {
                    this.processTrap(pdu, 1);
                    continue;
                }
                if (command == 167) {
                    this.processTrap(pdu, 2);
                    continue;
                }
                if (!this.host.log().isLoggable(Level.FINE)) continue;
                this.host.log().fine("Received Unprocessable SNMP trap (Command: " + pdu.getCommand() + ")");
            }
            catch (Exception e) {
                if (this.host == null || !this.host.log().isLoggable(Level.FINE)) continue;
                this.host.log().fine("Caught exception in SnmpReceiveTraps: " + e.toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processTrap(SnmpPDU pdu, int version) {
        TrapData map = new TrapData();
        StringBuilder sb = new StringBuilder();
        SnmpVarBind[] vbs = pdu.getVaribleBindingArray();
        BSnmpDevice dev = null;
        if (version == 1) {
            dev = this.host.findDevice(pdu.getSourceIp());
            if (dev == null) return;
            BTrapType trap = dev.getTraps().getTrapTypeByGenericSpecific(pdu.getTrapEnterprise(), pdu.getGenericTrapAsInt(), pdu.getSpecificTrapAsInt());
            if (trap != null) {
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.trapData")), (BObject)BString.make((String)ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.recognizedV1") + " " + dev.getName() + "(" + pdu.getSourceIp() + ")")));
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.name")), (BObject)BString.make((String)ComUtil.insertLineFeeds(trap.getTrapName())));
                sb.append(ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.recognizedV1") + " " + dev.getName() + "(" + pdu.getSourceIp() + "): ") + "\n");
                sb.append(this.localizeText("rcvTraps.strings.name") + "= " + ComUtil.insertLineFeeds(trap.getTrapName()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.variables") + "= \n");
                String[] variables = trap.getVariables();
                for (int i = 0; i < vbs.length; ++i) {
                    if (this.host.log().isLoggable(Level.FINE)) {
                        this.host.log().fine("trap var " + vbs[i].toString());
                    }
                    if (i > 0) {
                        sb.append(", \n");
                    }
                    SnmpOID oid = vbs[i].getObjectID();
                    SnmpVar var = vbs[i].getVariable();
                    if (i < variables.length) {
                        sb.append(variables[i]);
                        sb.append(ComUtil.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                        map.put(SnmpReceiveTraps.makeValidName(variables[i]), (BObject)BString.make((String)ComUtil.insertLineFeeds(var.toStringValue())));
                        continue;
                    }
                    sb.append(this.localizeText("rcvTraps.strings.variables") + "_" + i);
                    sb.append(ComUtil.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                    map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.variables") + "_" + i), (BObject)BString.make((String)ComUtil.insertLineFeeds(var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")")));
                }
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.description")), (BObject)BString.make((String)ComUtil.insertLineFeeds(trap.getDescription())));
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.reference")), (BObject)BString.make((String)ComUtil.insertLineFeeds(trap.getReference())));
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.enterprise")), (BObject)BString.make((String)ComUtil.insertLineFeeds(pdu.getTrapEnterprise())));
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.agentAddr")), (BObject)BString.make((String)ComUtil.insertLineFeeds(pdu.getAgentAddr())));
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.generic")), (BObject)BString.make((String)ComUtil.insertLineFeeds(pdu.getGenericTrap())));
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.specific")), (BObject)BString.make((String)ComUtil.insertLineFeeds(pdu.getSpecificTrap())));
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.timestamp")), (BObject)BString.make((String)ComUtil.insertLineFeeds(pdu.getTrapTimeStamp())));
                sb.append("; \n" + this.localizeText("rcvTraps.strings.description") + "= " + ComUtil.insertLineFeeds(trap.getDescription()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.reference") + "=" + ComUtil.insertLineFeeds(trap.getReference()) + "; \n");
                sb.append("[" + this.localizeText("rcvTraps.strings.details") + "= \n");
                sb.append(this.localizeText("rcvTraps.strings.enterprise") + ": " + ComUtil.insertLineFeeds(pdu.getTrapEnterprise()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.agentAddr") + ": " + ComUtil.insertLineFeeds(pdu.getAgentAddr()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.generic") + ": " + ComUtil.insertLineFeeds(pdu.getGenericTrap()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.specific") + ": " + ComUtil.insertLineFeeds(pdu.getSpecificTrap()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.timestamp") + ": " + ComUtil.insertLineFeeds(pdu.getTrapTimeStamp()) + "]");
            } else {
                if (dev.getTraps().getIgnoreUnrecognizedTraps()) {
                    return;
                }
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.trapData")), (BObject)BString.make((String)ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.unrecognizedV1") + " " + dev.getName() + "(" + pdu.getSourceIp() + ")")));
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.enterprise")), (BObject)BString.make((String)ComUtil.insertLineFeeds(pdu.getTrapEnterprise())));
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.agentAddr")), (BObject)BString.make((String)ComUtil.insertLineFeeds(pdu.getAgentAddr())));
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.generic")), (BObject)BString.make((String)ComUtil.insertLineFeeds(pdu.getGenericTrap())));
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.specific")), (BObject)BString.make((String)ComUtil.insertLineFeeds(pdu.getSpecificTrap())));
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.timestamp")), (BObject)BString.make((String)ComUtil.insertLineFeeds(pdu.getTrapTimeStamp())));
                sb.append(ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.unrecognizedV1") + " " + dev.getName() + "(" + pdu.getSourceIp() + "): ") + "\n");
                sb.append(this.localizeText("rcvTraps.strings.details") + "= \n");
                sb.append(this.localizeText("rcvTraps.strings.enterprise") + ": " + ComUtil.insertLineFeeds(pdu.getTrapEnterprise()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.agentAddr") + ": " + ComUtil.insertLineFeeds(pdu.getAgentAddr()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.generic") + ": " + ComUtil.insertLineFeeds(pdu.getGenericTrap()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.specific") + ": " + ComUtil.insertLineFeeds(pdu.getSpecificTrap()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.timestamp") + ": " + ComUtil.insertLineFeeds(pdu.getTrapTimeStamp()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.varbinds") + ": \n");
                for (int i = 0; i < vbs.length; ++i) {
                    if (this.host.log().isLoggable(Level.FINE)) {
                        this.host.log().fine("trap var " + vbs[i].toString());
                    }
                    if (i > 0) {
                        sb.append(", \n");
                    }
                    SnmpOID oid = vbs[i].getObjectID();
                    SnmpVar var = vbs[i].getVariable();
                    sb.append(this.localizeText("rcvTraps.strings.varbinds") + "_" + i);
                    sb.append(ComUtil.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                    map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.varbinds") + "_" + i), (BObject)BString.make((String)ComUtil.insertLineFeeds(var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")")));
                }
            }
        } else {
            int i;
            dev = this.host.findDevice(pdu.getSourceIp());
            if (dev == null) return;
            BTrapType trap = null;
            for (i = 0; i < vbs.length; ++i) {
                if (!vbs[i].getObjectID().equals(new SnmpOID("1.3.6.1.6.3.1.1.4.1.0")) || !(vbs[i].getVariable() instanceof SnmpOID)) continue;
                trap = dev.getTraps().getTrapTypeByOID((SnmpOID)vbs[i].getVariable());
            }
            if (trap != null) {
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.trapData")), (BObject)BString.make((String)ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.recognizedV2") + " " + dev.getName() + "(" + pdu.getSourceIp() + ")")));
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.name")), (BObject)BString.make((String)ComUtil.insertLineFeeds(trap.getTrapName() + "(" + SnmpUtil.longArrayToString(trap.getOid()) + ")")));
                sb.append(ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.recognizedV2") + " " + dev.getName() + "(" + pdu.getSourceIp() + "): ") + "\n");
                sb.append(ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.name") + "= " + trap.getTrapName() + "(" + SnmpUtil.longArrayToString(trap.getOid()) + "); ") + "\n");
                sb.append(this.localizeText("rcvTraps.strings.objects") + "= \n");
                String[] variables = trap.getVariables();
                int count = 0;
                for (int i2 = 0; i2 < vbs.length; ++i2) {
                    SnmpVar var;
                    SnmpOID oid;
                    if (this.host.log().isLoggable(Level.FINE)) {
                        this.host.log().fine("trap var " + vbs[i2].toString());
                    }
                    if (vbs[i2].getObjectID().equals(new SnmpOID("1.3.6.1.6.3.1.1.4.1.0")) && vbs[i2].getVariable() instanceof SnmpOID) continue;
                    if (i2 > 0) {
                        sb.append(", \n");
                    }
                    if (vbs[i2].getObjectID().equals(new SnmpOID("1.3.6.1.2.1.1.3.0"))) {
                        oid = vbs[i2].getObjectID();
                        var = vbs[i2].getVariable();
                        sb.append(ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.sysUpTime") + "= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                        map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.sysUpTime")), (BObject)BString.make((String)ComUtil.insertLineFeeds(var.toStringValue())));
                        ++count;
                        continue;
                    }
                    oid = vbs[i2].getObjectID();
                    var = vbs[i2].getVariable();
                    if (count < variables.length) {
                        sb.append(variables[count]);
                        sb.append(ComUtil.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                        map.put(SnmpReceiveTraps.makeValidName(variables[++count - 1]), (BObject)BString.make((String)ComUtil.insertLineFeeds(var.toStringValue())));
                        continue;
                    }
                    sb.append(this.localizeText("rcvTraps.strings.objects") + "_" + i2);
                    sb.append(ComUtil.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                    map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.objects") + "_" + i2), (BObject)BString.make((String)ComUtil.insertLineFeeds(var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")")));
                }
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.description")), (BObject)BString.make((String)ComUtil.insertLineFeeds(trap.getDescription())));
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.reference")), (BObject)BString.make((String)ComUtil.insertLineFeeds(trap.getReference())));
                sb.append("; \n" + this.localizeText("rcvTraps.strings.description") + "= " + ComUtil.insertLineFeeds(trap.getDescription()) + "; \n");
                sb.append(this.localizeText("rcvTraps.strings.reference") + "= " + ComUtil.insertLineFeeds(trap.getReference()));
            } else {
                if (dev.getTraps().getIgnoreUnrecognizedTraps()) {
                    return;
                }
                map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.trapData")), (BObject)BString.make((String)ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.unrecognizedV2") + " " + dev.getName() + "(" + pdu.getSourceIp() + ")")));
                sb.append(ComUtil.insertLineFeeds(this.localizeText("rcvTraps.strings.unrecognizedV2") + " " + dev.getName() + "(" + pdu.getSourceIp() + "): ") + "\n");
                sb.append(this.localizeText("rcvTraps.strings.objects") + "= \n");
                for (i = 0; i < vbs.length; ++i) {
                    if (this.host.log().isLoggable(Level.FINE)) {
                        this.host.log().fine("trap var " + vbs[i].toString());
                    }
                    if (i > 0) {
                        sb.append(", \n");
                    }
                    SnmpOID oid = vbs[i].getObjectID();
                    SnmpVar var = vbs[i].getVariable();
                    sb.append(this.localizeText("rcvTraps.strings.objects") + "_" + i);
                    sb.append(ComUtil.insertLineFeeds("= " + var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")"));
                    map.put(SnmpReceiveTraps.makeValidName(this.localizeText("rcvTraps.strings.objects") + "_" + i), (BObject)BString.make((String)ComUtil.insertLineFeeds(var.toStringValue() + " (" + this.localizeText("rcvTraps.strings.oid") + ": " + oid.toString() + ")")));
                }
            }
        }
        dev.getTraps().issueTrapAlert(BFacets.make((String[])map.getKeys(), (BIDataValue[])map.getValues()), sb.toString());
    }

    private static String makeValidName(String name) {
        if (!SlotPath.isValidName((String)name)) {
            name = SlotPath.escape((String)name);
        }
        return name;
    }

    public DatagramSocket getSocket() {
        return this.sock;
    }

    private String localizeText(String key) {
        return this.host.getLexicon().getText(key);
    }

    private class TrapData {
        private String[] keys = null;
        private BIDataValue[] values = null;

        public void put(String key, BObject value) {
            int nextIndex = 0;
            if (this.keys == null || this.values == null) {
                this.keys = new String[1];
                this.values = new BIDataValue[1];
                this.keys[nextIndex] = key;
                this.values[nextIndex] = (BIDataValue)value;
                return;
            }
            nextIndex = this.keys.length;
            String[] temp1 = new String[nextIndex + 1];
            System.arraycopy(this.keys, 0, temp1, 0, nextIndex);
            temp1[nextIndex] = key;
            this.keys = temp1;
            BIDataValue[] temp2 = new BIDataValue[nextIndex + 1];
            System.arraycopy(this.values, 0, temp2, 0, nextIndex);
            temp2[nextIndex] = (BIDataValue)value;
            this.values = temp2;
        }

        public String[] getKeys() {
            return this.keys;
        }

        public BIDataValue[] getValues() {
            return this.values;
        }
    }
}

