/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.services;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.snmptypes.SnmpPDU;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.logging.Level;

public class ComUtil {
    public static String insertLineFeeds(String data) {
        if (data.length() <= 75) {
            return data;
        }
        StringBuilder sbuf = new StringBuilder();
        String remainder = new String(data);
        while (remainder.length() > 75) {
            int finishIndex = remainder.indexOf(" ", 75);
            if (finishIndex < 0) {
                finishIndex = 100;
            }
            if (finishIndex > remainder.length()) {
                sbuf.append(remainder);
                return sbuf.toString();
            }
            String line = remainder.substring(0, finishIndex + 1);
            sbuf.append(line);
            sbuf.append("\n");
            remainder = remainder.substring(finishIndex, remainder.length());
        }
        if (remainder.length() > 0) {
            sbuf.append(remainder);
        }
        return sbuf.toString();
    }

    public static void send(BSnmpNetwork snmp, SnmpPDU pdu) {
        ComUtil.send(snmp, pdu, snmp.getSocket());
    }

    public static void send(BSnmpNetwork snmp, SnmpPDU pdu, DatagramSocket sock) {
        block3: {
            byte[] a = pdu.getData();
            if (snmp.log().isLoggable(Level.FINE)) {
                snmp.log().fine("Sending PDU: " + pdu.getDestinationIp() + ":" + pdu.getRemotePort() + "\n" + pdu);
                ComUtil.printReport(a, a.length);
            }
            try {
                DatagramPacket pack = new DatagramPacket(a, a.length, pdu.getDestinationIp(), pdu.getRemotePort());
                sock.send(pack);
            }
            catch (Exception e) {
                if (snmp == null || !snmp.log().isLoggable(Level.FINE)) break block3;
                snmp.log().fine("Could not send packet: " + e);
            }
        }
    }

    public static void printReport(byte[] a, int len) {
        for (int i = 0; i < len; ++i) {
            System.out.print(Integer.toString(a[i] >> 4 & 0xF, 16) + Integer.toString(a[i] & 0xF, 16) + " ");
            if (i % 20 != 19) continue;
            System.out.println();
        }
        System.out.println();
    }

    public static SnmpPDU receive(BSnmpNetwork snmp, DatagramSocket sock, DatagramPacket pack) {
        SnmpPDU p;
        try {
            sock.receive(pack);
            byte[] a = pack.getData();
            if (snmp.log().isLoggable(Level.FINE)) {
                snmp.log().fine("Received packet \n");
                ComUtil.printReport(a, pack.getLength());
            }
            p = new SnmpPDU(a);
            if (pack.getLength() >= a.length) {
                p.setFull(true);
            } else {
                p.setFull(false);
            }
            p.setRemotePort(pack.getPort());
            p.setSourceIp(pack.getAddress());
        }
        catch (Throwable e) {
            if (snmp != null && snmp.log().isLoggable(Level.FINE)) {
                snmp.log().fine("\n SnmpUtil.receive() exception " + e);
            }
            return null;
        }
        if (snmp.log().isLoggable(Level.FINE)) {
            snmp.log().fine("Received from: " + pack.getAddress() + ":" + pack.getPort() + "\n" + p);
        }
        return p;
    }
}

