/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.enums.BSnmpAccessEnum;
import com.tridium.snmp.export.BSnmpExportFolder;
import com.tridium.snmp.mib.GenericMib;
import com.tridium.snmp.mib.MibAlarmTable;
import com.tridium.snmp.mib.MibIISystem;
import com.tridium.snmp.mib.MibPointTable;
import com.tridium.snmp.mib.NiagObject;
import com.tridium.snmp.mib.TridiumStation;
import com.tridium.snmp.mib.table.PointContainer;
import com.tridium.snmp.mib.table.PointTable;
import com.tridium.snmp.mib.table.TableEntry;
import com.tridium.snmp.object.BSnmpObjectExt;
import com.tridium.snmp.util.LocalToMib;

public class TridiumMib
extends GenericMib {
    public static final int TRIDIUM_ENTERPRISE = 4131;
    public static final String TRIDIUM = "1.3.6.1.4.1.4131";
    public static final String TRIDIUM_STATION = "1.3.6.1.4.1.4131.1";
    public static final String TRIDIUM_VERSION = "1.3.6.1.4.1.4131.1.1.0";
    public static final String TRIDIUM_ACTION = "1.3.6.1.4.1.4131.1.2.0";
    public static final String TRIDIUM_ALARM_TABLE = "1.3.6.1.4.1.4131.1.3";
    public static final String TRIDIUM_TIME_STAMP = "1.3.6.1.4.1.4131.1.3.1.1";
    public static final String TRIDIUM_UUID = "1.3.6.1.4.1.4131.1.3.1.2";
    public static final String TRIDIUM_SOURCE_STATE = "1.3.6.1.4.1.4131.1.3.1.3";
    public static final String TRIDIUM_ACK_STATE = "1.3.6.1.4.1.4131.1.3.1.4";
    public static final String TRIDIUM_ACK_REQUIRED = "1.3.6.1.4.1.4131.1.3.1.5";
    public static final String TRIDIUM_SOURCE = "1.3.6.1.4.1.4131.1.3.1.6";
    public static final String TRIDIUM_ALARM_CLASS = "1.3.6.1.4.1.4131.1.3.1.7";
    public static final String TRIDIUM_PRIORITY = "1.3.6.1.4.1.4131.1.3.1.8";
    public static final String TRIDIUM_NORMAL_TIME = "1.3.6.1.4.1.4131.1.3.1.9";
    public static final String TRIDIUM_ACK_TIME = "1.3.6.1.4.1.4131.1.3.1.10";
    public static final String TRIDIUM_USER = "1.3.6.1.4.1.4131.1.3.1.11";
    public static final String TRIDIUM_ALARM_DATA = "1.3.6.1.4.1.4131.1.3.1.12";
    public static final String TRIDIUM_ALARM_TRANSITION = "1.3.6.1.4.1.4131.1.3.1.13";
    public static final String TRIDIUM_LAST_UPDATE = "1.3.6.1.4.1.4131.1.3.1.14";
    public static final String TRIDIUM_INPUT_TABLE = "1.3.6.1.4.1.4131.1.4";
    public static final String TRIDIUM_INPUT_INDEX = "1.3.6.1.4.1.4131.1.4.1.1";
    public static final String TRIDIUM_INPUT_NAME = "1.3.6.1.4.1.4131.1.4.1.2";
    public static final String TRIDIUM_INPUT_VALUE = "1.3.6.1.4.1.4131.1.4.1.3";
    public static final String TRIDIUM_OUTPUT_TABLE = "1.3.6.1.4.1.4131.1.5";
    public static final String TRIDIUM_OUTPUT_INDEX = "1.3.6.1.4.1.4131.1.5.1.1";
    public static final String TRIDIUM_OUTPUT_NAME = "1.3.6.1.4.1.4131.1.5.1.2";
    public static final String TRIDIUM_OUTPUT_VALUE = "1.3.6.1.4.1.4131.1.5.1.3";
    public static final String TRIDIUM_EXPORT_TABLE = "1.3.6.1.4.1.4131.1.6";
    public static final String TRIDIUM_OBJECT_TABLE = "1.3.6.1.4.1.4131.1.7";
    public static final String TRIDIUM_SNMPV2_TRAP = "1.3.6.1.4.1.4131.1.8.1";
    private static BSnmpAccessEnum RW = BSnmpAccessEnum.readWrite;
    private static BSnmpAccessEnum RO = BSnmpAccessEnum.readOnly;

    public TridiumMib(BSnmpNetwork snmp) {
        super(snmp);
        this.init(snmp);
    }

    protected void init(BSnmpNetwork s) {
        this.addOidEntry("1.3.6.1.2.1.1.1.0", 3, "mandatory", RO, new MibIISystem(s), "System Description", "The System Description");
        this.addOidEntry("1.3.6.1.2.1.1.2.0", 3, "mandatory", RO, new MibIISystem(s), "Object ID", "The Object ID");
        this.addOidEntry("1.3.6.1.2.1.1.3.0", 3, "mandatory", RO, new MibIISystem(s), "System up time", "The System Up Time");
        this.addOidEntry("1.3.6.1.2.1.1.4.0", 3, "mandatory", RO, new MibIISystem(s), "contact", "The Contact");
        this.addOidEntry("1.3.6.1.2.1.1.5.0", 3, "mandatory", RW, new MibIISystem(s), "System Name", "The System Name");
        this.addOidEntry("1.3.6.1.2.1.1.6.0", 3, "mandatory", RW, new MibIISystem(s), "System location", "The System Location");
        this.addOidEntry("1.3.6.1.2.1.1.7.0", 3, "mandatory", RO, new MibIISystem(s), "System Services", "The System Services");
        this.addOidEntry(TRIDIUM_VERSION, 3, "mandatory", RO, new TridiumStation(s), "Tridium Version", "The Tridium Version");
        this.addOidEntry(TRIDIUM_ACTION, 3, "mandatory", RO, new TridiumStation(s), "Tridium Action", "The Tridium Action");
        this.addOidEntry(TRIDIUM_ALARM_TABLE, 4, "mandatory", RO, new MibAlarmTable(s), "Tridium Alarm Table", "The Tridium Alarm Table");
        this.addOidEntry(TRIDIUM_INPUT_TABLE, 4, "mandatory", RO, new MibPointTable(s, TRIDIUM_INPUT_TABLE, true), "Tridium input Table", "The Tridium input Table");
        this.addOidEntry(TRIDIUM_OUTPUT_TABLE, 4, "mandatory", RO, new MibPointTable(s, TRIDIUM_OUTPUT_TABLE, false), "Tridium output Table", "The Tridium output Table");
        this.addTableEntries("Exports", s.getLocalDevice().getExports());
        BSnmpExportFolder[] exs = LocalToMib.getExportFolders(s.getLocalDevice());
        for (int i = 0; i < exs.length; ++i) {
            this.addTableEntries(exs[i].getDisplayName(null), exs[i]);
        }
        this.addObjects(s);
    }

    private void addTableEntries(String name, PointContainer fldr) {
        String ucName = name.substring(0, 1).toUpperCase() + name.substring(1);
        String oid = fldr.getObjectIdentifier() + ".1";
        this.addOidEntry(oid, 4, "mandatory", RO, new MibPointTable(fldr, oid, true), ucName + " input Table", ucName + " input Table");
        oid = fldr.getObjectIdentifier() + ".2";
        this.addOidEntry(oid, 4, "mandatory", RO, new MibPointTable(fldr, oid, false), ucName + " output Table", ucName + " output Table");
    }

    private void addObjects(BSnmpNetwork snmp) {
        PointTable pt = snmp.objects();
        TableEntry[] a = pt.getArray();
        NiagObject nObjs = new NiagObject(snmp, pt);
        for (int i = 0; i < a.length; ++i) {
            BSnmpObjectExt ext = (BSnmpObjectExt)a[i];
            String n = ext.getName();
            String oid = ext.getObjectIdentifier();
            BSnmpAccessEnum ae = ext.isSettablePoint() ? RW : RO;
            this.addOidEntry(oid, 3, "mandatory", ae, nObjs, n, n);
        }
    }

    @Override
    protected String getName() {
        return "TridiumMib";
    }
}

