/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.mib.MibConst;
import com.tridium.snmp.mib.MibTable;
import com.tridium.snmp.mib.table.AlarmEntry;
import com.tridium.snmp.mib.table.TableEntry;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpInt;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;

public class MibAlarmTable
extends MibTable
implements MibConst,
SnmpConst {
    public static final int LEVEL = 10;
    public static final int TIME_STAMP = 1;
    public static final int UUID = 2;
    public static final int SOURCE_STATE = 3;
    public static final int ACK_STATE = 4;
    public static final int ACK_REQUIRED = 5;
    public static final int SOURCE = 6;
    public static final int ALARM_CLASS = 7;
    public static final int PRIORITY = 8;
    public static final int NORMAL_TIME = 9;
    public static final int ACK_TIME = 10;
    public static final int USER = 11;
    public static final int ALARM_DATA = 12;
    public static final int ALARM_TRANSITION = 13;
    public static final int LAST_UPDATE = 14;
    public static final int ALARM_ID = 15;
    public static final int LAST_ID = 15;
    public static final int UNACKED = 1;
    public static final int ACKED = 0;
    public static final int ACK_PENDING = 2;
    private BSnmpNetwork snmp;

    public MibAlarmTable(BSnmpNetwork snmp) {
        this.snmp = snmp;
    }

    @Override
    public SnmpVar getValue(SnmpOID oid) {
        long[] aOid = oid.toLongArray();
        AlarmEntry entry = this.getEntry(aOid);
        if (entry == null) {
            return null;
        }
        SnmpVar var = null;
        try {
            switch ((int)aOid[10]) {
                case 1: {
                    var = new SnmpString(entry.getTimestampString());
                    break;
                }
                case 2: {
                    var = new SnmpString(entry.getUuid());
                    break;
                }
                case 3: {
                    var = new SnmpInt(entry.getSourceState());
                    break;
                }
                case 4: {
                    var = new SnmpInt(entry.getAckState());
                    break;
                }
                case 5: {
                    var = new SnmpInt(entry.getAckRequired());
                    break;
                }
                case 6: {
                    var = new SnmpString(entry.getSource());
                    break;
                }
                case 7: {
                    var = new SnmpString(entry.getAlarmClass());
                    break;
                }
                case 8: {
                    var = new SnmpInt(entry.getPriority());
                    break;
                }
                case 9: {
                    var = new SnmpString(entry.getNormalTime());
                    break;
                }
                case 10: {
                    var = new SnmpString(entry.getAckTime());
                    break;
                }
                case 11: {
                    var = new SnmpString(entry.getUser());
                    break;
                }
                case 12: {
                    var = new SnmpString(entry.getAlarmData());
                    break;
                }
                case 13: {
                    var = new SnmpInt(entry.getAlarmTransition());
                    break;
                }
                case 14: {
                    var = new SnmpString(entry.getLastUpdate());
                    break;
                }
                case 15: {
                    var = new SnmpInt(entry.getAlarmId());
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return var;
    }

    private AlarmEntry getEntry(long[] aOid) {
        if (aOid.length <= 11) {
            return null;
        }
        return this.snmp.alarms().getAlarm((int)aOid[11]);
    }

    @Override
    public int validateForSet(SnmpVarBind varbind) {
        SnmpOID oid = varbind.getObjectID();
        long[] aOid = oid.toLongArray();
        switch ((int)aOid[10]) {
            case 4: {
                try {
                    ((SnmpInt)varbind.getVariable()).intValue();
                }
                catch (Exception e) {
                    return 3;
                }
                if (this.getEntry(aOid) != null) break;
                return 6;
            }
            default: {
                return 6;
            }
        }
        return 0;
    }

    @Override
    public int setValue(SnmpVarBind varbind, SnmpPDU resp) {
        SnmpOID oid = varbind.getObjectID();
        long[] aOid = oid.toLongArray();
        switch ((int)aOid[10]) {
            case 4: {
                int state;
                try {
                    state = ((SnmpInt)varbind.getVariable()).intValue();
                }
                catch (Exception e) {
                    return 3;
                }
                AlarmEntry entry = this.getEntry(aOid);
                if (entry == null) {
                    return 2;
                }
                if (!(state != 0 && state != 2 || entry.isAcked())) {
                    this.snmp.alarms().acknowledge(entry);
                }
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                resp.addVariableBinding(new SnmpVarBind(oid, new SnmpInt(entry.getAckState())));
                break;
            }
            default: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int getObjectLevel() {
        return 10;
    }

    @Override
    public int getLastId() {
        return 15;
    }

    @Override
    public TableEntry getNextEntry(int index) {
        return this.snmp.alarms().getNextEntry(index);
    }

    @Override
    public String getFirstOid() {
        return "1.3.6.1.4.1.4131.1.3.1.1";
    }
}

