/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.messages;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.snmptypes.SnmpPDU;

public class SnmpRequest
implements Runnable {
    protected SnmpPDU msg;
    protected boolean responseExpected;
    protected SnmpPDU response = null;
    protected boolean complete = false;
    protected BSnmpNetwork snmpNet;
    protected int timeout;
    protected int retryCount;

    public SnmpRequest() {
    }

    public SnmpRequest(BSnmpNetwork snmpNet, SnmpPDU msg, int timeout, int retryCount, boolean responseExpected) {
        this.snmpNet = snmpNet;
        this.msg = msg;
        this.timeout = timeout;
        this.retryCount = retryCount;
        this.responseExpected = responseExpected;
    }

    public String toString() {
        return new String("SnmpRequest: " + this.msg);
    }

    @Override
    public void run() {
        this.execute();
    }

    public synchronized void execute() {
        this.response = null;
        try {
            if (this.msg == null) {
                this.snmpNet.log().info("SnmpRequest received null message to send.  Not sending null message.");
                return;
            }
            if (!this.responseExpected) {
                this.snmpNet.snmpDriver().send(this.msg);
            } else {
                this.response = this.snmpNet.snmpDriver().sendRequest(this.msg, this.timeout, this.retryCount);
            }
        }
        catch (RuntimeException e) {
            if (this.snmpNet != null) {
                this.snmpNet.log().severe("SnmpRequest caught exception in execute():  " + e.toString());
            }
            this.complete = true;
            this.notify();
            return;
        }
        this.complete = true;
        this.notify();
    }

    public synchronized SnmpPDU getResponse(int timeout) {
        block3: {
            if (!this.complete) {
                try {
                    this.wait(timeout);
                }
                catch (Exception e) {
                    if (this.snmpNet == null) break block3;
                    this.snmpNet.log().severe("SnmpRequest caught exception in getResponse():  " + e.toString());
                }
            }
        }
        return this.response;
    }
}

