/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.messages;

import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.xprotect.camera.BXProtectCamera;
import com.tridium.xprotect.camera.BXProtectCameraDeviceId;
import com.tridium.xprotect.messages.XProtectReq;
import com.tridium.xprotect.util.XProtectTcpUtil;
import com.tridium.xprotect.util.XProtectVideoStreamUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import org.owasp.encoder.Encode;

public class XProtectVideoStreamReq
extends XProtectReq {
    private static Logger logger = Logger.getLogger(XProtectVideoStreamReq.class.getName());
    public static final int[] SLOW_FWD_RWD_FACTOR_ARRAY = new int[]{90, 80, 70, 60, 50, 40, 30, 20, 10, 5};
    public static final int[] FFWD_RWD_FACTOR_ARRAY = new int[]{200, 400, 600, 800, 1000, 3000, 6000, 60000, 120000, 240000};
    protected MilestonePlaybackInputStream playbackInputStream;
    protected Socket videoSocket;
    private int requestId = -1;
    protected IVideoDestination videoDestination;
    protected BPlaybackParams playbackParams;
    protected BIVideoSource videoSource;

    public Object getTag() {
        return "VideoStream";
    }

    public int getRequestId() {
        if (this.requestId == -1) {
            this.requestId = BXProtectCamera.getNextVideoRequestId();
        }
        return this.requestId;
    }

    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }

    public String getMilestoneCameraId() {
        return ((BXProtectCameraDeviceId)this.getMilestoneCamera().get("videoDeviceId")).getCameraId();
    }

    public void consumeXmlReply(InputStream rawVideoIn) throws IOException {
        int a = rawVideoIn.read();
        int b = rawVideoIn.read();
        int c = rawVideoIn.read();
        int d = rawVideoIn.read();
        while (!(a == 10 && b == 10 || b == 10 && c == 10 || c == 10 && d == 10 || a == 13 && b == 10 && c == 13 && d == 10)) {
            a = b;
            b = c;
            c = d;
            d = rawVideoIn.read();
        }
    }

    public void setVideoSocket(Socket videoSocket) {
        this.videoSocket = videoSocket;
    }

    public IVideoStream makeVideoStream() {
        if (this.videoSocket == null) {
            return null;
        }
        BPlaybackParams playbackParams = this.getPlaybackParams();
        if (playbackParams.getPlaybackType() == BPlaybackTypeEnum.live) {
            try {
                return new MilestoneLiveVideoStream();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        try {
            this.playbackInputStream = new MilestonePlaybackInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new MilestonePlaybackStream();
    }

    protected String getMilestoneCompressionRate() {
        BVideoCompressionEnum videoCompressionEnum = this.playbackParams.getCompression();
        if (videoCompressionEnum == BVideoCompressionEnum.none) {
            return "100";
        }
        if (videoCompressionEnum == BVideoCompressionEnum.low) {
            return "66";
        }
        if (videoCompressionEnum == BVideoCompressionEnum.medium) {
            return "33";
        }
        if (videoCompressionEnum == BVideoCompressionEnum.high) {
            return "100";
        }
        throw new IllegalStateException("Unrecognized videoCompressionEnum: " + videoCompressionEnum);
    }

    protected String getMilestoneFrameRate() {
        BPlaybackParams p = this.getPlaybackParams();
        BVideoFrameRateEnum f = p.getFrameRate();
        if (f == BVideoFrameRateEnum.high) {
            return "full";
        }
        if (f == BVideoFrameRateEnum.medium) {
            return "medium";
        }
        if (f == BVideoFrameRateEnum.low) {
            return "low";
        }
        return "full";
    }

    public byte[] toByteArray() {
        BPlaybackParams playbackParams = this.getPlaybackParams();
        if (playbackParams.getPlaybackType() == BPlaybackTypeEnum.live) {
            return this.getLiveXml().getBytes();
        }
        long millis = playbackParams.getTimeIndex().getMillis();
        return this.getGotoReqXml(millis);
    }

    public boolean toOutputStream(OutputStream out) {
        PrintWriter buf = new PrintWriter(out);
        BPlaybackParams playbackParams = this.getPlaybackParams();
        if (playbackParams.getPlaybackType() == BPlaybackTypeEnum.live) {
            buf.write(this.getLiveXml());
        } else {
            long millis = playbackParams.getTimeIndex().getMillis();
            buf.write(new String(this.getGotoReqXml(millis)));
        }
        buf.flush();
        return false;
    }

    private String getLiveXml() {
        String ret = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodcall><requestid>" + this.getRequestId() + "</requestid><methodname>live</methodname>";
        ret = ret + "<attributes FrameRate=\"" + Encode.forXmlAttribute((String)this.getMilestoneFrameRate()) + "\"/></methodcall>\r\n\r\n";
        return ret;
    }

    private String getStopLiveXml() {
        String ret = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodcall><requestid>" + BXProtectCamera.getNextVideoRequestId() + "</requestid><methodname>stop</methodname></methodcall>\r\n\r\n";
        return ret;
    }

    public String getGotoReqXmlString(long time) {
        String ret = new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodcall><requestid>" + BXProtectCamera.getNextVideoRequestId() + "</requestid><methodname>goto</methodname>");
        ret = ret + "<time>" + time + "</time></methodcall>\r\n\r\n";
        return ret;
    }

    public byte[] getGotoReqXml(long time) {
        return this.getGotoReqXmlString(time).getBytes();
    }

    public BXProtectCamera getMilestoneCamera() {
        return (BXProtectCamera)this.getVideoSource();
    }

    public String getLiveConnectXml(String userName, String password, boolean requestMotionJpegData) {
        return XProtectTcpUtil.getCameraConnectXml(((BXProtectCameraDeviceId)this.getMilestoneCamera().get("videoDeviceId")).getCameraId(), this.getMilestoneCamera().getXprotectDvr().getConnection().getAuthAttributes().getToken(), requestMotionJpegData);
    }

    public void setPlaybackParams(BPlaybackParams playbackParams) {
        this.playbackParams = playbackParams;
    }

    public BPlaybackParams getPlaybackParams() {
        return this.playbackParams;
    }

    public void setVideoDestination(IVideoDestination videoDestination) {
        this.videoDestination = videoDestination;
    }

    public IVideoDestination getVideoDestination() {
        return this.videoDestination;
    }

    public BIVideoSource getVideoSource() {
        return this.videoSource;
    }

    public void setVideoSource(BIVideoSource videoSource) {
        this.videoSource = videoSource;
    }

    public class MilestoneLiveVideoStream
    implements IVideoStream {
        public void closeVideoStream() throws IOException {
            XProtectVideoStreamReq.this.videoSocket.getOutputStream().write(XProtectVideoStreamReq.this.getStopLiveXml().getBytes("ASCII"));
            XProtectVideoStreamReq.this.videoSocket.getOutputStream().flush();
            XProtectVideoStreamReq.this.videoSocket.close();
            XProtectVideoStreamReq.this.videoSocket.close();
        }

        public InputStream getInputStream() {
            try {
                return XProtectVideoStreamReq.this.videoSocket.getInputStream();
            }
            catch (IOException ioe) {
                throw new BajaRuntimeException((Throwable)ioe);
            }
        }

        public BPlaybackParams getPlaybackParams() {
            return XProtectVideoStreamReq.this.getPlaybackParams();
        }
    }

    public class MilestonePlaybackInputStream
    extends InputStream {
        protected InputStream videoSocketInput;
        protected ByteBuffer headerBuf;
        protected int contentLength = -1;
        protected int remainingContentBytes = -1;
        protected long frameMillis = -1L;
        protected long lastRequestedMillis = -1L;
        protected long nextFrameMillis = Long.MIN_VALUE;
        protected long prevFrameMillis = Long.MAX_VALUE;
        protected boolean paused = false;
        protected long ticksBeforeRequestingFrameInPlaybackMode = -1L;
        protected boolean firstHeader = true;
        public long lastDelta = -1L;

        public MilestonePlaybackInputStream() throws IOException {
            this.videoSocketInput = XProtectVideoStreamReq.this.videoSocket.getInputStream();
            this.headerBuf = new ByteBuffer();
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        @Override
        public int read(byte[] buf, int from, int len) throws IOException {
            if (this.paused) {
                return -1;
            }
            if (this.headerBuf.available() > 0) {
                return this.headerBuf.read(buf, from, len);
            }
            if (this.remainingContentBytes > 0) {
                int n = this.videoSocketInput.read(buf, from, len);
                if (n > 0) {
                    this.remainingContentBytes -= n;
                    if (this.remainingContentBytes <= 0) {
                        this.requestNextFrame();
                    }
                } else {
                    this.requestNextFrame();
                }
                return n;
            }
            this.readVideoFrameHeader();
            return this.headerBuf.read(buf, from, len);
        }

        @Override
        public int read() throws IOException {
            if (this.paused) {
                return -1;
            }
            if (this.headerBuf.available() > 0) {
                int retVal = this.headerBuf.read();
                return retVal;
            }
            if (this.remainingContentBytes > 0) {
                if (this.remainingContentBytes == this.contentLength) {
                    // empty if block
                }
                --this.remainingContentBytes;
                int nextJpegByte = this.videoSocketInput.read();
                if (nextJpegByte != -1 && this.remainingContentBytes == 0) {
                    this.requestNextFrame();
                }
                return nextJpegByte;
            }
            this.readVideoFrameHeader();
            int retVal = this.headerBuf.read();
            return retVal;
        }

        public void requestNextFrame() throws IOException {
            long nextMillis = -1L;
            long realTimeSleep = 100L;
            if (this.lastRequestedMillis == -1L) {
                this.lastRequestedMillis = this.frameMillis;
            }
            long rBefore = Clock.ticks();
            if (XProtectVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.play) {
                nextMillis = this.frameMillis + 100L;
                if (nextMillis < this.nextFrameMillis) {
                    nextMillis = this.nextFrameMillis;
                }
                this.ticksBeforeRequestingFrameInPlaybackMode = Clock.ticks();
                realTimeSleep = 0L;
            } else if (XProtectVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.fastFwd) {
                nextMillis = this.frameMillis + (long)FFWD_RWD_FACTOR_ARRAY[XProtectVideoStreamReq.this.getPlaybackParams().getPlaybackSpeed().getOrdinal()];
                if (nextMillis < this.nextFrameMillis) {
                    nextMillis = this.nextFrameMillis;
                }
            } else if (XProtectVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.slowFwd) {
                nextMillis = this.lastRequestedMillis + (long)SLOW_FWD_RWD_FACTOR_ARRAY[XProtectVideoStreamReq.this.getPlaybackParams().getPlaybackSpeed().getOrdinal()];
                if (nextMillis < this.nextFrameMillis && nextMillis - this.nextFrameMillis > 2000L) {
                    nextMillis = this.nextFrameMillis;
                }
            } else if (XProtectVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.fastRew) {
                nextMillis = this.frameMillis - (long)FFWD_RWD_FACTOR_ARRAY[XProtectVideoStreamReq.this.getPlaybackParams().getPlaybackSpeed().getOrdinal()];
                if (nextMillis > this.prevFrameMillis) {
                    nextMillis = this.prevFrameMillis;
                }
            } else if (XProtectVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.slowRew) {
                nextMillis = this.lastRequestedMillis - (long)SLOW_FWD_RWD_FACTOR_ARRAY[XProtectVideoStreamReq.this.getPlaybackParams().getPlaybackSpeed().getOrdinal()];
                if (nextMillis > this.prevFrameMillis && nextMillis - this.prevFrameMillis > 2000L) {
                    nextMillis = this.prevFrameMillis;
                }
            } else {
                if (XProtectVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.pause) {
                    this.paused = true;
                    return;
                }
                throw new IllegalStateException("The program should not have flowed to this line of code.");
            }
            String nextXml = XProtectVideoStreamReq.this.getGotoReqXmlString(nextMillis);
            this.lastRequestedMillis = nextMillis;
            XProtectVideoStreamReq.this.videoSocket.getOutputStream().write(nextXml.getBytes());
            XProtectVideoStreamReq.this.videoSocket.getOutputStream().flush();
            long rAfter = Clock.ticks();
            long sleepTime = realTimeSleep - (rAfter - rBefore);
            if (sleepTime > 10L) {
                try {
                    Thread.sleep(realTimeSleep - (rAfter - rBefore));
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Interrupted while sleeping to simulate the real time Milestone video stream.", e);
                    XProtectVideoStreamUtil.interruptCurrentThread();
                }
            }
        }

        protected String readHeaderLine() throws IOException {
            int b;
            StringBuilder sb = new StringBuilder();
            int b1 = b = this.videoSocketInput.read();
            int b2 = -1;
            while (b1 != 10 || b2 != 13) {
                if (b == -1) {
                    throw new EOFException("End of video input stream while reading line of text.");
                }
                this.headerBuf.write(b);
                sb.append((char)b);
                b = this.videoSocketInput.read();
                b2 = b1;
                b1 = b;
            }
            this.headerBuf.write(b);
            String retVal = sb.toString().trim();
            return retVal;
        }

        public void readVideoFrameHeader() throws IOException {
            this.contentLength = -1;
            this.remainingContentBytes = -1;
            String nextLine = this.readHeaderLine();
            boolean imageResponseLineFound = false;
            if (this.firstHeader) {
                imageResponseLineFound = true;
                this.firstHeader = false;
            }
            while (!imageResponseLineFound || nextLine != null && nextLine.length() > 0) {
                if (nextLine.startsWith("Content-length:")) {
                    this.remainingContentBytes = this.contentLength = Integer.parseInt(nextLine.substring(15).trim());
                } else if (!imageResponseLineFound && nextLine.startsWith("ImageResponse")) {
                    imageResponseLineFound = true;
                } else if (nextLine.startsWith("Current:")) {
                    this.frameMillis = Long.parseLong(nextLine.substring(8).trim());
                } else if (nextLine.startsWith("Next:")) {
                    this.nextFrameMillis = Long.parseLong(nextLine.substring(5).trim());
                } else if (nextLine.startsWith("Prev:")) {
                    this.prevFrameMillis = Long.parseLong(nextLine.substring(5).trim());
                }
                nextLine = this.readHeaderLine();
            }
            if (XProtectVideoStreamReq.this.getPlaybackParams().getPlaybackType() == BPlaybackTypeEnum.play && this.ticksBeforeRequestingFrameInPlaybackMode >= 0L) {
                try {
                    long transitTime = Clock.ticks() - this.ticksBeforeRequestingFrameInPlaybackMode;
                    long sleepTime = this.frameMillis - this.prevFrameMillis - transitTime;
                    if (sleepTime > 1000L) {
                        sleepTime = 1000L;
                    }
                    if (sleepTime > 10L) {
                        Thread.sleep(Math.round((double)sleepTime * 0.8));
                    }
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Interrupted while sleeping to simulated Milestone playback timing.", e);
                    XProtectVideoStreamUtil.interruptCurrentThread();
                }
            }
            if (this.contentLength == -1) {
                throw new IllegalStateException("Error reading milestone image header.");
            }
        }
    }

    public class MilestonePlaybackStream
    implements IVideoStream {
        public void closeVideoStream() throws IOException {
            XProtectVideoStreamReq.this.videoSocket.close();
        }

        public InputStream getInputStream() {
            return XProtectVideoStreamReq.this.playbackInputStream;
        }

        public BPlaybackParams getPlaybackParams() {
            return XProtectVideoStreamReq.this.getPlaybackParams();
        }
    }
}

