/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.messages;

import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import com.tridium.xprotect.messages.XProtectEventRefreshReq;
import com.tridium.xprotect.messages.XProtectRsp;
import com.tridium.xprotect.util.XProtectTcpUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Comparator;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

public class XProtectEventRefreshRsp
extends XProtectRsp {
    protected BVideoEvent[] videoEvents;
    protected int numEvents;
    InputStream in;

    public XProtectEventRefreshRsp(InputStream ins) {
        this.in = ins;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fromInputStream(int numEvents) throws Exception {
        int absNumEvents = Math.abs(numEvents);
        Object[] videoEvents = this.getEventsFor(this.in);
        SortUtil.sort((Object[])videoEvents, (Object[])videoEvents, (Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                BVideoEvent e1 = (BVideoEvent)o1;
                BVideoEvent e2 = (BVideoEvent)o2;
                return e1.getTimestamp().compareTo((Object)e2.getTimestamp());
            }
        });
        if (videoEvents.length > absNumEvents) {
            if (numEvents > 0) {
                this.videoEvents = new BVideoEvent[numEvents];
                System.arraycopy(videoEvents, videoEvents.length - numEvents - 1, this.videoEvents, 0, numEvents);
                return;
            } else {
                if (numEvents >= 0) throw new IllegalStateException("Assummed that numEvents would not be = 0. ");
                this.videoEvents = new BVideoEvent[absNumEvents];
                System.arraycopy(videoEvents, 0, this.videoEvents, 0, absNumEvents);
            }
            return;
        } else {
            this.videoEvents = videoEvents;
        }
    }

    @Override
    public Object getTag() {
        return XProtectEventRefreshReq.EVENT_REFRESH_OBJ;
    }

    public BVideoEvent[] getVideoEvents() {
        return this.videoEvents;
    }

    public BVideoEvent[] getEventsFor(InputStream in) throws Exception {
        in.reset();
        byte[] a = new byte[in.available()];
        ByteArrayInputStream bais = null;
        try {
            in.read(a);
            bais = new ByteArrayInputStream(a);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XElem methodResponse = XProtectTcpUtil.getMilestoneMethodResponseElem(bais);
        String methodName = XProtectTcpUtil.getText(methodResponse, "methodname");
        if (methodName.length() > 0) {
            if ("alarms".equals(methodName)) {
                XElem alarmsElem = XProtectTcpUtil.getElem(methodResponse, "alarms");
                XElem[] alarmElem = alarmsElem.elems("alarm");
                if (alarmElem == null || alarmElem.length == 0) {
                    return new BVideoEvent[0];
                }
                BVideoEvent[] milestoneEvents = new BVideoEvent[alarmElem.length];
                for (int i = 0; i < alarmElem.length; ++i) {
                    milestoneEvents[i] = BVideoEvent.makeOffNormalEvent();
                    milestoneEvents[i].setDescription("MilestoneRecording");
                    milestoneEvents[i].setEventType(BVideoEventTypesEnum.customEvent);
                    try {
                        long startTime = alarmElem[i].getl("startTime");
                        long alarmTime = alarmElem[i].getl("alarmTime");
                        long endTime = alarmElem[i].getl("endTime");
                        milestoneEvents[i].setTimestamp(BAbsTime.make((long)startTime));
                        milestoneEvents[i].setMetaData(BFacets.make((String)"milestoneStartTime", (BIDataValue)BLong.make((long)startTime), (String)"milestoneAlarmTime", (BIDataValue)BLong.make((long)alarmTime), (String)"milestoneEndTime", (BIDataValue)BLong.make((long)endTime)));
                        continue;
                    }
                    catch (XException xe) {
                        xe.printStackTrace();
                    }
                }
                return milestoneEvents;
            }
            throw new Exception("<methodname>...</methodname> text = " + methodName + " expected \"getalarmsaround\"");
        }
        throw new Exception("No <methodname>...</methodname> in reply.");
    }
}

