/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitLon;

import com.tridium.lonworks.local.BPseudoNV;
import com.tridium.lonworks.local.BPseudoNvContainer;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonFloat;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="updateTime", type="BRelTime", defaultValue="BRelTime.make(10000)"), @NiagaraProperty(name="timeStamp", type="BPseudoNV", defaultValue="new BPseudoNV(BLonSnvtType.SNVT_TIME_STAMP, BLonNvDirection.output)")})
@NiagaraAction(name="timerExpired", flags=4)
public class BLonTime
extends BPseudoNvContainer {
    @Generated
    public static final Property updateTime = BLonTime.newProperty((int)0, (BValue)BRelTime.make((long)10000L), null);
    @Generated
    public static final Property timeStamp = BLonTime.newProperty((int)0, (BValue)new BPseudoNV(84, BLonNvDirection.output), null);
    @Generated
    public static final Action timerExpired = BLonTime.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLonTime.class);
    private static final BIcon icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/nvClock.png");
    Clock.Ticket ticket;

    @Generated
    public BRelTime getUpdateTime() {
        return (BRelTime)this.get(updateTime);
    }

    @Generated
    public void setUpdateTime(BRelTime v) {
        this.set(updateTime, (BValue)v, null);
    }

    @Generated
    public BPseudoNV getTimeStamp() {
        return (BPseudoNV)this.get(timeStamp);
    }

    @Generated
    public void setTimeStamp(BPseudoNV v) {
        this.set(timeStamp, (BValue)v, null);
    }

    @Generated
    public void timerExpired() {
        this.invoke(timerExpired, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.initTimer();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    private void initTimer() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (this.getUpdateTime().getMillis() <= 0L) {
            return;
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdateTime(), (Action)timerExpired, null);
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(updateTime)) {
            this.initTimer();
        }
    }

    public void doTimerExpired() {
        BAbsTime curr = BAbsTime.now();
        BLonData ld = this.getTimeStamp().copyData();
        ld.set("year", (BValue)BLonFloat.make((float)curr.getYear()));
        ld.set("month", (BValue)BLonFloat.make((float)(curr.getMonth().getOrdinal() + 1)));
        ld.set("day", (BValue)BLonFloat.make((float)curr.getDay()));
        ld.set("hour", (BValue)BLonFloat.make((float)curr.getHour()));
        ld.set("minute", (BValue)BLonFloat.make((float)curr.getMinute()));
        ld.set("second", (BValue)BLonFloat.make((float)curr.getSecond()));
        this.getTimeStamp().updateData(ld, false);
    }

    public BIcon getIcon() {
        return icon;
    }
}

