/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitLon;

import com.tridium.lonworks.device.NvDev;
import com.tridium.lonworks.local.BPseudoNV;
import com.tridium.lonworks.local.BPseudoNvContainer;
import java.util.HashMap;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonSnvtType;
import javax.baja.lonworks.londata.BLonBoolean;
import javax.baja.lonworks.londata.BLonByteArray;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonDouble;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonFloat;
import javax.baja.lonworks.londata.BLonInteger;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.BLonString;
import javax.baja.lonworks.londata.LonFacetsUtil;
import javax.baja.lonworks.util.SnvtUtil;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="snvt", type="BLonSnvtType", defaultValue="BLonSnvtType.SnvtTemp"), @NiagaraProperty(name="nvo", type="BPseudoNV", defaultValue="new BPseudoNV(BLonSnvtType.SNVT_TEMP, BLonNvDirection.output)")})
public class BLonPoint
extends BPseudoNvContainer {
    @Generated
    public static final Property snvt = BLonPoint.newProperty((int)0, (BValue)BLonSnvtType.SnvtTemp, null);
    @Generated
    public static final Property nvo = BLonPoint.newProperty((int)0, (BValue)new BPseudoNV(39, BLonNvDirection.output), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLonPoint.class);
    private static final BIcon icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/nv.png");
    private static final String DELIMITER = "_";
    private HashMap<Property, BStatusValue> valHash;

    @Generated
    public BLonSnvtType getSnvt() {
        return (BLonSnvtType)this.get(snvt);
    }

    @Generated
    public void setSnvt(BLonSnvtType v) {
        this.set(snvt, (BValue)v, null);
    }

    @Generated
    public BPseudoNV getNvo() {
        return (BPseudoNV)this.get(nvo);
    }

    @Generated
    public void setNvo(BPseudoNV v) {
        this.set(nvo, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p == snvt) {
            this.verifyLonData();
        } else if (p.getType().is(BStatusValue.TYPE)) {
            this.updateSnvt(p, cx);
        }
    }

    public void started() throws Exception {
        super.started();
        this.verifyLonData();
        this.updateSnvt();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.valHash != null) {
            this.valHash.clear();
        }
        this.valHash = null;
    }

    public void checkRename(Property property, String newName, Context context) {
        throw new IllegalNameException("kitLon", "point.rename", null);
    }

    private void updateSnvt(Property p, Context c) {
        this.setNvPrimitive(p, (BStatusValue)this.get(p));
    }

    private void updateSnvt() {
        Property[] pa = this.getPropertiesArray();
        for (int i = 0; i < pa.length; ++i) {
            BValue o = this.get(pa[i]);
            if (!(o instanceof BStatusValue)) continue;
            this.setNvPrimitive(pa[i], (BStatusValue)o);
        }
    }

    private void setNvPrimitive(Property p, BStatusValue val) {
        int n;
        BStatusValue oldVal = this.getValHash().get(p);
        if (oldVal != null && oldVal.equivalent((Object)val)) {
            return;
        }
        this.getValHash().put(p, (BStatusValue)val.newCopy());
        String vName = p.getName();
        BPseudoNV c = this.getNvo();
        while ((n = vName.indexOf(DELIMITER)) > 0) {
            c = (BComponent)c.get(vName.substring(0, n));
            vName = vName.substring(n + 1);
        }
        BLonPrimitive lprim = (BLonPrimitive)c.get(vName);
        BLonElementQualifiers e = LonFacetsUtil.getQualifiers((BFacets)c.getSlot(vName).getFacets());
        if (val instanceof BStatusNumeric) {
            c.set(vName, (BValue)lprim.makeFromDouble(((BStatusNumeric)val).getValue(), e));
        } else if (val instanceof BStatusBoolean) {
            c.set(vName, (BValue)lprim.makeFromBoolean(((BStatusBoolean)val).getValue()));
        } else if (val instanceof BStatusEnum) {
            c.set(vName, (BValue)lprim.makeFromEnum((BEnum)((BStatusEnum)val).getValue()));
        } else if (val instanceof BStatusString) {
            c.set(vName, (BValue)lprim.makeFromString(((BStatusString)val).getValue()));
        }
    }

    private HashMap<Property, BStatusValue> getValHash() {
        if (this.valHash == null) {
            this.valHash = new HashMap();
        }
        return this.valHash;
    }

    private void verifyLonData() {
        int snvt = this.getSnvt().getOrdinal();
        BLonData ld = SnvtUtil.getLonData((int)snvt);
        if (ld == null) {
            return;
        }
        BPseudoNV nvo = this.getNvo();
        if (nvo.getNvProps().getSnvtType() == snvt && nvo.getData().hasEquivalentElements(ld)) {
            return;
        }
        nvo.getNvProps().setSnvtType(snvt);
        nvo.setData(ld);
        Array a = new Array(InputPrimitive.class);
        this.parsePrimitives((Array<InputPrimitive>)a, ld, "");
        InputPrimitive[] prims = (InputPrimitive[])a.trim();
        Context tx = Transaction.start((BComponent)this, (Context)new BasicContext());
        Property[] pa = this.getPropertiesArray();
        for (int i = 0; i < prims.length; ++i) {
            Property prop = this.findAndRemoveProperty(prims[i], pa, tx);
            if (prop != null) continue;
            this.add(prims[i].name, (BValue)prims[i].val, 0, prims[i].facets, tx);
        }
        this.removeRemainingProps(pa, tx);
        this.validateNvLinks(tx);
        try {
            Transaction.end((BComponent)this, (Context)tx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void validateNvLinks(Context tx) {
        Knob[] ka = this.getKnobs((Slot)nvo);
        for (int i = 0; i < ka.length; ++i) {
            LinkCheck lc = NvDev.doNvCheckLink((BComponent)this, (Slot)nvo, (BComponent)ka[i].getSourceComponent(), (Slot)ka[i].getTargetSlot(), null);
            if (lc.isValid()) continue;
            BLink lnk = ka[i].getLink();
            ka[i].getTargetComponent().remove(lnk.getPropertyInParent(), tx);
            lnk.deactivate();
        }
    }

    private void parsePrimitives(Array<InputPrimitive> a, BLonData ld, String pre) {
        SlotCursor c = ld.getProperties();
        while (c.nextObject()) {
            String name;
            Property p = c.property();
            BValue o = c.get();
            String string = name = pre.length() > 0 ? pre + DELIMITER + p.getName() : p.getName();
            if (o instanceof BLonData) {
                this.parsePrimitives(a, (BLonData)o, name);
                continue;
            }
            if (!(o instanceof BLonPrimitive)) continue;
            BStatusNumeric val = null;
            if (o instanceof BLonDouble) {
                val = new BStatusNumeric();
            } else if (o instanceof BLonFloat) {
                val = new BStatusNumeric();
            } else if (o instanceof BLonInteger) {
                val = new BStatusNumeric();
            } else if (o instanceof BLonString) {
                val = new BStatusString();
            } else if (o instanceof BLonBoolean) {
                val = new BStatusBoolean();
            } else if (o instanceof BLonEnum) {
                val = new BStatusNumeric();
            } else if (o instanceof BLonByteArray) {
                val = new BStatusString();
            } else {
                throw new IllegalStateException("Unsupported LonPrimitive");
            }
            a.add((Object)new InputPrimitive((BStatusValue)val, name, p.getFacets()));
        }
    }

    private Property findAndRemoveProperty(InputPrimitive prim, Property[] props, Context c) {
        String name = prim.name;
        for (int i = 0; i < props.length; ++i) {
            Property p = props[i];
            if (p == null || !p.getName().equals(name) || p.isFrozen()) continue;
            if (p.getType() != prim.val.getType()) {
                this.remove(p, c);
                p = null;
            }
            props[i] = null;
            return p;
        }
        return null;
    }

    private void removeRemainingProps(Property[] props, Context c) {
        for (int i = 0; i < props.length; ++i) {
            Property p = props[i];
            if (p == null || p.isFrozen() || !p.getType().is(BStatusValue.TYPE)) continue;
            this.remove(p, c);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static class InputPrimitive {
        BStatusValue val;
        String name;
        BFacets facets;

        InputPrimitive(BStatusValue v, String n, BFacets f) {
            this.val = v;
            this.name = n;
            this.facets = f;
        }
    }
}

