/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.svg.batik;

import com.tridium.svg.batik.BatikOrdUtils;
import com.tridium.svg.batik.OrdParsedURLData;
import javax.baja.naming.BOrd;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.ParsedURLDefaultProtocolHandler;

public class OrdParsedURLProtocolHandler
extends ParsedURLDefaultProtocolHandler {
    private static final String ORD = "ord";

    public String getProtocolHandled() {
        return ORD;
    }

    public OrdParsedURLData parseURL(String urlStr) {
        if (urlStr == null) {
            throw new IllegalArgumentException("URL is required");
        }
        int hash = urlStr.indexOf("#");
        String ref = null;
        if (hash >= 0) {
            ref = urlStr.substring(hash + 1);
            urlStr = urlStr.substring(0, hash);
        }
        return new OrdParsedURLData(BOrd.make((String)BatikOrdUtils.fromBatikUrl(urlStr)), ref);
    }

    public OrdParsedURLData parseURL(ParsedURL basepurl, String urlStr) {
        if (basepurl == null || urlStr == null) {
            throw new IllegalArgumentException("Base and sub-URLs required");
        }
        return this.parseURL(BatikOrdUtils.relativize(basepurl, urlStr));
    }
}

