/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.ui;

import com.tridium.help.HelpSystem;
import com.tridium.help.ui.DocModuleNode;
import com.tridium.help.ui.DocTreeModel;
import com.tridium.help.ui.HelpTreeController;
import com.tridium.help.ui.SearchTreeModel;
import com.tridium.help.ui.TocTreeModel;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.util.BMiniTabbedPane;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.sidebar.BIWbSideBar;
import javax.baja.workbench.sidebar.BWbSideBar;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="loadHelp"), @NiagaraAction(name="search"), @NiagaraAction(name="tabChanged")})
public class BHelpSideBar
extends BWbSideBar {
    @Generated
    public static final Action loadHelp = BHelpSideBar.newAction((int)0, null);
    @Generated
    public static final Action search = BHelpSideBar.newAction((int)0, null);
    @Generated
    public static final Action tabChanged = BHelpSideBar.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHelpSideBar.class);
    private final BEdgePane edge;
    private final BMiniTabbedPane tabs = new BMiniTabbedPane(BValign.top);
    private BTextField searchText;
    private SearchTreeModel searchModel;
    private BTreePane tocWidget;
    private BTreePane apiWidget;

    @Generated
    public void loadHelp() {
        this.invoke(loadHelp, null, null);
    }

    @Generated
    public void search() {
        this.invoke(search, null, null);
    }

    @Generated
    public void tabChanged() {
        this.invoke(tabChanged, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHelpSideBar() {
        this.edge = new BEdgePane();
        this.setContent((BWidget)this.edge);
        this.buildUI();
    }

    public static void loadHelp(BWidget owner) {
        BHelpSideBar.disableHelpSideBars();
        HelpSystem.load(owner, success -> BHelpSideBar.invokeLater(BHelpSideBar::reloadHelpSideBars));
    }

    private static void disableHelpSideBars() {
        for (BHelpSideBar bar : BHelpSideBar.getHelpSideBars()) {
            bar.setEnabled(false);
        }
    }

    private static void reloadHelpSideBars() {
        boolean helpExists = HelpSystem.exists();
        for (BHelpSideBar bar : BHelpSideBar.getHelpSideBars()) {
            bar.setEnabled(true);
            if (!helpExists) continue;
            bar.reinit();
        }
    }

    private static Iterable<BHelpSideBar> getHelpSideBars() {
        BWidgetShell[] shells;
        ArrayList<BHelpSideBar> helpbars = new ArrayList<BHelpSideBar>();
        for (BWidgetShell shell : shells = BHelpSideBar.getApplication().getShells()) {
            BIWbSideBar[] bars;
            if (!(shell instanceof BNiagaraWbShell)) continue;
            for (BIWbSideBar bar : bars = ((BNiagaraWbShell)shell).pane.getSideBar().list()) {
                if (!(bar instanceof BHelpSideBar)) continue;
                helpbars.add((BHelpSideBar)bar);
            }
        }
        return helpbars;
    }

    protected final void reinit() {
        this.buildUI();
        this.relayoutSync();
        this.repaint();
    }

    public void doLoadHelp() {
        BHelpSideBar.loadHelp((BWidget)this);
    }

    public void doSearch() {
        this.searchModel.search(this.searchText.getText());
    }

    public void doTabChanged() {
        String label;
        BLabelPane pane = this.tabs.getSelectedLabelPane();
        if (pane != null && (label = pane.getLabel().getText()).equals(BHelpSideBar.text("help.search"))) {
            this.searchText.requestFocus();
        }
    }

    private void buildUI() {
        this.edge.setBottom((BWidget)new BNullWidget());
        this.edge.setCenter((BWidget)new BNullWidget());
        if (this.get("lnkTabs") != null) {
            this.remove("lnkTabs");
        }
        if (this.get("lnkLoadHelp") != null) {
            this.remove("lnkLoadHelp");
        }
        if (HelpSystem.exists()) {
            this.tabs.removeAll();
            this.tocWidget = this.buildToc();
            this.apiWidget = this.buildApi();
            this.tabs.addPane(BHelpSideBar.text("help.toc"), (BWidget)this.tocWidget);
            this.tabs.addPane(BHelpSideBar.text("help.api"), (BWidget)this.apiWidget);
            this.tabs.addPane(BHelpSideBar.text("help.search"), this.buildSearch());
            this.edge.setCenter((BWidget)this.tabs);
            this.linkTo("lnkTabs", (BComponent)this.tabs, (Slot)BMiniTabbedPane.selectionModified, (Slot)tabChanged);
            if (!HelpSystem.upToDate()) {
                BButton btn = new BButton(BHelpSideBar.text("help.load"));
                this.linkTo("lnkLoadHelp", (BComponent)btn, (Slot)BButton.actionPerformed, (Slot)loadHelp);
                BLabel lab = new BLabel(BHelpSideBar.text("help.load.outOfDate"), BHalign.left);
                BEdgePane e2 = new BEdgePane();
                e2.setLeft((BWidget)new BBorderPane((BWidget)btn, 3.0, 6.0, 3.0, 3.0));
                e2.setCenter((BWidget)lab);
                this.edge.setBottom((BWidget)e2);
            }
        } else {
            BButton btn = new BButton(BHelpSideBar.text("help.load"));
            this.linkTo("lnkLoadHelp", (BComponent)btn, (Slot)BButton.actionPerformed, (Slot)loadHelp);
            BGridPane pane = new BGridPane(1);
            pane.setColumnAlign(BHalign.center);
            pane.add(null, (BValue)new BLabel(BImage.make((String)"module://icons/x32/question.png")));
            pane.add(null, (BValue)btn);
            this.edge.setCenter((BWidget)pane);
        }
    }

    private BWidget buildSearch() {
        BEdgePane aPane = new BEdgePane();
        aPane.setLeft((BWidget)new BLabel(BHelpSideBar.text("help.find")));
        this.searchText = new BTextField("", 20, true);
        aPane.setCenter((BWidget)this.searchText);
        BButton searchBtn = new BButton(BHelpSideBar.text("help.search"));
        aPane.setRight((BWidget)searchBtn);
        this.searchModel = new SearchTreeModel();
        BTree tree = new BTree((TreeModel)this.searchModel, (TreeController)new HelpTreeController());
        BEdgePane ep = new BEdgePane();
        ep.setTop((BWidget)new BBorderPane((BWidget)aPane, 2.0, 1.0, 1.0, 2.0));
        ep.setCenter((BWidget)new BTreePane(tree));
        if (this.get("lnkSearch") != null) {
            this.remove("lnkSearch");
        }
        this.linkTo("lnkSearch", (BComponent)this.searchText, (Slot)BTextField.actionPerformed, (Slot)search);
        searchBtn.setCommand(new Command((BWidget)this, BHelpSideBar.text("help.search")){

            public CommandArtifact doInvoke() {
                ((BHelpSideBar)this.getOwner()).doSearch();
                return null;
            }
        }, false, false);
        return ep;
    }

    private BTreePane buildToc() {
        String[] names = HelpSystem.getModulesHavingFile("doc/toc.xml");
        TocTreeModel model = new TocTreeModel(names);
        HelpTreeController controller = new HelpTreeController();
        BTree tree = new BTree((TreeModel)model, (TreeController)controller);
        return new BTreePane(tree);
    }

    private BTreePane buildApi() {
        String[] docModules = HelpSystem.getModulesHavingFile("doc/bajadoc.index");
        DocTreeModel model = new DocTreeModel();
        ArrayList<DocModuleNode> roots = new ArrayList<DocModuleNode>();
        for (String module : docModules) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)HelpSystem.getJarEntryInputStream(module, "doc/bajadoc.index"), Charset.forName("UTF-8")));){
                String bajadocRoot;
                while ((bajadocRoot = reader.readLine()) != null) {
                    if (bajadocRoot.isEmpty()) continue;
                    roots.add(new DocModuleNode(model, module, bajadocRoot));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        roots.sort(Comparator.comparing(DocModuleNode::getText, String::compareToIgnoreCase));
        model.setRoots(roots);
        HelpTreeController controller = new HelpTreeController();
        BTree tree = new BTree((TreeModel)model, (TreeController)controller);
        return new BTreePane(tree);
    }

    BTreePane getTocWidget() {
        return this.tocWidget;
    }

    BTreePane getApiWidget() {
        return this.apiWidget;
    }

    void setSelectedTab(BWidget widget) {
        this.tabs.selectPane(widget);
    }

    private static String text(String str) {
        return UiLexicon.bajaui().getText(str);
    }
}

