/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.util;

import com.tridium.help.bajadoc.JavaType;
import com.tridium.help.bajadoc.JavaTypeVariable;
import com.tridium.help.bajadoc.ParameterizedJavaType;
import com.tridium.help.bajadoc.WildcardJavaType;
import java.util.Optional;
import java.util.function.BiConsumer;

public final class TypeNameFormatter {
    private TypeNameFormatter() {
    }

    public static void formatHtml(JavaType[] types, String sep, boolean expandTypeVars, BiConsumer<String, Optional<JavaType>> fn) {
        TypeNameFormatter.buildTypeDisplayString(types, sep, "&lt;", "&gt;", expandTypeVars, fn);
    }

    public static void formatPlain(JavaType[] types, String sep, boolean expandTypeVars, BiConsumer<String, Optional<JavaType>> fn) {
        TypeNameFormatter.buildTypeDisplayString(types, sep, "<", ">", expandTypeVars, fn);
    }

    private static void buildTypeDisplayString(JavaType[] types, String sep, String lt, String gt, boolean expandTypeVars, BiConsumer<String, Optional<JavaType>> fn) {
        for (int i = 0; i < types.length; ++i) {
            JavaType t = types[i];
            if (i > 0) {
                fn.accept(sep, Optional.empty());
            }
            if (t instanceof WildcardJavaType) {
                WildcardJavaType w = (WildcardJavaType)t;
                fn.accept("?", Optional.empty());
                if (w.hasSuperBounds()) {
                    fn.accept(" super ", Optional.empty());
                    TypeNameFormatter.buildTypeDisplayString(w.getSuperBounds(), " & ", lt, gt, false, fn);
                    continue;
                }
                if (!w.hasExtendsBounds()) continue;
                fn.accept(" extends ", Optional.empty());
                TypeNameFormatter.buildTypeDisplayString(w.getExtendsBounds(), " & ", lt, gt, false, fn);
                continue;
            }
            if (t instanceof ParameterizedJavaType) {
                ParameterizedJavaType p = (ParameterizedJavaType)t;
                fn.accept(p.name(), Optional.of(p));
                JavaType[] args = p.getArguments();
                if (args.length <= 0) continue;
                fn.accept(lt, Optional.empty());
                TypeNameFormatter.buildTypeDisplayString(p.getArguments(), ", ", lt, gt, false, fn);
                fn.accept(gt, Optional.empty());
                continue;
            }
            if (t instanceof JavaTypeVariable) {
                JavaTypeVariable v = (JavaTypeVariable)t;
                fn.accept(v.name(), Optional.of(v));
                if (!expandTypeVars || !v.hasBounds()) continue;
                fn.accept(" extends ", Optional.empty());
                TypeNameFormatter.buildTypeDisplayString(v.getBounds(), " & ", lt, gt, false, fn);
                continue;
            }
            fn.accept(t.name(), Optional.of(t));
        }
    }
}

