/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc;

import com.tridium.help.bajadoc.Annotation;
import com.tridium.help.bajadoc.JavaType;

public abstract class AnnotationValue {
    public static AnnotationValue makeForType(JavaType type) {
        return new Type(type);
    }

    public static AnnotationValue makeForEnum(JavaType type, String field) {
        return new Enum(type, field);
    }

    public static AnnotationValue makeForAnnotation(Annotation annotation) {
        return new AnnotationInstance(annotation);
    }

    public static AnnotationValue makeForArray(AnnotationValue[] values) {
        return new Array(values);
    }

    public static AnnotationValue makeForExpression(String expr) {
        return new Expression(expr);
    }

    protected AnnotationValue() {
    }

    public static final class AnnotationInstance
    extends AnnotationValue {
        private final Annotation annotation;

        AnnotationInstance(Annotation annotation) {
            this.annotation = annotation;
        }

        public Annotation annotation() {
            return this.annotation;
        }

        public String toString() {
            return this.annotation.toString();
        }
    }

    public static class Array
    extends AnnotationValue {
        private final AnnotationValue[] values;

        Array(AnnotationValue[] values) {
            this.values = values;
        }

        public AnnotationValue[] values() {
            return this.values;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.values[i]).toString();
            }
            sb.append(" }");
            return sb.toString();
        }
    }

    public static class Enum
    extends AnnotationValue {
        private final JavaType type;
        private final String field;

        Enum(JavaType type, String field) {
            this.type = type;
            this.field = field;
        }

        public JavaType type() {
            return this.type;
        }

        public String field() {
            return this.field;
        }

        public String toString() {
            return this.type.name() + '.' + this.field;
        }
    }

    public static class Type
    extends AnnotationValue {
        private final JavaType type;

        Type(JavaType type) {
            this.type = type;
        }

        public JavaType type() {
            return this.type;
        }

        public String toString() {
            return this.type.name() + ".class";
        }
    }

    public static final class Expression
    extends AnnotationValue {
        private final String expr;

        Expression(String expr) {
            this.expr = expr;
        }

        public String expression() {
            return this.expr;
        }

        public String toString() {
            return this.expr;
        }
    }
}

