/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.BajadocIndex;
import com.tridium.help.HelpSystem;
import com.tridium.ui.BOptionDialog;
import java.util.Optional;
import javax.baja.naming.BOrd;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.util.UiLexicon;

public final class BajadocFinder {
    private static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BajadocFinder.class);

    private BajadocFinder() {
    }

    public static BOrd findBajadocOrd(BWidget owner, String pattern) {
        BajadocIndex.Entry[] entries;
        if (!HelpSystem.exists()) {
            throw new IllegalStateException();
        }
        Optional<String> modulePart = Optional.empty();
        int n = pattern.indexOf(58);
        if (n != -1) {
            modulePart = Optional.of(pattern.substring(0, n));
            pattern = pattern.substring(n + 1);
        }
        if ((entries = BajadocIndex.instance().getEntries(pattern, modulePart)) != null) {
            return BajadocFinder.selectEntry(owner, entries);
        }
        n = pattern.lastIndexOf(46, pattern.length() - 1);
        while (n != -1) {
            String pkg = pattern.substring(0, n);
            String cls = pattern.substring(n + 1);
            entries = BajadocIndex.instance().getEntries(pkg, cls, modulePart);
            if (entries != null) {
                return BajadocFinder.selectEntry(owner, entries);
            }
            n = pattern.lastIndexOf(46, n - 1);
        }
        return null;
    }

    private static BOrd selectEntry(BWidget owner, BajadocIndex.Entry[] entries) {
        if (entries.length == 1) {
            return entries[0].toOrd();
        }
        BList list = new BList();
        list.setMultipleSelection(false);
        list.setModel((ListModel)new Model(entries));
        list.setController((ListController)new Controller());
        String title = lexicon.getText("bajadocFinder.selectBajadoc");
        int result = BDialog.open((BWidget)owner, (String)title, (Object)list, (int)3);
        if (result == 2) {
            return null;
        }
        int idx = list.getSelectedIndex();
        return idx == -1 ? null : entries[idx].toOrd();
    }

    private static class Controller
    extends ListController {
        private Controller() {
        }

        void ok() {
            ((BOptionDialog)this.getList().getShell()).close(1);
        }

        protected void handleEnter(BKeyEvent event) {
            event.consume();
            this.ok();
        }

        protected void itemDoubleClicked(BMouseEvent event, int i) {
            this.ok();
        }
    }

    private static class Model
    extends ListModel {
        private final BajadocIndex.Entry[] entries;

        private Model(BajadocIndex.Entry[] entries) {
            this.entries = entries;
        }

        public int getItemCount() {
            return this.entries.length;
        }

        public Object getItem(int idx) {
            return this.entries[idx].toOrd();
        }
    }
}

