/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mcquay.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.mcquay.messages.McQuayMessage;
import com.tridium.mcquay.messages.McQuayReadResponse;
import com.tridium.mcquay.messages.McQuayReceivedMessage;
import java.io.OutputStream;

public class McQuayReadRequest
extends McQuayMessage {
    public McQuayReadRequest() {
    }

    public McQuayReadRequest(int dataLen, int l2Addr, int l3Addr, String register, String password) {
        this.dataLen = dataLen;
        this.l2Addr = l2Addr;
        this.l3Addr = l3Addr;
        this.register = register;
        this.password = password;
        this.isPing = false;
    }

    public Message toResponse(ReceivedMessage resp) {
        McQuayReceivedMessage respMsg = (McQuayReceivedMessage)resp;
        McQuayReadResponse respMessage = new McQuayReadResponse(this);
        respMessage.readResponse(respMsg.getBytes(), this.dataLen, false);
        respMsg = null;
        return respMessage;
    }

    @Override
    public byte[] getByteArray() {
        String subCmd;
        switch (this.dataLen) {
            case 1: {
                subCmd = "0";
                break;
            }
            case 2: {
                subCmd = "1";
                break;
            }
            case 4: {
                subCmd = "2";
                break;
            }
            case 8: {
                subCmd = "3";
                break;
            }
            default: {
                subCmd = "0";
            }
        }
        String command = " A" + subCmd + this.password + Integer.toHexString((this.l2Addr & 0xF0) >> 4) + Integer.toHexString(this.l2Addr & 0xF) + Integer.toHexString((this.l3Addr & 0xF0) >> 4) + Integer.toHexString(this.l3Addr & 0xF) + this.register;
        command = command.toUpperCase();
        this.mcQuayReadLog.trace("Read Request Command is::" + command);
        return command.getBytes();
    }

    @Override
    public void write(OutputStream out) {
        try {
            out.write(this.getByteArray());
        }
        catch (Exception e) {
            this.mcQuayReadLog.error("Exception in McQuayReadRequest-->write() method");
        }
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }
}

