/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mcquay;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.mcquay.BMcQuayDevice;
import com.tridium.mcquay.BMcQuayDeviceFolder;
import com.tridium.mcquay.comm.BMcQuayUnsolicitedReceive;
import com.tridium.mcquay.comm.McQuayComm;
import com.tridium.mcquay.comm.McQuayCommReceiver;
import com.tridium.mcquay.comm.McQuayCommTransmitter;
import com.tridium.mcquay.messages.McQuayReadRequest;
import com.tridium.mcquay.messages.McQuayReadResponse;
import javax.baja.driver.BDriverContainer;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialFlowControlMode;
import javax.baja.serial.BSerialHelper;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="unsolicitedReceiveHandler", type="BMcQuayUnsolicitedReceive", defaultValue="new BMcQuayUnsolicitedReceive()"), @NiagaraProperty(name="tuningPolicies", type="BTuningPolicyMap", defaultValue="new BTuningPolicyMap()", override=true), @NiagaraProperty(name="sitePasswordHex", type="String", defaultValue="")})
@NiagaraActions(value={@NiagaraAction(name="upload", parameterType="BUploadParameters", defaultValue="new BUploadParameters()", flags=20, override=true), @NiagaraAction(name="download", parameterType="BDownloadParameters", defaultValue="new BDownloadParameters()", flags=20, override=true)})
public class BMcQuayNetwork
extends BSerialNetwork {
    @Generated
    public static final Property unsolicitedReceiveHandler = BMcQuayNetwork.newProperty((int)0, (BValue)new BMcQuayUnsolicitedReceive(), null);
    @Generated
    public static final Property tuningPolicies = BMcQuayNetwork.newProperty((int)0, (BValue)new BTuningPolicyMap(), null);
    @Generated
    public static final Property sitePasswordHex = BMcQuayNetwork.newProperty((int)0, (String)"", null);
    @Generated
    public static final Action upload = BMcQuayNetwork.newAction((int)20, (BValue)new BUploadParameters(), null);
    @Generated
    public static final Action download = BMcQuayNetwork.newAction((int)20, (BValue)new BDownloadParameters(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMcQuayNetwork.class);
    private String password = "";
    private McQuayComm mcquayComm = null;
    Log mcQuayLog = Log.getLog((String)"McQuayLog");

    @Generated
    public BMcQuayUnsolicitedReceive getUnsolicitedReceiveHandler() {
        return (BMcQuayUnsolicitedReceive)this.get(unsolicitedReceiveHandler);
    }

    @Generated
    public void setUnsolicitedReceiveHandler(BMcQuayUnsolicitedReceive v) {
        this.set(unsolicitedReceiveHandler, (BValue)v, null);
    }

    @Generated
    public String getSitePasswordHex() {
        return this.getString(sitePasswordHex);
    }

    @Generated
    public void setSitePasswordHex(String v) {
        this.setString(sitePasswordHex, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BMcQuayDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BMcQuayDeviceFolder.TYPE;
    }

    public void started() throws Exception {
        super.started();
        BSerialHelper bshlpr = ((BSerialNetwork)this.getNetwork()).getSerialPortConfig();
        try {
            bshlpr.setBaudRate((BBaudRate)BSerialBaudRate.baud9600);
            bshlpr.setDataBits(BSerialDataBits.dataBits7);
            bshlpr.setStopBits(BSerialStopBits.stopBit1);
            bshlpr.setParity(BSerialParity.even);
            bshlpr.setFlowControlMode(BSerialFlowControlMode.none);
            ((BSerialNetwork)this.getNetwork()).setSerialPortConfig(bshlpr);
        }
        catch (Exception e) {
            this.mcQuayLog.error("Exception in McQuayNetwork-->started()");
        }
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public boolean isParentLegal(BComponent parent) throws LocalizableRuntimeException {
        super.isParentLegal(parent);
        if (!(parent instanceof BDriverContainer)) {
            throw new LocalizableRuntimeException("mcquay", "Only allowed as child of a station");
        }
        return true;
    }

    public boolean isChildLegal(BComponent child) throws LocalizableRuntimeException {
        if (child instanceof BMcQuayNetwork) {
            throw new LocalizableRuntimeException("mcquay", "Cannot add McQuayNetwork under a McQuayNetwork");
        }
        return true;
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (!this.isRunning()) {
            return;
        }
    }

    protected Comm makeComm() {
        this.mcquayComm = new McQuayComm(this, new McQuayCommReceiver(), new McQuayCommTransmitter());
        return this.mcquayComm;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "mcquay");
    }

    public String getPassword() {
        this.password = this.getSitePasswordHex();
        if (this.password.length() != 8) {
            this.password = "FFFFFFFF";
        }
        return this.password;
    }

    public boolean initPassword() {
        this.password = "";
        McQuayReadRequest req = new McQuayReadRequest(1, 0, 255, "802A", "86672775");
        McQuayReadResponse resp1 = (McQuayReadResponse)this.sendSync(req);
        req = new McQuayReadRequest(1, 0, 255, "802E", "86672775");
        McQuayReadResponse resp2 = (McQuayReadResponse)this.sendSync(req);
        req = new McQuayReadRequest(1, 0, 255, "8032", "86672775");
        McQuayReadResponse resp3 = (McQuayReadResponse)this.sendSync(req);
        req = new McQuayReadRequest(1, 0, 255, "8036", "86672775");
        McQuayReadResponse resp4 = (McQuayReadResponse)this.sendSync(req);
        if (!(resp1 == null || resp2 == null || resp3 == null || resp4 == null || resp1.isError() || resp2.isError() || resp3.isError() || resp4.isError())) {
            this.password = Integer.toHexString((resp1.data & 0xF0) >> 4) + Integer.toHexString(resp1.data & 0xF) + Integer.toHexString((resp2.data & 0xF0) >> 4) + Integer.toHexString(resp2.data & 0xF) + Integer.toHexString((resp3.data & 0xF0) >> 4) + Integer.toHexString(resp3.data & 0xF) + Integer.toHexString((resp4.data & 0xF0) >> 4) + Integer.toHexString(resp4.data & 0xF);
            return true;
        }
        this.password = "FFFFFFFF";
        return false;
    }
}

