/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mcquay;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.mcquay.BMcQuayDeviceFolder;
import com.tridium.mcquay.BMcQuayNetwork;
import com.tridium.mcquay.messages.McQuayReadRequest;
import com.tridium.mcquay.messages.McQuayReadResponse;
import com.tridium.mcquay.point.BMcQuayPointDeviceExt;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="masterNodeL2Addr", type="int", defaultValue="0", facets={@Facet(value="BFacets.makeInt(0,255)")}), @NiagaraProperty(name="slaveNodeL3Addr", type="int", defaultValue="255", facets={@Facet(value="BFacets.makeInt(0,255)")}), @NiagaraProperty(name="pingRegisterHex", type="String", defaultValue="-", flags=4), @NiagaraProperty(name="softwareIdent", type="String", defaultValue="-", flags=1), @NiagaraProperty(name="deviceStatus", type="String", defaultValue="BMcQuayDevice.OFFLINE", flags=1), @NiagaraProperty(name="points", type="BMcQuayPointDeviceExt", defaultValue="new BMcQuayPointDeviceExt()", facets={@Facet(value="BFacets.makeInt(1, 255)")})})
@NiagaraActions(value={@NiagaraAction(name="upload", parameterType="BUploadParameters", defaultValue="new BUploadParameters()", flags=20, override=true), @NiagaraAction(name="download", parameterType="BDownloadParameters", defaultValue="new BDownloadParameters()", flags=20, override=true)})
public class BMcQuayDevice
extends BBasicDevice {
    @Generated
    public static final Property masterNodeL2Addr = BMcQuayDevice.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)255));
    @Generated
    public static final Property slaveNodeL3Addr = BMcQuayDevice.newProperty((int)0, (int)255, (BFacets)BFacets.makeInt((int)0, (int)255));
    @Generated
    public static final Property pingRegisterHex = BMcQuayDevice.newProperty((int)4, (String)"-", null);
    @Generated
    public static final Property softwareIdent = BMcQuayDevice.newProperty((int)1, (String)"-", null);
    @Generated
    public static final Property deviceStatus = BMcQuayDevice.newProperty((int)1, (String)"Off-Line", null);
    @Generated
    public static final Property points = BMcQuayDevice.newProperty((int)0, (BValue)new BMcQuayPointDeviceExt(), (BFacets)BFacets.makeInt((int)1, (int)255));
    @Generated
    public static final Action upload = BMcQuayDevice.newAction((int)20, (BValue)new BUploadParameters(), null);
    @Generated
    public static final Action download = BMcQuayDevice.newAction((int)20, (BValue)new BDownloadParameters(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMcQuayDevice.class);
    private static final String OFFLINE = "Off-Line";
    private static final String ONLINE = "On-Line";

    @Generated
    public int getMasterNodeL2Addr() {
        return this.getInt(masterNodeL2Addr);
    }

    @Generated
    public void setMasterNodeL2Addr(int v) {
        this.setInt(masterNodeL2Addr, v, null);
    }

    @Generated
    public int getSlaveNodeL3Addr() {
        return this.getInt(slaveNodeL3Addr);
    }

    @Generated
    public void setSlaveNodeL3Addr(int v) {
        this.setInt(slaveNodeL3Addr, v, null);
    }

    @Generated
    public String getPingRegisterHex() {
        return this.getString(pingRegisterHex);
    }

    @Generated
    public void setPingRegisterHex(String v) {
        this.setString(pingRegisterHex, v, null);
    }

    @Generated
    public String getSoftwareIdent() {
        return this.getString(softwareIdent);
    }

    @Generated
    public void setSoftwareIdent(String v) {
        this.setString(softwareIdent, v, null);
    }

    @Generated
    public String getDeviceStatus() {
        return this.getString(deviceStatus);
    }

    @Generated
    public void setDeviceStatus(String v) {
        this.setString(deviceStatus, v, null);
    }

    @Generated
    public BMcQuayPointDeviceExt getPoints() {
        return (BMcQuayPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BMcQuayPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BMcQuayNetwork getMcQuayNetwork() {
        return (BMcQuayNetwork)this.getNetwork();
    }

    public Type getNetworkType() {
        return BMcQuayNetwork.TYPE;
    }

    public void started() throws Exception {
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BMcQuayNetwork || parent instanceof BMcQuayDeviceFolder;
    }

    public void changed(Property changedProperty, Context cx) {
        if (cx == Context.decoding) {
            return;
        }
    }

    public boolean isChildLegal(BComponent component) throws LocalizableRuntimeException {
        if (component instanceof BMcQuayDevice) {
            throw new LocalizableRuntimeException("mcquay", "McQuayDevice cannot be child of McQuayDevice");
        }
        return true;
    }

    public IFuture postPing() {
        this.doPing();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPing() {
        BMcQuayNetwork network = (BMcQuayNetwork)this.getNetwork();
        if (network.isDisabled() || !network.isCommActive()) {
            this.pingFail("Ping failed");
            this.setDeviceStatus(OFFLINE);
            return;
        }
        if (this.isDisabled()) {
            return;
        }
        McQuayReadRequest req = null;
        McQuayReadResponse resp = null;
        String softId = "";
        try {
            for (int i = 0; i < 8; ++i) {
                String nextReg = Integer.toHexString(Integer.parseInt("0A08", 16) + i);
                while (nextReg.length() < 4) {
                    nextReg = "0" + nextReg;
                }
                req = new McQuayReadRequest(1, this.getMasterNodeL2Addr(), this.getSlaveNodeL3Addr(), nextReg, network.getPassword());
                req.isPing = true;
                resp = (McQuayReadResponse)network.sendSync(req);
                if (resp == null || resp.isError()) {
                    this.pingFail("Ping Failed");
                    this.setDeviceStatus(OFFLINE);
                    return;
                }
                if (resp.exceptionCode == 2) {
                    this.pingFail("Ping Failed");
                    this.setDeviceStatus(OFFLINE);
                    return;
                }
                this.pingOk();
                softId = softId + resp.strData;
                this.setDeviceStatus(ONLINE);
            }
            this.setSoftwareIdent(softId);
        }
        catch (Exception e) {
            this.pingFail("caught exception");
        }
        finally {
            network = null;
        }
    }
}

