/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.sysmon.BAbstractAlarmMonitor;
import java.io.StringWriter;
import java.io.Writer;
import javax.baja.data.BIDataValue;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.BSpy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ramDiskSize", type="int", defaultValue="0", flags=3, facets={@Facet(value="createRamDiskFacets()")}), @NiagaraProperty(name="maxRamDiskSizeLimit", type="int", defaultValue="95", facets={@Facet(value="createRamDiskFacets()")})})
public final class BRamDiskMonitor
extends BAbstractAlarmMonitor {
    @Generated
    public static final Property ramDiskSize = BRamDiskMonitor.newProperty((int)3, (int)0, (BFacets)BRamDiskMonitor.createRamDiskFacets());
    @Generated
    public static final Property maxRamDiskSizeLimit = BRamDiskMonitor.newProperty((int)0, (int)95, (BFacets)BRamDiskMonitor.createRamDiskFacets());
    @Generated
    public static final Type TYPE = Sys.loadType(BRamDiskMonitor.class);

    @Generated
    public int getRamDiskSize() {
        return this.getInt(ramDiskSize);
    }

    @Generated
    public void setRamDiskSize(int v) {
        this.setInt(ramDiskSize, v, null);
    }

    @Generated
    public int getMaxRamDiskSizeLimit() {
        return this.getInt(maxRamDiskSizeLimit);
    }

    @Generated
    public void setMaxRamDiskSizeLimit(int v) {
        this.setInt(maxRamDiskSizeLimit, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    private static BFacets createRamDiskFacets() {
        BFacets f1 = BFacets.makeInt((BUnit)BUnit.getUnit((String)"percent"));
        BFacets f2 = BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)100)));
        return BFacets.make((BFacets)f1, (BFacets)f2);
    }

    @Override
    protected String getToNormalText() {
        return "%lexicon(systemMonitor:ramDiskToNormal)%";
    }

    @Override
    protected String getToOffnormalText() {
        return "%lexicon(systemMonitor:ramDiskToOffnormal)%";
    }

    @Override
    public void doRunCheck() {
        this.checkRamDisk();
    }

    private void checkRamDisk() {
        block6: {
            try {
                String[] lines;
                if (!PlatformUtil.isTridiumPlatform() || !OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) break block6;
                StringWriter strWtr = new StringWriter();
                SpyWriter writer = new SpyWriter((Writer)strWtr, new FilePath("/"));
                ((BSpy)BOrd.make((String)"spy:/platform diagnostics/df -k").get((BObject)this)).get().write(writer);
                for (String line : lines = TextUtil.splitAndTrim((String)strWtr.toString(), (char)'\n')) {
                    String[] sections;
                    if (!line.contains("/aram0/")) continue;
                    for (String section : sections = TextUtil.splitAndTrim((String)line, (char)' ')) {
                        if (section.indexOf(37) <= -1) continue;
                        String ramDiskStr = section.replace('%', ' ');
                        int ramDiskPercentSize = Integer.parseInt(ramDiskStr.trim());
                        this.setRamDiskSize(ramDiskPercentSize);
                        if (ramDiskPercentSize > this.getMaxRamDiskSizeLimit()) {
                            BFormat msg = BFormat.make((String)(this.getToOffnormalText() + ": " + ramDiskPercentSize));
                            this.getLog().warning(msg.format((Object)this));
                            this.raiseAlarm(msg, true);
                        } else {
                            this.raiseAlarm(false);
                        }
                        break block6;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.getLog().error("Checking RAM disk size", (Throwable)e);
            }
        }
    }
}

