/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.sysmon.BAbstractAlarmMonitor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="logCPUToHistory", type="boolean", defaultValue="false"), @NiagaraProperty(name="cpuHistoryConfig", type="BHistoryConfig", defaultValue="new BHistoryConfig()")})
public abstract class BAbstractCPUMonitor
extends BAbstractAlarmMonitor {
    @Generated
    public static final Property logCPUToHistory = BAbstractCPUMonitor.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property cpuHistoryConfig = BAbstractCPUMonitor.newProperty((int)0, (BValue)new BHistoryConfig(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractCPUMonitor.class);

    @Generated
    public boolean getLogCPUToHistory() {
        return this.getBoolean(logCPUToHistory);
    }

    @Generated
    public void setLogCPUToHistory(boolean v) {
        this.setBoolean(logCPUToHistory, v, null);
    }

    @Generated
    public BHistoryConfig getCpuHistoryConfig() {
        return (BHistoryConfig)this.get(cpuHistoryConfig);
    }

    @Generated
    public void setCpuHistoryConfig(BHistoryConfig v) {
        this.set(cpuHistoryConfig, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doStarted() throws Exception {
        BHistoryConfig config = this.getCpuHistoryConfig();
        config.setId(BHistoryId.make((String)Sys.getStation().getStationName(), (String)this.getHistoryName()));
        config.setRecordType(BTypeSpec.make((Type)BNumericTrendRecord.TYPE));
    }

    protected abstract long checkCPU();

    protected abstract String getHistoryName();

    @Override
    public final void doRunCheck() {
        long mem = this.checkCPU();
        if (this.getLogCPUToHistory()) {
            this.logCpu(this.getCpuHistoryConfig(), mem);
        }
    }

    protected void logCpu(BHistoryConfig config, long mem) {
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            if (db == null) {
                this.getLog().error("Local history database not available.");
                return;
            }
            config.setTimeZone(BTimeZone.getLocal());
            BHistoryId id = config.getId();
            if (id.getDeviceName().equals("^")) {
                config.setId(BHistoryId.make((String)Sys.getStation().getStationName(), (String)id.getHistoryName()));
            }
            try (HistorySpaceConnection conn = db.getConnection(null);){
                if (!conn.exists(id)) {
                    conn.createHistory(config);
                } else {
                    HistoryDatabaseConnection dbConn = db.getDbConnection(null);
                    dbConn.reconfigureHistory(config);
                }
                BIHistory history = conn.getHistory(id);
                BNumericTrendRecord rec = new BNumericTrendRecord();
                rec.set(BAbsTime.now(), (double)mem, BStatus.ok);
                conn.append(history, (BIHistoryRecordSet)rec);
            }
        }
        catch (Exception e) {
            this.getLog().error("Error creating the CPU history", (Throwable)e);
        }
    }
}

