/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.sysmon.BAbstractMonitor;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=11), @NiagaraProperty(name="lastAlarmMessage", type="String", defaultValue="", flags=3), @NiagaraProperty(name="lastAlarmTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=3), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="new BAlarmSourceInfo()"), @NiagaraProperty(name="generateAlarm", type="boolean", defaultValue="true")})
@NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)
public abstract class BAbstractAlarmMonitor
extends BAbstractMonitor
implements BIAlarmSource {
    @Generated
    public static final Property status = BAbstractAlarmMonitor.newProperty((int)11, (BValue)BStatus.ok, null);
    @Generated
    public static final Property lastAlarmMessage = BAbstractAlarmMonitor.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property lastAlarmTime = BAbstractAlarmMonitor.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property alarmSourceInfo = BAbstractAlarmMonitor.newProperty((int)0, (BValue)new BAlarmSourceInfo(), null);
    @Generated
    public static final Property generateAlarm = BAbstractAlarmMonitor.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action ackAlarm = BAbstractAlarmMonitor.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractAlarmMonitor.class);
    private static final String SYSMON_TEXT = "systemMonitor";
    private AlarmSupport support = null;
    private boolean inAlarm = false;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getLastAlarmMessage() {
        return this.getString(lastAlarmMessage);
    }

    @Generated
    public void setLastAlarmMessage(String v) {
        this.setString(lastAlarmMessage, v, null);
    }

    @Generated
    public BAbsTime getLastAlarmTime() {
        return (BAbsTime)this.get(lastAlarmTime);
    }

    @Generated
    public void setLastAlarmTime(BAbsTime v) {
        this.set(lastAlarmTime, (BValue)v, null);
    }

    @Generated
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    @Generated
    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Generated
    public boolean getGenerateAlarm() {
        return this.getBoolean(generateAlarm);
    }

    @Generated
    public void setGenerateAlarm(boolean v) {
        this.setBoolean(generateAlarm, v, null);
    }

    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAbstractAlarmMonitor() {
        BAlarmSourceInfo info = new BAlarmSourceInfo();
        info.setFlags((Slot)BAlarmSourceInfo.toFaultText, 4);
        info.setToOffnormalText(BFormat.make((String)this.getToOffnormalText()));
        info.setToNormalText(BFormat.make((String)this.getToNormalText()));
        this.setAlarmSourceInfo(info);
    }

    protected abstract String getToNormalText();

    protected abstract String getToOffnormalText();

    public final void started() throws Exception {
        this.support = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        try {
            if (this.support != null && Sys.atSteadyState()) {
                this.support.toNormal((Context)null);
            }
        }
        catch (Exception e) {
            this.getLog().error("Cannot make alarm normal", (Throwable)e);
        }
        this.doStarted();
    }

    public void atSteadyState() throws Exception {
        try {
            if (this.support != null) {
                this.support.toNormal((Context)null);
            }
        }
        catch (Exception e) {
            this.getLog().error("Cannot make alarm normal", (Throwable)e);
        }
    }

    protected void doStarted() throws Exception {
    }

    public void changed(Property prop, Context cx) {
        if (this.isRunning() && prop.equals(generateAlarm) && !this.getGenerateAlarm()) {
            this.setStatus(BStatus.ok);
            this.inAlarm = false;
            try {
                if (this.support != null) {
                    this.support.toNormal(cx);
                }
            }
            catch (Exception e) {
                this.getLog().error("Cannot make alarm normal", (Throwable)e);
            }
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) throws Exception {
        this.setStatus(BStatus.makeUnackedAlarm((BStatus)this.getStatus(), (boolean)false));
        return BBoolean.make((boolean)this.support.ackAlarm(ackRequest));
    }

    protected void raiseAlarm(BFormat value, boolean alarm) {
        if (this.getGenerateAlarm()) {
            try {
                if (this.inAlarm) {
                    if (!alarm) {
                        this.support.toNormal((Context)null);
                        this.inAlarm = false;
                        BStatus s = this.getStatus();
                        if (s.isUnackedAlarm()) {
                            this.setStatus(BStatus.make((int)128));
                        } else {
                            this.setStatus(BStatus.ok);
                        }
                    }
                } else if (alarm) {
                    this.support.newOffnormalAlarm(BFacets.make((String)SYSMON_TEXT, (String)value.format((Object)this)));
                    this.inAlarm = true;
                    this.setStatus(BStatus.make((int)136));
                    this.setLastAlarmMessage(value.format((Object)this));
                    this.setLastAlarmTime(BAbsTime.now());
                }
            }
            catch (Exception e) {
                this.getLog().error("FATAL ERROR GENERATING SYSTEM MONITOR ALERT!", (Throwable)e);
            }
        }
    }

    protected void raiseAlarm(boolean alarm) {
        this.raiseAlarm(BFormat.DEFAULT, alarm);
    }
}

