/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.util;

import com.tridium.tls.datatypes.BBirAdjDelHistoryRecord;
import com.tridium.tls.datatypes.BDelVarHistoryRecord;
import com.tridium.tls.datatypes.BFuelMgmtHistoryRecord;
import com.tridium.tls.datatypes.BInTankInvHistoryRecord;
import com.tridium.tls.datatypes.BInTankStaHistoryRecord;
import com.tridium.tls.datatypes.BInvReconcileRowRecord;
import com.tridium.tls.datatypes.BLiqSenAlmHistoryRecord;
import com.tridium.tls.datatypes.BPriAlmHisHistoryRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.sys.BStruct;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

public class TlsHistoryHelper {
    private static BHistoryId badHistoryId = null;
    private static BHistoryId dvHistoryId = null;
    private static BHistoryId fmHistoryId = null;
    private static BHistoryId irrHistoryId = null;
    private static BHistoryId itiHistoryId = null;
    private static BHistoryId itsHistoryId = null;
    private static BHistoryId lsaHistoryId = null;
    private static BHistoryId pahHistoryId = null;
    private static BHistoryDatabase historyDatabase = null;
    private static BHistoryService service = null;
    private static HistoryDatabaseConnection conDB = null;

    public static void initHistory(Type t) throws ServiceNotFoundException {
        service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        historyDatabase = service.getDatabase();
        conDB = historyDatabase.getDbConnection(null);
        if (historyDatabase == null) {
            System.out.println("Error: History database is null.");
        } else if (t == BBirAdjDelHistoryRecord.TYPE) {
            if (badHistoryId == null) {
                BHistoryConfig badHistoryConfig = new BHistoryConfig(BHistoryId.make((String)Sys.getStation().getStationName(), (String)"TlsBadHistory"), BTypeSpec.make((Type)BBirAdjDelHistoryRecord.TYPE));
                badHistoryConfig.setTimeZone(BTimeZone.getLocal());
                badHistoryId = badHistoryConfig.getId();
                if (!conDB.exists(badHistoryId)) {
                    conDB.createHistory(badHistoryConfig);
                } else {
                    conDB.reconfigureHistory(badHistoryConfig);
                }
            }
        } else if (t == BDelVarHistoryRecord.TYPE) {
            if (dvHistoryId == null) {
                BHistoryConfig dvHistoryConfig = new BHistoryConfig(BHistoryId.make((String)Sys.getStation().getStationName(), (String)"TlsDvHistory"), BTypeSpec.make((Type)BDelVarHistoryRecord.TYPE));
                dvHistoryConfig.setTimeZone(BTimeZone.getLocal());
                dvHistoryId = dvHistoryConfig.getId();
                if (!conDB.exists(dvHistoryId)) {
                    conDB.createHistory(dvHistoryConfig);
                } else {
                    conDB.reconfigureHistory(dvHistoryConfig);
                }
            }
        } else if (t == BFuelMgmtHistoryRecord.TYPE) {
            if (fmHistoryId == null) {
                BHistoryConfig fmHistoryConfig = new BHistoryConfig(BHistoryId.make((String)Sys.getStation().getStationName(), (String)"TlsFmHistory"), BTypeSpec.make((Type)BFuelMgmtHistoryRecord.TYPE));
                fmHistoryConfig.setTimeZone(BTimeZone.getLocal());
                fmHistoryId = fmHistoryConfig.getId();
                if (!conDB.exists(fmHistoryId)) {
                    conDB.createHistory(fmHistoryConfig);
                } else {
                    conDB.reconfigureHistory(fmHistoryConfig);
                }
            }
        } else if (t == BInvReconcileRowRecord.TYPE) {
            if (irrHistoryId == null) {
                BHistoryConfig irrHistoryConfig = new BHistoryConfig(BHistoryId.make((String)Sys.getStation().getStationName(), (String)"TlsIrrHistory"), BTypeSpec.make((Type)BInvReconcileRowRecord.TYPE));
                irrHistoryConfig.setTimeZone(BTimeZone.getLocal());
                irrHistoryId = irrHistoryConfig.getId();
                if (!conDB.exists(irrHistoryId)) {
                    conDB.createHistory(irrHistoryConfig);
                } else {
                    conDB.reconfigureHistory(irrHistoryConfig);
                }
            }
        } else if (t == BInTankInvHistoryRecord.TYPE) {
            if (itiHistoryId == null) {
                BHistoryConfig itiHistoryConfig = new BHistoryConfig(BHistoryId.make((String)Sys.getStation().getStationName(), (String)"TlsItiHistory"), BTypeSpec.make((Type)BInTankInvHistoryRecord.TYPE));
                itiHistoryConfig.setTimeZone(BTimeZone.getLocal());
                itiHistoryId = itiHistoryConfig.getId();
                if (!conDB.exists(itiHistoryId)) {
                    conDB.createHistory(itiHistoryConfig);
                } else {
                    conDB.reconfigureHistory(itiHistoryConfig);
                }
            }
        } else if (t == BInTankStaHistoryRecord.TYPE) {
            if (itsHistoryId == null) {
                BHistoryConfig itsHistoryConfig = new BHistoryConfig(BHistoryId.make((String)Sys.getStation().getStationName(), (String)"TlsItsHistory"), BTypeSpec.make((Type)BInTankStaHistoryRecord.TYPE));
                itsHistoryConfig.setTimeZone(BTimeZone.getLocal());
                itsHistoryId = itsHistoryConfig.getId();
                if (!conDB.exists(itsHistoryId)) {
                    conDB.createHistory(itsHistoryConfig);
                } else {
                    conDB.reconfigureHistory(itsHistoryConfig);
                }
            }
        } else if (t == BLiqSenAlmHistoryRecord.TYPE) {
            if (lsaHistoryId == null) {
                BHistoryConfig lsaHistoryConfig = new BHistoryConfig(BHistoryId.make((String)Sys.getStation().getStationName(), (String)"TlsLsaHistory"), BTypeSpec.make((Type)BLiqSenAlmHistoryRecord.TYPE));
                lsaHistoryConfig.setTimeZone(BTimeZone.getLocal());
                lsaHistoryId = lsaHistoryConfig.getId();
                if (!conDB.exists(lsaHistoryId)) {
                    conDB.createHistory(lsaHistoryConfig);
                } else {
                    conDB.reconfigureHistory(lsaHistoryConfig);
                }
            }
        } else if (t == BPriAlmHisHistoryRecord.TYPE && pahHistoryId == null) {
            BHistoryConfig pahHistoryConfig = new BHistoryConfig(BHistoryId.make((String)Sys.getStation().getStationName(), (String)"TlsPahHistory"), BTypeSpec.make((Type)BPriAlmHisHistoryRecord.TYPE));
            pahHistoryConfig.setTimeZone(BTimeZone.getLocal());
            pahHistoryId = pahHistoryConfig.getId();
            if (!conDB.exists(pahHistoryId)) {
                conDB.createHistory(pahHistoryConfig);
            } else {
                conDB.reconfigureHistory(pahHistoryConfig);
            }
        }
    }

    public static void appendTlsHistory(BStruct newRec) {
        try {
            BIHistory history = null;
            if (newRec.getType() == BBirAdjDelHistoryRecord.TYPE) {
                history = conDB.getHistory(badHistoryId);
                conDB.append(history, (BIHistoryRecordSet)((BBirAdjDelHistoryRecord)newRec));
            } else if (newRec.getType() == BDelVarHistoryRecord.TYPE) {
                history = conDB.getHistory(dvHistoryId);
                conDB.append(history, (BIHistoryRecordSet)((BDelVarHistoryRecord)newRec));
            } else if (newRec.getType() == BFuelMgmtHistoryRecord.TYPE) {
                history = conDB.getHistory(fmHistoryId);
                conDB.append(history, (BIHistoryRecordSet)((BFuelMgmtHistoryRecord)newRec));
            } else if (newRec.getType() == BInvReconcileRowRecord.TYPE) {
                history = conDB.getHistory(irrHistoryId);
                conDB.append(history, (BIHistoryRecordSet)((BInvReconcileRowRecord)newRec));
            } else if (newRec.getType() == BInTankInvHistoryRecord.TYPE) {
                history = conDB.getHistory(itiHistoryId);
                conDB.append(history, (BIHistoryRecordSet)((BInTankInvHistoryRecord)newRec));
            } else if (newRec.getType() == BInTankStaHistoryRecord.TYPE) {
                history = conDB.getHistory(itsHistoryId);
                conDB.append(history, (BIHistoryRecordSet)((BInTankStaHistoryRecord)newRec));
            } else if (newRec.getType() == BLiqSenAlmHistoryRecord.TYPE) {
                history = conDB.getHistory(lsaHistoryId);
                conDB.append(history, (BIHistoryRecordSet)((BLiqSenAlmHistoryRecord)newRec));
            } else if (newRec.getType() == BPriAlmHisHistoryRecord.TYPE) {
                history = conDB.getHistory(pahHistoryId);
            }
            conDB.append(history, (BIHistoryRecordSet)((BPriAlmHisHistoryRecord)newRec));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BHistoryId getTlsHistoryId(Type t) {
        if (t == BBirAdjDelHistoryRecord.TYPE) {
            return badHistoryId;
        }
        if (t == BDelVarHistoryRecord.TYPE) {
            return dvHistoryId;
        }
        if (t == BFuelMgmtHistoryRecord.TYPE) {
            return fmHistoryId;
        }
        if (t == BInvReconcileRowRecord.TYPE) {
            return irrHistoryId;
        }
        if (t == BInTankInvHistoryRecord.TYPE) {
            return itiHistoryId;
        }
        if (t == BInTankStaHistoryRecord.TYPE) {
            return itsHistoryId;
        }
        if (t == BLiqSenAlmHistoryRecord.TYPE) {
            return lsaHistoryId;
        }
        if (t == BPriAlmHisHistoryRecord.TYPE) {
            return pahHistoryId;
        }
        return null;
    }

    public void setTlsHistoryId(Type t, BHistoryId historyId) {
        if (t == BBirAdjDelHistoryRecord.TYPE) {
            badHistoryId = historyId;
        } else if (t == BDelVarHistoryRecord.TYPE) {
            dvHistoryId = historyId;
        } else if (t == BFuelMgmtHistoryRecord.TYPE) {
            fmHistoryId = historyId;
        } else if (t == BInvReconcileRowRecord.TYPE) {
            irrHistoryId = historyId;
        } else if (t == BInTankInvHistoryRecord.TYPE) {
            itiHistoryId = historyId;
        } else if (t == BInTankStaHistoryRecord.TYPE) {
            itsHistoryId = historyId;
        } else if (t == BLiqSenAlmHistoryRecord.TYPE) {
            lsaHistoryId = historyId;
        } else if (t == BPriAlmHisHistoryRecord.TYPE) {
            pahHistoryId = historyId;
        }
    }

    public BHistoryDatabase getHistoryDatabase() {
        return historyDatabase;
    }

    public void setHistoryDatabase(BHistoryDatabase historyDatabase) {
        TlsHistoryHelper.historyDatabase = historyDatabase;
    }
}

